/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.tibco.WintellServiceHandlerRemote;
import cz.nextiraone.tmobile.wintell.WintellAction;
import cz.nextiraone.tmobile.wintell.WintellActionAttrValue;
import cz.nextiraone.tmobile.wintell.WintellActionButton;
import cz.nextiraone.tmobile.wintell.WintellActionClass;
import cz.nextiraone.tmobile.wintell.WintellActionClassAttr;
import cz.nextiraone.tmobile.wintell.WintellActionLog;
import cz.nextiraone.tmobile.wintell.WintellActionLogParam;
import cz.nextiraone.tmobile.wintell.WintellActionOutput;
import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.WintellOfferr2Action;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.GeneralEvent;
import cz.nextiraone.tmobile.wintell.events.NotifyAcceptCaseEvent;
import cz.nextiraone.tmobile.wintell.events.NotifySaveCaseEvent;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.tmobile.ei.wintell.datatypes.Campaign;
import cz.tmobile.ei.wintell.datatypes.Customer;
import cz.tmobile.ei.wintell.datatypes.CustomerStats;
import cz.tmobile.ei.wintell.datatypes.Subscriber;
import cz.tmobile.ei.wintell.datatypes.SubscriberStats;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class WintellActionHandle {
    private static final WintellLogger log = WintellLogger.getLogger(WintellActionHandle.class);
    protected static DateFormat yyyyMMddHHmmssFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected static DateFormat yyyyMMddFormat = new SimpleDateFormat("yyyyMMdd");
    protected static Pattern addMD = Pattern.compile("(\\d+)(m|d)");
    protected WintellActionContext actionContext;
    protected GeneralEvent request = null;
    protected WintellOfferActivity offerActivity = null;
    protected WintellActionButton button = null;
    protected EntityManager em = null;
    protected WintellServiceHandlerRemote wintellServices = null;
    private WintellActionLog actionLog = null;
    private Campaign campaign = null;

    public abstract String getErrorMessage();

    public abstract Subscriber getSubscriber();

    public abstract Customer getCustomer();

    public abstract CustomerStats getCustomerStats();

    public abstract SubscriberStats getSubscriberStats();

    public WintellActionHandle(EntityManager em, WintellServiceHandlerRemote wintellServices, WintellActionContext actionContext) {
        this.em = em;
        this.wintellServices = wintellServices;
        this.actionContext = actionContext;
    }

    public String getCampaignResponseTrackingCode() {
        log.info(this.actionContext, "campaign: " + this.campaign);
        if (this.campaign == null || this.campaign.getResponseTrackingCode() == null || this.campaign.getResponseTrackingCode().isNil()) {
            return null;
        }
        String responseTrackingCode = (String)this.campaign.getResponseTrackingCode().getValue();
        log.info(this.actionContext, "campaign.getResponseTrackingCode(): " + responseTrackingCode);
        return responseTrackingCode;
    }

    public String getCampaignDeliveryStatusByButton() {
        log.info(this.actionContext, "button: " + this.button);
        String status = null;
        if (this.button != null) {
            switch (this.button.getButtonId()) {
                case 2: {
                    status = "301";
                    break;
                }
                case 3: {
                    status = "302";
                    break;
                }
                case 4: {
                    status = "303";
                }
            }
        }
        log.info(this.actionContext, "getCampaignDeliveryStatusByButton(): " + status);
        return status;
    }

    public String getCampaignCycleId() {
        log.info(this.actionContext, "campaign: " + this.campaign);
        if (this.campaign == null || this.campaign.getCycleId() == null || this.campaign.getCycleId().isNil()) {
            return null;
        }
        String cycleId = "" + ((Double)this.campaign.getCycleId().getValue()).intValue();
        log.info(this.actionContext, "campaign.getCycleId(): " + cycleId);
        return cycleId;
    }

    public String getCampaignId() {
        if (this.campaign == null || this.campaign.getId() == null) {
            return null;
        }
        return "" + this.campaign.getId().intValue();
    }

    public String getCampaignNodeId() {
        if (this.campaign == null || this.campaign.getNodeId() == null || this.campaign.getNodeId().isNil()) {
            return null;
        }
        return "" + ((Double)this.campaign.getNodeId().getValue()).intValue();
    }

    public String getNULL() {
        return "__:NULL:__";
    }

    public String getUserPin() {
        if (this.request != null && this.request.getPin() != null) {
            return this.request.getPin();
        }
        return null;
    }

    public String getTibSendDatim() {
        return yyyyMMddHHmmssFormat.format(new Date());
    }

    public String getTibRoutingKey() {
        return null;
    }

    public String getTibProcessId() {
        if (this.actionLog == null) {
            return null;
        }
        Long ret = this.actionLog.getTibProcessId();
        return ret.toString();
    }

    public String getTibCorrelationId() {
        if (this.actionLog == null) {
            return null;
        }
        Long ret = this.actionLog.getActionLogId();
        return String.format("WIN-C-%012d", ret % 1000000000000L);
    }

    public String getExtidBa() {
        return null;
    }

    public String getExtidCo() {
        return null;
    }

    public String getExtidOu() {
        return null;
    }

    public String getExtidSu() {
        if (this.request != null && this.request.getObjectType() == 4) {
            return this.request.getObjectId();
        }
        return null;
    }

    public String getExtidCs() {
        if (this.request != null) {
            return this.request.getObjectId();
        }
        return null;
    }

    public String getCsType() {
        if (this.request != null) {
            return "" + this.request.getObjectType();
        }
        return null;
    }

    public String getInteractionId() {
        if (this.request == null) {
            return null;
        }
        return this.request.getInterid();
    }

    public String getMsisdn() {
        if (this.request != null && this.request.getObjectType() == 4) {
            return this.request.getMsisdn();
        }
        return null;
    }

    public String getOfferName() {
        try {
            return this.offerActivity.getOffer().getDescription();
        }
        catch (Exception er) {
            return null;
        }
    }

    public String getShortOfferName() {
        try {
            return this.offerActivity.getOffer().getShortDescription();
        }
        catch (Exception er) {
            return null;
        }
    }

    public String getSpecialAction() {
        return "Speci\u00e1ln\u00ed akce: " + this.getOfferName();
    }

    public String getOpenCaseID() {
        if (this.request instanceof NotifyAcceptCaseEvent) {
            NotifyAcceptCaseEvent req = (NotifyAcceptCaseEvent)this.request;
            return req.getCaseid();
        }
        if (this.request instanceof NotifySaveCaseEvent) {
            NotifySaveCaseEvent req = (NotifySaveCaseEvent)this.request;
            return req.getCaseid();
        }
        return this.wintellServices.getConfValue("ivcc.universalCaseId");
    }

    public String getMedium() {
        if (this.request instanceof NotifySaveCaseEvent) {
            NotifySaveCaseEvent req = (NotifySaveCaseEvent)this.request;
            return req.getMedia();
        }
        return this.wintellServices.getConfValue("ivcc.universalMediumId");
    }

    public String getAttrValue(WintellActionClassAttr a, WintellActionAttrValue ap) {
        String mName = null;
        if (ap != null) {
            if (!ap.isVarMapping()) {
                return ap.getValue();
            }
            mName = ap.getValue();
        } else {
            if (!a.isValueMapping()) {
                return a.getDefaultValue();
            }
            mName = a.getDefaultValue();
        }
        if (mName == null || mName.length() == 0) {
            log.error(this.actionContext, "cannot get attributeName mName=NULL or ''");
            return null;
        }
        return this.getAttrValue(mName);
    }

    public String getAttrValue(String allName) {
        return this.getAttrValue(allName, this, 0);
    }

    private String getAttrValue(String allName, Object o, int depth) {
        String mName = allName;
        String restName = null;
        Pattern misCons = Pattern.compile("(^[^.]+)\\.(.*)$");
        Matcher mamisCons = misCons.matcher(allName);
        if (mamisCons.matches()) {
            String attr = mamisCons.group(1);
            restName = mamisCons.group(2);
            mName = attr;
        }
        if (depth == 0) {
            if (mName.equals("property") && restName != null) {
                return this.wintellServices.getConfValue(restName);
            }
            if (mName.startsWith("now")) {
                return this.getDateInFromat(mName.substring(3));
            }
            if (mName.startsWith("=now+")) {
                String nx = mName.substring(5);
                Matcher m = addMD.matcher(nx);
                if (m.matches()) {
                    Integer len = Integer.parseInt(m.group(1));
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(new Date());
                    if (m.group(2).equals("m")) {
                        ((Calendar)cal).add(2, len);
                    } else {
                        ((Calendar)cal).add(6, len);
                    }
                    return yyyyMMddFormat.format(cal.getTime());
                }
                log.error(this.actionContext, "no attribute matches: " + mName);
                return null;
            }
        }
        Class[] argTypes = new Class[]{};
        Object[] theData = new Object[]{};
        mName = "get" + mName.substring(0, 1).toUpperCase() + mName.substring(1);
        Method get = null;
        try {
            get = o.getClass().getMethod(mName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            log.error(this.actionContext, String.valueOf(this.getClass().getSimpleName()) + "." + mName + "() cannot find in getAttrValue: " + ex.getMessage());
            return null;
        }
        Object io = null;
        try {
            io = get.invoke(o, theData);
        }
        catch (Exception e) {
            log.error(this.actionContext, String.valueOf(o.getClass().getSimpleName()) + "." + mName + "() cannot invoke");
            return null;
        }
        if (io == null) {
            return null;
        }
        if (io instanceof JAXBElement) {
            JAXBElement xV = (JAXBElement)io;
            if (xV.isNil()) {
                return null;
            }
            io = xV.getValue();
        }
        if (io instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar xGc = (XMLGregorianCalendar)io;
            io = xGc.toGregorianCalendar().getTime();
        }
        if (io instanceof Double || io instanceof Float) {
            if (restName == null) {
                restName = "%.2f";
            }
            if ("kb".equals(restName)) {
                io = new Double((Double)io) / 1024.0;
                restName = "%.0f";
            }
            if ("mb".equals(restName)) {
                io = new Double((Double)io) / 1024.0 / 1024.0;
                restName = "%.0f";
            }
            return String.format(restName, io);
        }
        if (io instanceof Long || io instanceof Integer) {
            io = new Double(((Long)io).longValue());
            if (restName == null) {
                restName = "%.0f";
            }
            if ("kb".equals(restName)) {
                io = new Double((Double)io) / 1024.0;
                restName = "%.0f";
            }
            if ("mb".equals(restName)) {
                io = new Double((Double)io) / 1024.0 / 1024.0;
                restName = "%.0f";
            }
            return String.format(restName, io);
        }
        if (io instanceof Date) {
            if (restName == null) {
                restName = "yyyy-MM-dd HH:mm:ss";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(restName);
            return dateFormat.format((Date)io);
        }
        if (io instanceof String) {
            return (String)io;
        }
        if (restName != null) {
            return this.getAttrValue(restName, io, depth + 1);
        }
        log.error(this.actionContext, String.valueOf(this.getClass().getSimpleName()) + "." + mName + "() return object of class:" + io.getClass().getName() + " instad of String");
        return null;
    }

    public WintellActionLog allocActionLog(WintellAction a, WintellActionOutput actionOutput) {
        WintellActionLog actionLog = new WintellActionLog();
        actionLog.setAction(a);
        this.setActionLogId(actionLog);
        actionOutput.addActionLog(actionLog);
        this.setOfferActivity(actionOutput.getOfferActivity());
        this.em.persist((Object)actionLog);
        WintellActionClass actionClass = a.getActionClass();
        for (WintellActionClassAttr ac : actionClass.getParams()) {
            String value = this.getAttrValue(ac, null);
            WintellActionLogParam ap = new WintellActionLogParam();
            ap.setAttr(ac);
            ap.setValue(value);
            WintellActionLogParam np = actionLog.addParamVal(ap, false);
            if (np == null) continue;
            this.em.persist((Object)np);
        }
        for (WintellActionAttrValue av : a.getParams()) {
            WintellActionClassAttr ac = av.getAttr();
            String value = this.getAttrValue(ac, av);
            if (value == null) continue;
            WintellActionLogParam ap = new WintellActionLogParam();
            ap.setAttr(ac);
            ap.setValue(value);
            WintellActionLogParam np = actionLog.addParamVal(ap, true);
            if (np == null) continue;
            this.em.persist((Object)np);
        }
        return actionLog;
    }

    public void setActionLogId(WintellActionLog actionLog) {
        this.actionLog = actionLog;
    }

    public WintellActionLog getActionLog() {
        return this.actionLog;
    }

    public void setRequest(GeneralEvent request) {
        this.request = request;
    }

    public WintellOfferActivity getOfferActivity() {
        return this.offerActivity;
    }

    public void setOfferActivity(WintellOfferActivity offerActivity) {
        this.offerActivity = offerActivity;
    }

    public WintellActionButton getButton() {
        return this.button;
    }

    public void setButton(WintellActionButton button) {
        this.button = button;
    }

    public GeneralEvent getRequest() {
        return this.request;
    }

    public String getDateInFromat(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(new Date());
    }

    public WintellActionOutput allocActionOutput(WintellOfferActivity oa, WintellActionButton b) {
        WintellActionOutput actionOutput = new WintellActionOutput();
        actionOutput.setOfferActivity(oa);
        actionOutput.setButton(b);
        actionOutput.setTs(new Date());
        actionOutput.setUsr(this.getUserName());
        this.em.persist((Object)actionOutput);
        this.setButton(b);
        log.info(this.actionContext, "OFFERACTIVITY_ID: " + oa.getOfferActivityId() + " allocActionOutput for OFFER: " + oa.getOffer().getOfferId() + "|" + oa.getOffer().getDescription());
        for (WintellOfferr2Action o2a : oa.getOffer().getActionButtons()) {
            if (!o2a.getButton().equals((Object)b)) continue;
            log.info(this.actionContext, "\tselect: [button: " + o2a.getButton().getButtonId() + "|" + o2a.getButton().getDescription() + "] " + ", action: " + o2a.getAction().getActionid() + "|" + o2a.getAction().getDescription());
            WintellAction a = o2a.getAction();
            if (a.getActionClass().getClassType().equals("TIBCO_MESSAGE") && a.getActionClass().getSubType().equals("businessEvent.subscriber.campaignDelivered.1")) {
                Integer mktCampId = -1;
                try {
                    for (WintellActionAttrValue av : a.getParams()) {
                        WintellActionClassAttr ac = av.getAttr();
                        if (ac.getName() == null || !ac.getName().equals("MKT_CAMP_ID") || av.getValue() == null) continue;
                        mktCampId = Integer.parseInt(av.getValue());
                        break;
                    }
                }
                catch (Exception e) {
                    log.error(this.actionContext, "java exeption in action: [actionId=" + a.getActionid() + "] doesn't contain value for MKT_CAMP_ID => remove from campaign is not possible", (Throwable)e);
                }
                if (mktCampId == -1) {
                    log.error(this.actionContext, "action: [actionId=" + a.getActionid() + "] doesn't contain value for MKT_CAMP_ID => remove from campaign is not possible");
                    continue;
                }
                boolean someCampaignFound = false;
                Subscriber su = this.getSubscriber();
                if (su != null && su.getCampaignList() != null) {
                    for (Campaign c : su.getCampaignList()) {
                        if (c.getMktId() != null && c.getMktId().getValue() != null) {
                            log.info(this.actionContext, "\t\tsearch campaign:" + c.getMktId().getValue());
                        } else {
                            log.info(this.actionContext, "\t\tsearch campaign mktId is not defined");
                        }
                        if (c.getMktId() == null || c.getMktId().getValue() == null || ((Double)c.getMktId().getValue()).intValue() != mktCampId.intValue()) continue;
                        if (c.getResponseTrackingCode() == null || c.getResponseTrackingCode().getValue() == null) {
                            log.info(this.actionContext, "\t\tsearch campaign mktId=" + mktCampId + " : skiping - not defined responseTrackingCode");
                            continue;
                        }
                        someCampaignFound = true;
                        this.setCampaign(c);
                        WintellActionLog al = this.allocActionLog(a, actionOutput);
                        log.info(this.actionContext, "\t\tadd action: " + al.getAction().getDescription());
                    }
                    this.setCampaign(null);
                }
                if (someCampaignFound) continue;
                log.error(this.actionContext, "action: [actionId=" + a.getActionid() + "] cannot find any campaign to send delete message for mktCampId=" + mktCampId);
                continue;
            }
            WintellActionLog al = this.allocActionLog(a, actionOutput);
            log.info(this.actionContext, "\t\tadd action: " + al.getAction().getDescription());
        }
        return actionOutput;
    }

    public String getUserName() {
        if (this.request == null) {
            return null;
        }
        if (this.request.getCh() != null && this.request.getCh().equals("CLARIFY")) {
            return this.request.getUsr();
        }
        return "SY_WINTELL_USER";
    }

    public String getExtidCu() {
        String cuId = null;
        try {
            Customer cu = this.getCustomer();
            cuId = cu.getId().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cuId;
    }

    public String getTariffDescription() {
        try {
            return this.getSubscriber().getTariff().getDescription();
        }
        catch (Exception er) {
            return null;
        }
    }

    public String getPreviousTariffDescription() {
        return "P\u0159edchoz\u00ed tarif: " + this.getTariffDescription();
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public void setCampaign(Campaign campaign) {
        this.campaign = campaign;
    }
}

