/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.tibco.WintellServiceHandlerRemote;
import cz.nextiraone.tmobile.wintell.WintellActionHandle;
import cz.nextiraone.tmobile.wintell.WintellTabData;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.NotifyAcceptCaseEvent;
import cz.nextiraone.tmobile.wintell.events.NotifyNewInteractionEvent;
import cz.nextiraone.tmobile.wintell.events.NotifySaveCaseEvent;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.tmobile.ei.wintell.datatypes.BillingArrangement;
import cz.tmobile.ei.wintell.datatypes.Customer;
import cz.tmobile.ei.wintell.datatypes.CustomerStats;
import cz.tmobile.ei.wintell.datatypes.MoreInfoResp;
import cz.tmobile.ei.wintell.datatypes.Subscriber;
import cz.tmobile.ei.wintell.datatypes.SubscriberStats;
import javax.persistence.EntityManager;

public class WintellActionHandleAgs
extends WintellActionHandle {
    private static final WintellLogger log = WintellLogger.getLogger(WintellActionHandleAgs.class);
    private static final String CASE_MEDUIUM_PERSONALLY = "268435560";
    private WintellTabData activeTab = null;

    public WintellActionHandleAgs(WintellTabData activeTab, EntityManager em, WintellServiceHandlerRemote wintellServices, WintellActionContext actionContext) {
        super(em, wintellServices, actionContext);
        this.activeTab = activeTab;
    }

    public WintellTabData getActiveTab() {
        return this.activeTab;
    }

    public void setActiveTabData(WintellTabData activeTab) {
        this.activeTab = activeTab;
    }

    @Override
    public SubscriberStats getSubscriberStats() {
        SubscriberStats su = null;
        try {
            su = this.activeTab.getMiResp().getSubscriber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return su;
    }

    @Override
    public CustomerStats getCustomerStats() {
        CustomerStats cu = null;
        try {
            cu = this.activeTab.getMiResp().getCustomer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cu;
    }

    @Override
    public Subscriber getSubscriber() {
        Subscriber su = null;
        try {
            su = (Subscriber)((BillingArrangement)this.activeTab.getRvaResponse().getResponseData().getBillingArrangementList().get(0)).getSubscriberList().get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return su;
    }

    @Override
    public Customer getCustomer() {
        Customer cu = null;
        try {
            cu = this.activeTab.getRvaResponse().getResponseData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cu;
    }

    public MoreInfoResp getMoreInfo() {
        if (this.activeTab == null) {
            return null;
        }
        return this.activeTab.getMiResp();
    }

    @Override
    public String getUserName() {
        if (this.request == null) {
            return null;
        }
        if (this.request.getCh() != null && this.request.getCh().equals("CLARIFY")) {
            return this.request.getUsr();
        }
        MoreInfoResp mi = this.getMoreInfo();
        if (mi != null && mi.getClfyUser() != null) {
            log.info(this.actionContext, "set CLFyUser=" + mi.getClfyUser());
            return mi.getClfyUser();
        }
        log.info(this.actionContext, "cannot get CLFyUser(PIN=" + this.getUserPin() + ")->fallback");
        if (this.activeTab == null) {
            return "SY_WINTELL_USER";
        }
        return this.activeTab.getDefaultClfyUser();
    }

    public String getCaseMediumId() {
        if (this.request.getCh() != null && this.request.getCh().equals("CUI")) {
            return CASE_MEDUIUM_PERSONALLY;
        }
        if (this.request instanceof NotifySaveCaseEvent) {
            NotifySaveCaseEvent c = (NotifySaveCaseEvent)this.request;
            return c.getMedia();
        }
        if (this.request instanceof NotifyAcceptCaseEvent) {
            NotifyAcceptCaseEvent c = (NotifyAcceptCaseEvent)this.request;
            return c.getMedia();
        }
        if (this.request instanceof NotifyNewInteractionEvent) {
            NotifyNewInteractionEvent c = (NotifyNewInteractionEvent)this.request;
            return c.getMedia();
        }
        return null;
    }

    @Override
    public String getMsisdn() {
        String ret = super.getMsisdn();
        if (ret != null && !"".equals(ret)) {
            return ret;
        }
        Subscriber su = this.getSubscriber();
        if (su == null) {
            return null;
        }
        return su.getMsisdn();
    }

    @Override
    public String getErrorMessage() {
        String errorMessage = null;
        try {
            errorMessage = this.activeTab.getErrorMessage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return errorMessage;
    }
}

