/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.WintellActionClass;
import cz.nextiraone.tmobile.wintell.WintellActionLog;
import cz.nextiraone.tmobile.wintell.WintellActionOutput;
import cz.nextiraone.tmobile.wintell.WintellHandler;
import cz.nextiraone.tmobile.wintell.WintellHandlerException;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;

public class WintellActionOutputHandler
implements Serializable {
    private static final long serialVersionUID = -498998640217500048L;
    private static final WintellLogger log = WintellLogger.getLogger(WintellActionOutputHandler.class);

    public String makeOutput(List<WintellActionOutput> aoList, List<WintellHandler> handlers, EntityManager em, WintellActionContext actionContext) {
        for (WintellActionOutput ao : aoList) {
            log.info(actionContext, "[OFFER_ID:" + ao.getOfferActivity().getOffer().getOfferId() + "]OfferActivity id=" + ao.getOfferActivity().getOfferActivityId() + " [on button: " + ao.button.getDescription() + "]");
            for (WintellActionLog al : ao.getActions()) {
                WintellActionClass ac = al.getAction().getActionClass();
                log.info(actionContext, "\taction:" + al.getAction().getActionid() + "|" + al.getAction().getDescription() + "[class:" + ac.getClassType() + "/" + ac.getSubType() + "]");
                try {
                    boolean handled = false;
                    for (WintellHandler h : handlers) {
                        if (!h.handle(em, al)) continue;
                        handled = true;
                        break;
                    }
                    if (handled) continue;
                    log.fatal(actionContext, "No hahdler for action: " + al.getAction().getActionid() + "|" + al.getAction().getDescription() + "[class:" + ac.getClassType() + "/" + ac.getSubType() + "]");
                }
                catch (WintellHandlerException e) {
                    log.fatal(actionContext, "Exception while handling action " + al.getAction().getActionid() + "|" + al.getAction().getDescription() + "[class:" + ac.getClassType() + "/" + ac.getSubType() + "]", (Throwable)e);
                }
            }
        }
        return null;
    }
}

