/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.IAGSBlaze;
import cz.nextiraone.tmobile.wintell.WintellDeployServiceManagement;
import cz.nextiraone.tmobile.wintell.ags.model.BillingArrangement;
import cz.nextiraone.tmobile.wintell.ags.model.CallCentre;
import cz.nextiraone.tmobile.wintell.ags.model.Customer;
import cz.nextiraone.tmobile.wintell.ags.model.Request;
import cz.nextiraone.tmobile.wintell.ags.model.Subscriber;
import cz.nextiraone.tmobile.wintell.ags.model.User;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.context.WintellSystemActionContext;
import cz.nextiraone.tmobile.wintell.exceptions.WintellAppException;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.tmobile.ei.wintell.datatypes.Tariff;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Startup
@Singleton(name="wintell/WintellDeployService")
@Remote(value={WintellDeployServiceManagement.class})
public class WintellDeployService
implements WintellDeployServiceManagement {
    private static final WintellLogger log = WintellLogger.getLogger(WintellDeployService.class);
    private static final WintellActionContext systemActionContext = new WintellSystemActionContext(WintellSubprojectEnum.NONE);
    @EJB(name="AGSBlaze")
    private IAGSBlaze agsBlaze;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void run() {
        try {
            log.info(systemActionContext, "Run first call of AGSBean");
            this.callAGSBean(systemActionContext);
            log.info(systemActionContext, "First call of AGSBean succed");
        }
        catch (Exception e) {
            log.fatal(systemActionContext, "First call of AGSBean failed", (Throwable)e);
        }
        log.info(systemActionContext, "End of WintellDeployService.run");
    }

    private void callAGSBean(WintellActionContext ctx) throws WintellAppException {
        Request req = new Request();
        req.setId(0L);
        Customer cu = new Customer();
        CallCentre callCentre = new CallCentre();
        callCentre.setServiceLevel(0);
        cu.setCallCentre(callCentre);
        Tariff t = new Tariff();
        t.setCode("0000");
        t.setDescription("testTarriff");
        BillingArrangement ba = new BillingArrangement();
        cu.getBillingArrangementList().add(ba);
        Subscriber su = new Subscriber();
        ba.getSubscriberList().add(su);
        User user = new User();
        user.setId(-1);
        user.setName("TEST_USER");
        boolean salesCoord = false;
        user.setSalesCoord(salesCoord);
        boolean salesRep = false;
        user.setSalesRep(salesRep);
        req.setCuiHook("");
        req.setCustomer(cu);
        req.setUser(user);
        req.setRequestDatetime(new Date());
        this.agsBlaze.invokefindCallerDebugEP("AGSProduction", req, ctx);
    }

    @PostConstruct
    public void postconstruct() {
        this.run();
    }
}

