/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.IWintellHistoryManager;
import cz.nextiraone.tmobile.wintell.IWintellTabs;
import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.utils.HttpSessionContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.faces.context.FacesContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import org.jboss.ejb3.annotation.Clustered;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Synchronized;
import org.jboss.seam.annotations.web.RequestParameter;

@Stateful(name="wintellHistoryManager")
@Clustered
@Scope(value=ScopeType.SESSION)
@Name(value="wintellHistoryManager")
@Synchronized
public class WintellHistoryManager
implements Serializable,
IWintellHistoryManager {
    private static final long serialVersionUID = -3010041644412002451L;
    private static final WintellLogger log = WintellLogger.getLogger(WintellHistoryManager.class);
    @In(create=true)
    @Out(scope=ScopeType.SESSION)
    private HttpSessionContext httpSessionContext = new HttpSessionContext();
    @RequestParameter(value="objectId")
    private String objectId;
    @PersistenceContext(unitName="wintell", type=PersistenceContextType.EXTENDED)
    private EntityManager em;
    @In(scope=ScopeType.SESSION, value="wintellTabs", required=true)
    private IWintellTabs wTabs;
    private Boolean showAccepted;
    private Boolean showOffered;
    private Boolean showDeclined;
    private Boolean showMessages;
    Date historyFrom;
    Date historyTo;
    String fullText;
    String defaultObjectId;
    int defaultObjectType;
    private ArrayList<WintellOfferActivity> selectedActivities = new ArrayList();
    private List<WintellOfferActivity> allActivities = null;

    @Override
    @Begin
    public String setup() {
        log.info((WintellActionContext)this.httpSessionContext, "@Begin");
        return "";
    }

    @Override
    @End
    public String clear() {
        log.info((WintellActionContext)this.httpSessionContext, "@End");
        return "";
    }

    @Override
    @Destroy
    @Remove
    public void destroy() {
        log.info((WintellActionContext)this.httpSessionContext, "@Desroy @Remove");
    }

    public WintellHistoryManager() {
        log.info((WintellActionContext)this.httpSessionContext, "constructor");
        this.initValues();
    }

    private void initValues() {
        GregorianCalendar cal = null;
        cal = new GregorianCalendar();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        this.setHistoryFrom(cal.getTime());
        cal = new GregorianCalendar();
        cal.setTime(new Date());
        ((Calendar)cal).add(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        this.setHistoryTo(cal.getTime());
        this.setShowAccepted(true);
        this.setShowOffered(true);
        this.setShowDeclined(true);
        this.setShowMessages(true);
    }

    private void refreshList() {
        boolean someSelected = this.getShowAccepted() | this.getShowOffered() | this.getShowDeclined() | this.getShowMessages();
        Query q = this.em.createQuery("SELECT x FROM WintellOfferActivity x where x.objectId = :objectId  and x.objectType = :objectType  and x.dateTime >= :timeFrom and x.dateTime <= :timeTo" + (!someSelected ? "" : String.valueOf(this.getShowAccepted() != false ? "" : " and x.accepted=0") + (this.getShowOffered() != false ? "" : " and x.offered=0") + (this.getShowDeclined() != false ? "" : " and x.declined=0") + (this.getShowMessages() != false ? "" : " and x.offer.offerType!='Text'") + " and (x.someButtonPressed=1" + (this.getShowMessages() == false ? "" : " or x.offer.offerType='Text'") + ")") + (this.getFullText() == null || this.getFullText().equals("") ? "" : " and LOWER(x.offer.description) like LOWER(:fullTextLike)"));
        q.setParameter("timeFrom", (Object)this.historyFrom).setParameter("timeTo", (Object)this.historyTo);
        q.setParameter("objectId", (Object)this.defaultObjectId).setParameter("objectType", (Object)this.defaultObjectType);
        if (this.getFullText() != null && !this.getFullText().equals("")) {
            q.setParameter("fullTextLike", (Object)("%" + this.fullText + "%"));
        }
        this.allActivities = q.getResultList();
    }

    @Override
    public String filter() {
        log.info((WintellActionContext)this.httpSessionContext, "HistoryFrom:" + this.historyFrom);
        log.info((WintellActionContext)this.httpSessionContext, "filter objId:" + this.defaultObjectId);
        this.refreshList();
        return "history";
    }

    @Override
    public List<WintellOfferActivity> getAllActivities() {
        log.info((WintellActionContext)this.httpSessionContext, "getSelectedObject(objectId=" + this.objectId + ")");
        if (this.objectId != null) {
            String[] a = this.objectId.split(":");
            this.defaultObjectId = a[1];
            this.defaultObjectType = Integer.parseInt(a[0]);
            this.initValues();
            this.refreshList();
        }
        return this.allActivities;
    }

    @Override
    public Date getHistoryFrom() {
        return this.historyFrom;
    }

    @Override
    public void setHistoryFrom(Date historyFrom) {
        this.historyFrom = historyFrom;
    }

    @Override
    public Date getHistoryTo() {
        return this.historyTo;
    }

    @Override
    public void setHistoryTo(Date historyTo) {
        this.historyTo = historyTo;
    }

    @Override
    public String getFullText() {
        return this.fullText;
    }

    @Override
    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    @Override
    public ArrayList<WintellOfferActivity> getSelectedActivities() {
        return this.selectedActivities;
    }

    @Override
    public void setSelectedActivities(ArrayList<WintellOfferActivity> selectedActivities) {
        this.selectedActivities = selectedActivities;
    }

    @Override
    public Boolean getShowAccepted() {
        return this.showAccepted;
    }

    @Override
    public void setShowAccepted(Boolean showAccepted) {
        this.showAccepted = showAccepted;
    }

    @Override
    public Boolean getShowOffered() {
        return this.showOffered;
    }

    @Override
    public void setShowOffered(Boolean showOffered) {
        this.showOffered = showOffered;
    }

    @Override
    public Boolean getShowDeclined() {
        return this.showDeclined;
    }

    @Override
    public void setShowDeclined(Boolean showDeclined) {
        this.showDeclined = showDeclined;
    }

    @Override
    public Boolean getShowMessages() {
        return this.showMessages;
    }

    @Override
    public void setShowMessages(Boolean showMessages) {
        this.showMessages = showMessages;
    }

    @Override
    public String checkSession() {
        log.info((WintellActionContext)this.httpSessionContext, "checkSession called");
        if (!this.wTabs.isLogged()) {
            log.error((WintellActionContext)this.httpSessionContext, "!wTabs.isLogged()");
            return "session-expired";
        }
        log.info((WintellActionContext)this.httpSessionContext, "checkSession OK");
        return "";
    }

    @Override
    public String getObjectTitle() {
        try {
            return this.wTabs.getActiveTab().getTabTitle();
        }
        catch (Exception e) {
            log.error((WintellActionContext)this.httpSessionContext, "in getObjectTitle()", (Throwable)e);
            return "";
        }
    }

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            HttpServletRequest req = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            this.objectId = req.getParameter("objectId");
            if (log.isDebugEnabled()) {
                log.debug((WintellActionContext)this.httpSessionContext, "aroundInvoke:" + ctx.getMethod() + ", this=" + this);
            }
        }
        try {
            if (facesContext != null) {
                if (this.wTabs != null) {
                    try {
                        this.wTabs.isLogged();
                    }
                    catch (Exception e1) {
                        log.error((WintellActionContext)this.httpSessionContext, "reset wintellTabs=null, because [" + e1.getClass().getName() + "]: " + e1.getMessage(), (Throwable)e1);
                        this.wTabs = null;
                    }
                }
                if (this.wTabs == null) {
                    this.wTabs = (IWintellTabs)Component.getInstance((String)"wintellTabs", (ScopeType)ScopeType.SESSION, (boolean)true);
                }
            }
            return ctx.proceed();
        }
        catch (Exception e2) {
            log.error((WintellActionContext)this.httpSessionContext, "uncatched exeption[class=" + e2.getClass().getSimpleName() + "]:" + e2.getMessage(), (Throwable)e2);
            throw e2;
        }
    }
}

