/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.IWintellJmsSender;
import cz.nextiraone.tmobile.wintell.exceptions.WintellAppException;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.transaction.UserTransaction;
import org.jboss.seam.annotations.Name;

@Stateless(name="wintellJmsSender")
@TransactionManagement(value=TransactionManagementType.BEAN)
@Name(value="wintellJmsSender")
public class WintellJmsSender
implements IWintellJmsSender,
Serializable {
    private static final long serialVersionUID = 3147200779660710932L;
    @Resource(mappedName="java:/JmsXA")
    private transient ConnectionFactory connFactory;
    @Resource(mappedName="java:jboss/queue/wintell/WintellMonitorQueue")
    private transient Queue monitoringQueue;
    @EJB(lookup="java:jboss/queue/wintell/BlazeLogQueue")
    private Queue statsQueue;
    @Resource
    UserTransaction ut;

    @Override
    public void sendMessage(String queue, Serializable m, String jmsCorrelationID) throws WintellAppException {
        Connection connection = null;
        Session session = null;
        MessageProducer sender = null;
        try {
            try {
                this.ut.setTransactionTimeout(10);
                this.ut.begin();
                connection = this.connFactory.createConnection();
                session = connection.createSession(true, 1);
                Queue q = null;
                q = "monitoringQueue".compareTo(queue) == 0 ? this.monitoringQueue : this.statsQueue;
                sender = session.createProducer((Destination)q);
                ObjectMessage message = session.createObjectMessage(m);
                if (jmsCorrelationID != null) {
                    message.setJMSCorrelationID(jmsCorrelationID);
                }
                sender.setDeliveryMode(1);
                sender.send((Message)message);
                this.ut.commit();
            }
            catch (Exception er) {
                try {
                    if (this.ut.getStatus() != 4) {
                        this.ut.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (er instanceof WintellAppException) {
                    throw (WintellAppException)er;
                }
                throw new WintellAppException(er);
            }
        }
        finally {
            if (sender != null) {
                try {
                    sender.close();
                }
                catch (Exception exception) {}
            }
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

