/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.tibco.WintellServiceHandlerRemote;
import cz.nextiraone.tmobile.wintell.IWintellObjectManager;
import cz.nextiraone.tmobile.wintell.IWintellSessionManager;
import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.WintellOfferActivityButtons;
import cz.nextiraone.tmobile.wintell.WintellOfferActivityCategory;
import cz.nextiraone.tmobile.wintell.WintellStats;
import cz.nextiraone.tmobile.wintell.WintellTabRequestCache;
import cz.nextiraone.tmobile.wintell.context.DefaultWintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.AgsEvent;
import cz.nextiraone.tmobile.wintell.events.GeneralEvent;
import cz.nextiraone.tmobile.wintell.exceptions.WintellException;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.logger.identifiers.LogIdFactory;
import cz.nextiraone.tmobile.wintell.utils.HttpSessionContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

@Stateful(name="wintellObjectManager")
@Name(value="wintellObjectManager")
@Scope(value=ScopeType.EVENT)
public class WintellObjectManager
implements Serializable,
IWintellObjectManager,
SessionSynchronization {
    public static final int ERROR_OFFER_CATEGORY_ID = -101;
    public static final int ERROR_OFFER_ID_MSISDN_NOT_FOUND = -101;
    public static final int ERROR_OFFER_ID_NO_OFFER_FOUND = -102;
    public static final int ERROR_OFFER_ID_TIMEOUT = -103;
    public static final int ERROR_OFFER_ID_GATHERING_ERROR = -104;
    public static final int ERROR_OFFER_ID_NO_OFFER_EXISTS = -105;
    public static final int ERROR_OFFER_ID_BLAZE_ERROR = -106;
    public static final int ERROR_CODE_UNKNOWN = -1;
    public static final int ERROR_CODE_BAD_TIME = -2;
    public static final int ERROR_CODE_INVALID_TIMESTAMP = -3;
    public static final int ERROR_CODE_BAD_AUTH = -4;
    public static final int ERROR_CODE_BAD_OBJECT = -5;
    public static final int ERROR_CODE_SKIPP_DG = -6;
    public static final int ERROR_CODE_SKIPP_AUTH = -7;
    public static final int ERROR_CODE_SKIPP_TABS = -8;
    public static final int ERROR_CODE_SKIPP_ALL = -9;
    public static final int ERROR_CODE_OVERLOADED = -10;
    public static final int ERROR_CODE_SESSION_EXPIRED = -11;
    public static final int ERROR_CODE_OK = 0;
    public static final String OUTCOME_KNOWN_ERROR = "known-error";
    public static final String OUTCOME_SUCCESS = "success";
    public static final String OUTCOME_NOAUTH = "noauth";
    public static final String OUTCOME_SESSION_EXPIRED = "session-expired";
    public static final String OUTCOME_WINTELL_TABS = "wintell-tabs";
    public static final int OBJECT_TYPE_SU = 4;
    private static final long serialVersionUID = -6025441340095424234L;
    private static final WintellLogger log = WintellLogger.getLogger(WintellObjectManager.class);
    private HttpSessionContext httpSessionContext = new HttpSessionContext();
    @EJB(lookup="java:global/wintell-tibco/wintell-tibco/wintell/WintellServiceHandler")
    private transient WintellServiceHandlerRemote handler;
    @EJB(name="wintellSessionManager")
    private transient IWintellSessionManager sm;
    @Resource
    private SessionContext sctx;
    private String debugInfo = "";
    private WintellStats stats;
    private boolean eventRequest = false;
    private boolean showErrorTab;
    private String lastError;
    private boolean debugEvent;
    private Set<Integer> foldedCategories = new HashSet<Integer>();
    private String activeTabId = null;
    LinkedHashMap<String, WintellTabRequestCache> tabsCache = new LinkedHashMap();
    List<String> tabIds = new ArrayList<String>();
    private TreeMap<String, String> requestParams;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void logEvent(AgsEvent e, Object data, String type, String state, WintellActionContext ctx, WintellStats.RequestState endState, WintellStats.RequestState startState) {
        if (this.stats == null) {
            log.error(ctx, "logEvent() called on stats=null object");
            return;
        }
        if (endState != null) {
            this.stats.stopState(endState, ctx);
        }
        this.logEvent(e, data, type, state, ctx);
        if (startState != null) {
            this.stats.startState(startState, ctx);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void logEvent(AgsEvent e, Object data, String type, String state, WintellActionContext ctx) {
        if (this.stats == null) {
            log.error((WintellActionContext)this.httpSessionContext, "logEvent() called on stats=null object");
            return;
        }
        if (!this.isDebugEvent() && this.handler.isConfValueTrue("ags.skippLogRequest")) {
            return;
        }
        if (!this.isDebugEvent() && this.handler.isConfValueTrue("ags.skippLogRequestData")) {
            data = "";
        }
        this.stats.logEvent((GeneralEvent)e, data, type, state, ctx);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String setErrcodeOK(String ret) {
        if (OUTCOME_SUCCESS.equals(ret)) {
            this.stats.setErrCodeOK();
        }
        return ret;
    }

    private void checkStats() {
        if (this.stats == null) {
            this.stats = new WintellStats("AGS", !this.handler.isConfValueTrue("ags.skippLogRequest"), !this.handler.isConfValueTrue("ags.skippStats"));
            this.stats.startRequest((WintellActionContext)this.httpSessionContext);
        }
    }

    private void checkSM() {
        if (this.sm == null) {
            try {
                InitialContext c = new InitialContext();
                this.sm = (IWintellSessionManager)c.lookup("java:app/wintell.jar/wintellSessionManager");
            }
            catch (NamingException e1) {
                log.error((WintellActionContext)this.httpSessionContext, "cannot find sessionManager", (Throwable)e1);
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<String> getTabIds() {
        return this.tabIds;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isShowErrorTab() {
        return this.showErrorTab;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String getError() {
        return this.lastError;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isDebugEvent() {
        return this.debugEvent;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setDebugEvent(boolean debugEvent) {
        this.debugEvent = debugEvent;
    }

    @PostConstruct
    public void postConstruct() {
        log.info((WintellActionContext)this.httpSessionContext, "@PostConstruct: this=" + this);
    }

    @PostActivate
    public void postActivate() {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "@PostActivate: this=" + this);
        }
    }

    @PrePassivate
    public void prePassivate() {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "@PrePassivate: this=" + this);
        }
    }

    @PreDestroy
    public void preDestroy() {
        log.info((WintellActionContext)this.httpSessionContext, "@PreDesroy: this=" + this);
    }

    @Override
    @Remove
    public void remove() {
        log.info((WintellActionContext)this.httpSessionContext, "@Remove: this=" + this);
    }

    @Override
    @Destroy
    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "@Destroy: this=" + this);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isShowDebugButton() {
        return this.handler.isConfValueTrueDefaultTrue("ags.showDebugButton");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String getDebugInfo() {
        return this.debugInfo;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void startRequest(String url) {
        this.eventRequest = false;
        this.stats.addFlag("URL", url);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void startRendering() {
        this.stats.startState(WintellStats.RequestState.RENDERING_RESPONSE, (WintellActionContext)this.httpSessionContext);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void prepare(LinkedHashMap<String, WintellTabRequestCache> tabsCache, boolean showErrorTab, String lastError, boolean debugEvent, String activeTabId) {
        this.showErrorTab = showErrorTab;
        this.lastError = lastError;
        this.debugEvent = debugEvent;
        this.activeTabId = activeTabId;
        this.tabsCache = tabsCache;
        this.tabIds = new ArrayList<String>();
        for (String x : tabsCache.keySet()) {
            this.tabIds.add(x);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void stopRequest() {
        try {
            this.debugInfo = null;
            this.tabsCache.clear();
            if (this.stats == null) {
                log.error((WintellActionContext)this.httpSessionContext, "stopRequest() called on stats=null object");
            } else {
                this.stats.stopState(WintellStats.RequestState.RENDERING_RESPONSE, (WintellActionContext)this.httpSessionContext);
                this.stats.stopRequest((WintellActionContext)this.httpSessionContext, this.eventRequest);
                this.stats = null;
            }
            if (this.requestParams != null) {
                this.requestParams.clear();
                this.requestParams = null;
            }
        }
        catch (Exception e) {
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception in stopRequest()", (Throwable)e);
        }
    }

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "aroundInvoke:" + ctx.getMethod() + ", this=" + this);
        }
        if (ctx.getMethod().getAnnotation(Destroy.class) == null && ctx.getMethod().getAnnotation(Remove.class) == null) {
            this.checkStats();
            this.checkSM();
        }
        return ctx.proceed();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        long t = new Date().getTime();
        stream.defaultReadObject();
        log.info((WintellActionContext)this.httpSessionContext, "readObject:time=" + (new Date().getTime() - t));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        long t = new Date().getTime();
        stream.defaultWriteObject();
        log.info((WintellActionContext)this.httpSessionContext, "writeObject:time=" + (new Date().getTime() - t));
    }

    private WintellTabRequestCache getC(String objIdStr) {
        WintellTabRequestCache ret = this.tabsCache.get(objIdStr);
        if (ret == null) {
            log.error((WintellActionContext)this.httpSessionContext, "cannot find tab for: " + objIdStr, new Throwable());
            long sessionId = -1L;
            String tabTitle = "ERROR: neexistuj\u00edc\u00ed " + objIdStr;
            DefaultWintellActionContext actionContext = this.httpSessionContext.getMoreSpecificContext(LogIdFactory.createWintellSessionId((long)sessionId));
            ret = new WintellTabRequestCache(sessionId, tabTitle, true, (WintellActionContext)actionContext);
            this.tabsCache.put(objIdStr, ret);
        }
        return ret;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isSubmitable(String objIdStr) throws WintellException {
        try {
            return this.sm.isSubmitable(this.getC(objIdStr));
        }
        catch (Exception e) {
            WintellException er = new WintellException(e);
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception", (Throwable)e);
            throw er;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<WintellOfferActivity> getAllOffers(String objIdStr) throws WintellException {
        try {
            return this.sm.getAllOffers(this.getC(objIdStr));
        }
        catch (Exception e) {
            WintellException er = new WintellException(e);
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception", (Throwable)e);
            throw er;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<WintellOfferActivity> getAllMessages(String objIdStr) throws WintellException {
        try {
            return this.sm.getAllMessages(this.getC(objIdStr));
        }
        catch (Exception e) {
            WintellException er = new WintellException(e);
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception", (Throwable)e);
            throw er;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<WintellOfferActivityCategory> getAllCategories(String objIdStr) throws WintellException {
        try {
            return this.sm.getAllCategories(this.getC(objIdStr));
        }
        catch (Exception e) {
            WintellException er = new WintellException(e);
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception", (Throwable)e);
            throw er;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<AgsEvent> getSessionEvents(String objIdStr) throws WintellException {
        try {
            return this.sm.getSessionEvents(this.getC(objIdStr));
        }
        catch (Exception e) {
            WintellException er = new WintellException(e);
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception", (Throwable)e);
            throw er;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String getTabTitle(String objIdStr) throws WintellException {
        try {
            WintellTabRequestCache t = this.getC(objIdStr);
            return t.getTabTitle();
        }
        catch (Exception e) {
            WintellException er = new WintellException(e);
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception", (Throwable)e);
            throw er;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isFocus() throws WintellException {
        String objIdStr;
        boolean ret;
        block10: {
            block9: {
                block8: {
                    block7: {
                        if (!this.eventRequest) {
                            return false;
                        }
                        ret = true;
                        try {
                            if (!this.handler.isConfValueTrue("ags.skippRenderingAllTabs")) break block7;
                            return false;
                        }
                        catch (Exception e) {
                            WintellException er = new WintellException(e);
                            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception", (Throwable)e);
                            throw er;
                        }
                    }
                    objIdStr = this.activeTabId;
                    if (objIdStr != null) break block8;
                    log.error((WintellActionContext)this.httpSessionContext, "isFocus() -> cannot get activeTab");
                    return false;
                }
                if (!"errorTab".equals(objIdStr)) break block9;
                return false;
            }
            if (!"???".equals(objIdStr)) break block10;
            return false;
        }
        ret = this.sm.isFocus(this.getC(objIdStr));
        log.info((WintellActionContext)this.httpSessionContext, "isFocus() -> " + ret);
        return ret;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isHideMoreInfo() throws WintellException {
        try {
            String objIdStr = this.activeTabId;
            WintellTabRequestCache t = this.getC(objIdStr);
            if (t.isHideMoreInfo()) {
                log.info((WintellActionContext)this.httpSessionContext, "HideMoreInfo: activeTabId=" + this.activeTabId);
                return true;
            }
        }
        catch (Exception e) {
            WintellException er = new WintellException(e);
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception", (Throwable)e);
            throw er;
        }
        return false;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public WintellOfferActivityButtons getButtons(String objIdStr, long offerActivityId) throws WintellException {
        WintellTabRequestCache t;
        block3: {
            try {
                t = this.getC(objIdStr);
                if (t != null) break block3;
                return null;
            }
            catch (Exception e) {
                WintellException er = new WintellException(e);
                log.error((WintellActionContext)this.httpSessionContext, "unhandled exception", (Throwable)e);
                throw er;
            }
        }
        return t.getButtons(offerActivityId);
    }

    public void afterBegin() throws EJBException, RemoteException {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "{ afterBegin: this=" + this + ",handle=" + this.sctx);
        }
    }

    public void afterCompletion(boolean succ) throws EJBException, RemoteException {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "} afterCompletion(" + succ + "):" + " this=" + this);
        }
    }

    public void beforeCompletion() throws EJBException, RemoteException {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "beforeCompletion: this=" + this + ",handle=" + this.sctx);
        }
    }

    public WintellStats getStats() {
        return this.stats;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setEventRequest(boolean isDebugEvent) {
        this.eventRequest = true;
        this.debugEvent = isDebugEvent;
        if (isDebugEvent) {
            this.stats.setDoLog(true);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void addDebugInfo(String string) {
        this.debugInfo = String.valueOf(this.debugInfo) + string + "\n";
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void addFlag(String key, String value) {
        this.stats.addFlag(key, value);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setRequestSendTime(Date ts) {
        this.stats.setRequestSendTime(ts);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void startState(WintellStats.RequestState state, WintellActionContext ctx) {
        this.stats.startState(state, ctx);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void stopState(WintellStats.RequestState state, WintellActionContext ctx) {
        this.stats.stopState(state, ctx);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setErrCode(int errorCode) {
        this.stats.setErrCode(errorCode);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void addStats(WintellStats stats) {
        this.stats.merge(stats);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isLogSend() {
        return this.stats.isLogSend();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setButtons(String objIdStr, Map<Long, WintellOfferActivityButtons> buttons) {
        try {
            WintellTabRequestCache t = this.getC(objIdStr);
            t.setButtons(buttons);
            if (log.isDebugEnabled()) {
                this.sm.debugSetButtons(objIdStr, buttons);
            }
        }
        catch (Exception e) {
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception", (Throwable)e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void failStatsAndLogs() {
        try {
            this.stats.failStatsAndLogs();
        }
        catch (Exception e) {
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception in setDoStats()", (Throwable)e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public TreeMap<String, String> getRequestParams() {
        return this.requestParams;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setRequestParams(TreeMap<String, String> mo) {
        this.requestParams = mo;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setFolderCategories(Set<Integer> foldedCategories) {
        this.foldedCategories = foldedCategories;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Set<Integer> getFolderCategories() {
        return this.foldedCategories;
    }
}

