/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.IRequestBean;
import cz.nextiraone.tmobile.wintell.IWintellObjectManager;
import cz.nextiraone.tmobile.wintell.context.DefaultWintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.utils.HttpSessionContext;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WintellPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 3699080672353005624L;
    private static final WintellLogger log = WintellLogger.getLogger(WintellPhaseListener.class);

    public WintellActionContext getCtx(PhaseEvent e) {
        FacesContext facesContext = e.getFacesContext();
        Object o = facesContext.getExternalContext().getSession(false);
        if (o instanceof HttpSession) {
            return new HttpSessionContext((HttpSession)o);
        }
        return new DefaultWintellActionContext(WintellSubprojectEnum.AGS);
    }

    public void setJsessionIdPersistent(PhaseEvent e) {
        FacesContext facesContext = e.getFacesContext();
        Object o = facesContext.getExternalContext().getSession(false);
        if (o instanceof HttpSession) {
            String sessionId = ((HttpSession)o).getId();
            Object fo = facesContext.getExternalContext().getResponse();
            if (fo instanceof HttpServletResponse) {
                HttpServletResponse resp = (HttpServletResponse)fo;
                Cookie userCookie = new Cookie("JSESSIONID", sessionId);
                userCookie.setMaxAge(3600);
                resp.addCookie(userCookie);
            }
        }
    }

    public void removeOm(PhaseEvent e) {
        FacesContext facesContext = e.getFacesContext();
        Object o = facesContext.getExternalContext().getSession(false);
        if (o instanceof HttpSession) {
            IWintellObjectManager om = (IWintellObjectManager)((HttpSession)o).getAttribute("wintellObjectManager");
            ((HttpSession)o).removeAttribute("wintellObjectManager");
            if (om != null) {
                om.remove();
            }
        }
    }

    public IRequestBean getRB(PhaseEvent e) {
        WintellActionContext ctx = this.getCtx(e);
        try {
            InitialContext c = new InitialContext();
            return (IRequestBean)c.lookup("java:app/wintell.jar/requestBean");
        }
        catch (NamingException e1) {
            log.error(ctx, "cannot find RequestBean", (Throwable)e1);
            return null;
        }
    }

    public void beforePhase(PhaseEvent e) {
        WintellActionContext ctx = this.getCtx(e);
        if (log.isDebugEnabled()) {
            log.debug(ctx, "BEFORE " + e.getPhaseId());
        }
        Object o_request = e.getFacesContext().getExternalContext().getRequest();
        if (e.getPhaseId().equals(PhaseId.RESTORE_VIEW) && o_request instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)o_request;
            if (request.getParameter("javax.faces.ViewState") != null) {
                HttpSession session = request.getSession();
                String viewId = request.getRequestURI();
                if (session == null || session.isNew()) {
                    log.warn(ctx, "javax.faces.ViewState exists but no session in (" + viewId + ") -> redirection to timeout page");
                    FacesContext context = e.getFacesContext();
                    Application app = context.getApplication();
                    ViewHandler viewHandler = app.getViewHandler();
                    UIViewRoot view = viewHandler.createView(context, "/session-expired.seam");
                    context.setViewRoot(view);
                    context.renderResponse();
                    try {
                        viewHandler.renderView(context, view);
                        context.responseComplete();
                    }
                    catch (Throwable t) {
                        throw new FacesException("Session timed out", t);
                    }
                }
            }
            IRequestBean rb = this.getRB(e);
            String url = request.getRequestURI();
            if (url == null || !url.endsWith(".seam")) {
                this.removeOm(e);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(ctx, "BEFORE rb.startRequest(" + url + ") " + e.getPhaseId());
                }
                rb.startRequest(url, ctx);
            }
        }
        if (e.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            this.setJsessionIdPersistent(e);
            IRequestBean rb = this.getRB(e);
            if (rb != null) {
                rb.startRendering();
                if (log.isDebugEnabled()) {
                    log.debug(ctx, "AFTER rb.startRendering() " + e.getPhaseId());
                }
            }
        }
    }

    public void afterPhase(PhaseEvent e) {
        IRequestBean rb;
        WintellActionContext ctx = this.getCtx(e);
        if (log.isDebugEnabled()) {
            log.debug(ctx, "AFTER " + e.getPhaseId());
        }
        if (e.getPhaseId().equals(PhaseId.RENDER_RESPONSE) && (rb = this.getRB(e)) != null) {
            rb.stopRequest();
            this.removeOm(e);
            if (log.isDebugEnabled()) {
                log.debug(ctx, "AFTER rb.stopRequest() " + e.getPhaseId());
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

