/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.tibco.WintellServiceHandlerRemote;
import cz.nextiraone.tmobile.wintell.AGSBlaze;
import cz.nextiraone.tmobile.wintell.IAGSBlaze;
import cz.nextiraone.tmobile.wintell.IWintellSessionManager;
import cz.nextiraone.tmobile.wintell.IvccWintellHandler;
import cz.nextiraone.tmobile.wintell.TiborOutWintellHandler;
import cz.nextiraone.tmobile.wintell.WintellActionButton;
import cz.nextiraone.tmobile.wintell.WintellActionHandle;
import cz.nextiraone.tmobile.wintell.WintellActionHandleAgs;
import cz.nextiraone.tmobile.wintell.WintellActionOutput;
import cz.nextiraone.tmobile.wintell.WintellActionOutputHandler;
import cz.nextiraone.tmobile.wintell.WintellHandler;
import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.WintellOfferActivityButton;
import cz.nextiraone.tmobile.wintell.WintellOfferActivityButtons;
import cz.nextiraone.tmobile.wintell.WintellOfferActivityCategory;
import cz.nextiraone.tmobile.wintell.WintellSession;
import cz.nextiraone.tmobile.wintell.WintellStats;
import cz.nextiraone.tmobile.wintell.WintellTab;
import cz.nextiraone.tmobile.wintell.WintellTabData;
import cz.nextiraone.tmobile.wintell.WintellTabRequestCache;
import cz.nextiraone.tmobile.wintell.ags.model.ActionValidationInput;
import cz.nextiraone.tmobile.wintell.ags.model.ActionValidationOutput;
import cz.nextiraone.tmobile.wintell.ags.model.OfferButton;
import cz.nextiraone.tmobile.wintell.ags.model.OfferButtonEnumeration;
import cz.nextiraone.tmobile.wintell.context.DefaultWintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.AgsEvent;
import cz.nextiraone.tmobile.wintell.events.GeneralEvent;
import cz.nextiraone.tmobile.wintell.exceptions.WintellAppException;
import cz.nextiraone.tmobile.wintell.exceptions.WintellDGException;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.logger.identifiers.LogIdFactory;
import cz.nextiraone.tmobile.wintell.utils.HttpSessionContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.jboss.ejb3.annotation.TransactionTimeout;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.faces.FacesMessages;

@Stateless(name="wintellSessionManager")
@Name(value="wintellSessionManager")
public class WintellSessionManager
implements IWintellSessionManager,
Serializable {
    private static final long serialVersionUID = -8208562289750008380L;
    private static final WintellLogger log = WintellLogger.getLogger(WintellSessionManager.class);
    private HttpSessionContext httpSessionContext = null;
    @PersistenceContext(unitName="wintell")
    private EntityManager em;
    @EJB(name="AGSBlaze")
    private IAGSBlaze blaze;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public long allocSession(String user, String tabObjectId, String objectId, int objectType, WintellActionContext requestContext) {
        if (log.isDebugEnabled()) {
            log.debug(requestContext, "Session for tabId: " + tabObjectId + " not found, creating...");
        }
        WintellSession wintellSession = new WintellSession(user, objectId, objectType);
        this.em.persist((Object)wintellSession);
        log.info(requestContext, "created new session:" + wintellSession.toString());
        return wintellSession.getSessionId();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public void closeSession(long sessionId, Date stopDate) {
        WintellSession s = (WintellSession)this.em.find(WintellSession.class, (Object)sessionId);
        if (s == null) {
            log.error((WintellActionContext)this.httpSessionContext, "cannot find session(id=" + sessionId + ") in database");
        } else {
            s.setSessionStop(stopDate);
        }
    }

    public WintellActionOutput allocAOifPossible(WintellActionHandle ah, WintellOfferActivity o, WintellActionButton b) throws WintellAppException {
        if (b.isCommonButton()) {
            Query q = this.em.createNamedQuery("wintellAObyOAandBT");
            q.setParameter("oa", (Object)o);
            q.setParameter("bt", (Object)b);
            q.setMaxResults(1);
            try {
                List l = q.getResultList();
                if (!l.isEmpty()) {
                    throw new WintellAppException("detect DUPLICIT button=" + b + " for wintellOfferActivity: " + o);
                }
            }
            catch (WintellAppException er) {
                throw er;
            }
            catch (Exception er) {
                throw new WintellAppException(er);
            }
        }
        return ah.allocActionOutput(o, b);
    }

    private void countOfferActivities(WintellTab activeTab, WintellActionContext actionContext, WintellOfferActivity o, ActionValidationInput avi) throws WintellAppException {
        boolean isSubmitable = true;
        try {
            if (!activeTab.isChanged(o)) {
                return;
            }
            WintellOfferActivityButtons bs = activeTab.getButtons(o);
            log.info(actionContext, "pre woa/bs offerActivity.id=" + o.getOfferActivityId() + " A=" + (o.isAccepted() ? 1 : 0) + "/" + (bs.isAccepted() ? 1 : 0) + " D=" + (o.isDeclined() ? 1 : 0) + "/" + (bs.isDeclined() ? 1 : 0) + " O=" + (o.isOffered() ? 1 : 0) + "/" + (bs.isOffered() ? 1 : 0));
            OfferButton ob = null;
            if (o.isAccepted() != bs.isAccepted() && bs.isAccepted()) {
                ob = new OfferButton(o.getOffer().getOfferId(), OfferButtonEnumeration.BUTTON_ACCEPT);
                isSubmitable = false;
            }
            if (o.isDeclined() != bs.isDeclined() && bs.isDeclined()) {
                ob = new OfferButton(o.getOffer().getOfferId(), OfferButtonEnumeration.BUTTON_DECLINE);
                isSubmitable = false;
            }
            if (o.isOffered() != bs.isOffered() && bs.isOffered()) {
                ob = new OfferButton(o.getOffer().getOfferId(), OfferButtonEnumeration.BUTTON_OFFER);
            }
            if (bs != null && bs.getButtons() != null) {
                for (WintellOfferActivityButton b : bs.getButtons()) {
                    if (!b.isChanged() || !b.isPressed()) continue;
                    ob = new OfferButton(o.getOffer().getOfferId(), OfferButtonEnumeration.fromId((int)b.getButtonId()));
                }
            }
            if (ob != null) {
                avi.addPressedButton(ob);
            }
        }
        finally {
            if (o.isSubmitable() && isSubmitable) {
                avi.addSubmitableOffer(o.getOffer().getOfferId());
            }
        }
    }

    private void handleOfferActivity(WintellTab activeTab, WintellActionContext actionContext, WintellActionHandle ah, List<WintellActionOutput> aoList, WintellOfferActivity o, ActionValidationInput avi, WintellStats stats) throws WintellAppException {
        WintellOfferActivityButtons bs = activeTab.getButtons(o);
        if (!o.isSubmitable()) {
            return;
        }
        try {
            WintellActionOutput ao = null;
            if (avi.isPressed(o.getOffer().getOfferId(), 2)) {
                ao = this.allocAOifPossible(ah, o, (WintellActionButton)this.em.find(WintellActionButton.class, (Object)2));
                o.setAccepted(true);
                o.setOffered(false);
            }
            if (avi.isPressed(o.getOffer().getOfferId(), 4)) {
                ao = this.allocAOifPossible(ah, o, (WintellActionButton)this.em.find(WintellActionButton.class, (Object)4));
                o.setDeclined(true);
                o.setOffered(false);
            }
            if (avi.isPressed(o.getOffer().getOfferId(), 3)) {
                ao = this.allocAOifPossible(ah, o, (WintellActionButton)this.em.find(WintellActionButton.class, (Object)3));
                o.setOffered(true);
            }
            if (bs != null && bs.getButtons() != null) {
                for (WintellOfferActivityButton b : bs.getButtons()) {
                    if (!avi.isPressed(o.getOffer().getOfferId(), b.getButtonId().intValue())) continue;
                    b.setLastState(true);
                    ao = this.allocAOifPossible(ah, o, b.getButton(this.em));
                }
            }
            if (ao != null) {
                o.setSomeButtonPressed(true);
                activeTab.resetButtons(o);
                aoList.add(ao);
                this.dbFlush(stats);
                if (log.isDebugEnabled()) {
                    log.debug(actionContext, "post woa/bs offerActivity.id=" + o.getOfferActivityId() + " A=" + (o.isAccepted() ? 1 : 0) + "/" + (bs.isAccepted() ? 1 : 0) + " D=" + (o.isDeclined() ? 1 : 0) + "/" + (bs.isDeclined() ? 1 : 0) + " O=" + (o.isOffered() ? 1 : 0) + "/" + (bs.isOffered() ? 1 : 0));
                }
            }
        }
        catch (WintellAppException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("detect DUPLICIT button")) {
                log.error(actionContext, e.getMessage());
            }
            throw e;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void submit(WintellTab activeTab, WintellTabData activeTabData, WintellServiceHandlerRemote handler, WintellStats stats) throws WintellAppException {
        log.info((WintellActionContext)this.httpSessionContext, "wintell-tabs/submit:" + activeTab.getObjIdStr());
        DefaultWintellActionContext actionContext = this.httpSessionContext.getMoreSpecificContext(LogIdFactory.createWintellSessionId((long)activeTab.getSessionId()));
        WintellActionHandleAgs ah = new WintellActionHandleAgs(activeTabData, this.em, handler, (WintellActionContext)actionContext);
        ArrayList<WintellActionOutput> aoList = new ArrayList<WintellActionOutput>();
        WintellTabRequestCache rq = new WintellTabRequestCache(activeTab.getSessionId(), activeTab.getTabTitle(), activeTab.isHideMoreInfo(), (WintellActionContext)actionContext);
        ActionValidationInput avi = new ActionValidationInput();
        avi.setRequestId("S:" + activeTab.getSessionId());
        Query q = this.em.createNamedQuery("offerActivityForPressed");
        WintellSession session = (WintellSession)this.em.find(WintellSession.class, (Object)activeTab.getSessionId());
        q.setParameter("objectId", (Object)session.getObjectId()).setParameter("objectType", (Object)session.getObjectType());
        for (WintellOfferActivity woa : q.getResultList()) {
            HashSet<Integer> hs = new HashSet<Integer>();
            for (WintellActionOutput wao : woa.getActionActivities()) {
                hs.add(wao.getButton().getButtonId());
            }
            Object[] objectArray = hs.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                Integer buttonId = (Integer)obj;
                if (woa.isButtonPressed(buttonId.intValue())) {
                    avi.addStateButton(new OfferButton(woa.getOffer().getOfferId(), OfferButtonEnumeration.fromId((int)buttonId)));
                }
                ++n2;
            }
        }
        for (AgsEvent a : rq.getSessionEvents(this.em)) {
            for (WintellOfferActivity o : a.getOffers()) {
                this.countOfferActivities(activeTab, (WintellActionContext)actionContext, o, avi);
            }
        }
        if (!this.validateActions(rq, activeTab, (WintellActionContext)actionContext, avi)) {
            return;
        }
        for (AgsEvent a : rq.getSessionEvents(this.em)) {
            ah.setRequest((GeneralEvent)a);
            for (WintellOfferActivity o : a.getOffers()) {
                this.handleOfferActivity(activeTab, (WintellActionContext)actionContext, ah, aoList, o, avi, stats);
            }
        }
        WintellActionOutputHandler actionOutputHandler = new WintellActionOutputHandler();
        ArrayList<WintellHandler> wintellHandlerList = new ArrayList<WintellHandler>();
        wintellHandlerList.add(new TiborOutWintellHandler(handler, (WintellActionContext)actionContext));
        actionOutputHandler.makeOutput(aoList, wintellHandlerList, this.em, (WintellActionContext)actionContext);
        this.dbFlush(stats);
    }

    private boolean validateActions(WintellTabRequestCache rq, WintellTab activeTab, WintellActionContext actionContext, ActionValidationInput avi) {
        ActionValidationOutput avo;
        if (log.isDebugEnabled()) {
            for (OfferButton ob : avi.getStateButtons()) {
                log.info(actionContext, "validateActions.state: offerId=" + ob.getOfferId() + ", buttonId=" + ob.getButtonId());
            }
            for (OfferButton ob : avi.getPressedButtons()) {
                log.info(actionContext, "validateActions.pressed: offerId=" + ob.getOfferId() + ", buttonId=" + ob.getButtonId());
            }
            for (Integer oId : avi.getSubmitableOffers()) {
                log.info(actionContext, "validateActions.submitable: offerId=" + oId);
            }
        }
        String platform = null;
        try {
            AgsEvent e = rq.getSessionEvents(this.em).get(0);
            platform = AGSBlaze.testSwitchPlatform(this.em, e, actionContext);
            log.info((WintellActionContext)this.httpSessionContext, "AGSBlaze.testSwitchPlatform: usr=" + e.getUsr() + ",msisdn=" + e.getMsisdn() + " -> " + platform);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (platform == null) {
            platform = "Production";
        }
        for (OfferButton ob : avi.getPressedButtons()) {
            log.info((WintellActionContext)this.httpSessionContext, " before validation <- pressed button:" + ob.getButtonId() + " on offerId:" + ob.getOfferId());
        }
        log.info((WintellActionContext)this.httpSessionContext, "platform: " + platform + ", was used based on blaze.invokeactionValidationEP");
        try {
            avo = this.blaze.invokeactionValidationEP("AGS" + platform, avi, actionContext);
        }
        catch (WintellAppException e) {
            avo = new ActionValidationOutput();
            avo.setValid(false);
            avo.setErrorMessage("Nebylo mo\u017en\u00e9 validovat vstup - intern\u00ed chyba: " + e.getLocalizedMessage());
        }
        for (OfferButton ob : avo.getButtons2release()) {
            log.info((WintellActionContext)this.httpSessionContext, "release pressed button:" + ob.getButtonId() + " on offerId:" + ob.getOfferId());
        }
        avi.removePresseButtons(avo.getButtons2release());
        for (AgsEvent a : rq.getSessionEvents(this.em)) {
            block10: for (WintellOfferActivity o : a.getOffers()) {
                for (OfferButton ob : avo.getButtons2release()) {
                    if (ob.getOfferId() != o.getOffer().getOfferId()) continue;
                    log.info((WintellActionContext)this.httpSessionContext, "reset buttons for offerActivityID=" + o.getOfferActivityId() + "  ,offerId=" + ob.getOfferId());
                    activeTab.resetButtons(o);
                    continue block10;
                }
            }
        }
        if (!avo.isValid()) {
            String error = avo.getErrorMessage();
            if (error == null) {
                error = "Zvolen\u00e1 kombinace voleb nen\u00ed validn\u00ed";
            }
            log.error(actionContext, error);
            FacesMessages.instance().add(error, new Object[0]);
            return false;
        }
        for (OfferButton ob : avo.getButtons2press()) {
            avi.addPressedButton(ob);
        }
        for (OfferButton ob : avi.getPressedButtons()) {
            log.info((WintellActionContext)this.httpSessionContext, " after validation -> pressed button:" + ob.getButtonId() + " on offerId:" + ob.getOfferId());
        }
        return true;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public IvccWintellHandler submitWeb(WintellTab activeTab, WintellTabData activeTabData, long woaId, int buttonId, WintellServiceHandlerRemote handler, WintellStats stats) throws WintellAppException, WintellDGException {
        log.info((WintellActionContext)this.httpSessionContext, "wintell-tabs/submitWeb:" + activeTab.getObjIdStr());
        WintellOfferActivity woa = (WintellOfferActivity)this.em.find(WintellOfferActivity.class, (Object)woaId);
        DefaultWintellActionContext actionContext = this.httpSessionContext.getMoreSpecificContext(LogIdFactory.createWintellSessionId((long)activeTab.getSessionId()));
        WintellActionHandleAgs ah = new WintellActionHandleAgs(activeTabData, this.em, handler, (WintellActionContext)actionContext);
        ah.setRequest(woa.getEvent());
        WintellActionOutput ao = ah.allocActionOutput(woa, (WintellActionButton)this.em.find(WintellActionButton.class, (Object)buttonId));
        ah = null;
        ArrayList<WintellActionOutput> aoList = new ArrayList<WintellActionOutput>();
        aoList.add(ao);
        WintellActionOutputHandler actionOutputHandler = new WintellActionOutputHandler();
        ArrayList<WintellHandler> wintellHandlerList = new ArrayList<WintellHandler>();
        IvccWintellHandler ivccHandler = new IvccWintellHandler(handler, (WintellActionContext)actionContext);
        wintellHandlerList.add(ivccHandler);
        wintellHandlerList.add(new TiborOutWintellHandler(handler, (WintellActionContext)actionContext));
        actionOutputHandler.makeOutput(aoList, wintellHandlerList, this.em, (WintellActionContext)this.httpSessionContext);
        return ivccHandler;
    }

    private void dbFlush(WintellStats stats) throws WintellAppException {
        try {
            stats.startState(WintellStats.RequestState.DB_FLUSH, (WintellActionContext)this.httpSessionContext);
            try {
                this.em.flush();
            }
            finally {
                stats.stopState(WintellStats.RequestState.DB_FLUSH, (WintellActionContext)this.httpSessionContext);
            }
        }
        catch (Exception er) {
            if (er instanceof WintellAppException) {
                throw (WintellAppException)er;
            }
            throw new WintellAppException(er);
        }
    }

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        this.httpSessionContext = new HttpSessionContext();
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "aroundInvoke:" + ctx.getMethod() + ", this=" + this);
        }
        return ctx.proceed();
    }

    @Override
    public void debugSetButtons(String objIdStr, Map<Long, WintellOfferActivityButtons> buttons) {
        log.debug((WintellActionContext)this.httpSessionContext, "setButtons: (objIdStr=" + objIdStr + ", size=" + buttons.size() + ")");
        for (Map.Entry<Long, WintellOfferActivityButtons> b : buttons.entrySet()) {
            long offerActivityId = b.getKey();
            WintellOfferActivity o = (WintellOfferActivity)this.em.find(WintellOfferActivity.class, (Object)offerActivityId);
            WintellOfferActivityButtons bs = b.getValue();
            log.debug((WintellActionContext)this.httpSessionContext, "\twoa.id[" + offerActivityId + "]" + " A=" + (o == null ? -1 : (o.isAccepted() ? 1 : 0)) + "/" + (bs.isAccepted() ? 1 : 0) + " D=" + (o == null ? -1 : (o.isDeclined() ? 1 : 0)) + "/" + (bs.isDeclined() ? 1 : 0) + " O=" + (o == null ? -1 : (o.isOffered() ? 1 : 0)) + "/" + (bs.isOffered() ? 1 : 0));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isSubmitable(WintellTabRequestCache t) {
        return t.isSubmitable(this.em);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<WintellOfferActivity> getAllOffers(WintellTabRequestCache t) {
        return t.getAllOffers(this.em);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<WintellOfferActivity> getAllMessages(WintellTabRequestCache t) {
        return t.getAllMessages(this.em);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<WintellOfferActivityCategory> getAllCategories(WintellTabRequestCache t) {
        return t.getAllCategories(this.em);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<AgsEvent> getSessionEvents(WintellTabRequestCache t) {
        return t.getSessionEvents(this.em);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String getTabTitle(WintellTabRequestCache t) {
        return t.getTabTitle();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isFocus(WintellTabRequestCache t) {
        return t.isFocus(this.em);
    }
}

