/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.IWintellJmsSender;
import cz.nextiraone.tmobile.wintell.RequestLogMessage;
import cz.nextiraone.tmobile.wintell.WintellStatsMessage;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.GeneralEvent;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class WintellStats
extends WintellStatsMessage
implements Serializable {
    private static final long serialVersionUID = 4333931521289493706L;
    private static final WintellLogger log = WintellLogger.getLogger(WintellStats.class);
    private transient boolean logSend = false;
    private transient RequestLogMessage lastLog = null;
    protected transient HashMap<RequestState, Long> timeStamps = new HashMap();
    protected transient List<LogMessage> logMessages = new ArrayList<LogMessage>();
    private transient boolean doLog = false;
    private transient boolean doStats = false;

    public WintellStats() {
        this.doLog = false;
        this.doStats = false;
    }

    public WintellStats(String source, boolean doLog, boolean doStats) {
        this.flagsPut("CH", source);
        this.doLog = doLog;
        this.doStats = doStats;
        try {
            this.flagsPut("NODE", System.getProperty("jvmRoute"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void failStatsAndLogs() {
        this.doStats = false;
        this.doLog = false;
    }

    public void setRequestSendTime(Date time) {
        Long deliveryTime = this.timeStamps.get((Object)RequestState.ALL) - time.getTime();
        this.timeDeltasPut(RequestState.DELIVERY_TIME, deliveryTime);
    }

    public void startRequest(WintellActionContext ctx) {
        this.startState(RequestState.ALL, ctx);
        if (this.doLog) {
            this.lastLog = new RequestLogMessage(this.getFlag("CH"), "REQUEST", "START", ctx);
        }
    }

    public void addFlag(String key, String value) {
        this.flagsPut(key, value);
    }

    public void stopRequest(WintellActionContext ctx, boolean isEventRequest) {
        if (this.doLog && isEventRequest) {
            if (this.lastLog == null) {
                log.error(ctx, "stopRequest() called, but lastLog=null");
                return;
            }
            this.logEvent(null, this.getFlag("CH"), "REQUEST", "STOP", ctx);
        }
        this.stopState(RequestState.ALL, ctx);
        if (!this.timeStamps.isEmpty()) {
            for (RequestState state : this.timeStamps.keySet()) {
                log.error(ctx, "force deactivation of state=" + (Object)((Object)state) + " in the stopRequest()");
            }
            this.timeStamps.clear();
        }
        if (log.isInfoEnabled()) {
            String flgsInfo = "";
            for (Map.Entry<String, String> fx : this.flagsEntrySet()) {
                if (!flgsInfo.equals("")) {
                    flgsInfo = String.valueOf(flgsInfo) + ",";
                }
                flgsInfo = String.valueOf(flgsInfo) + fx.getKey() + ":" + fx.getValue();
            }
            String statInfo = "";
            for (Map.Entry<RequestState, Long> stDelta : this.timeDeltasEntrySet()) {
                if (!statInfo.equals("")) {
                    statInfo = String.valueOf(statInfo) + ",";
                }
                statInfo = String.valueOf(statInfo) + (Object)((Object)stDelta.getKey()) + "=" + stDelta.getValue();
            }
            log.info(ctx, "REQ_STATS|" + flgsInfo + "|" + statInfo);
        }
        if (this.doStats) {
            this.sendStats(ctx);
        } else {
            this.clear();
        }
        if (this.doLog) {
            for (LogMessage mx : this.logMessages) {
                try {
                    this.sendMessage(ctx, mx.m, mx.corelationId);
                }
                catch (Exception e) {
                    log.error(ctx, "Caught exception while sending REQUEST log, corelationId=" + mx.corelationId);
                    break;
                }
            }
        }
        this.logMessages.clear();
    }

    public void startState(RequestState state, WintellActionContext ctx) {
        if (this.timeStamps.containsKey((Object)state)) {
            log.error(ctx, "startState(" + (Object)((Object)state) + ") called, but state is just activated");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(ctx, "startState(" + (Object)((Object)state) + ") at : " + new Date());
        }
        this.timeStamps.put(state, new Date().getTime());
    }

    public void stopState(RequestState state, WintellActionContext ctx) {
        long ts = new Date().getTime();
        Long oldTs = this.timeStamps.get((Object)state);
        if (oldTs == null) {
            log.error(ctx, "stopState(" + (Object)((Object)state) + ") called, but state was not actived");
            return;
        }
        long delta = ts - oldTs;
        Long oldDelta = this.getTime(state);
        if (oldDelta != null) {
            delta += oldDelta.longValue();
        }
        this.timeDeltasPut(state, delta);
        this.timeStamps.remove((Object)state);
        if (log.isDebugEnabled()) {
            log.debug(ctx, "stopState(" + (Object)((Object)state) + "): delta += " + delta);
        }
    }

    public void logEvent(GeneralEvent e, Object data, String type, String state, WintellActionContext ctx) {
        if (!this.doLog) {
            return;
        }
        this.startState(RequestState.JMS_SEND_LOGS, ctx);
        try {
            Long requestId = null;
            if (e == null) {
                if (this.lastLog == null || !this.lastLog.isSetup()) {
                    log.error(ctx, "(e == null && (lastLog == null || !lastLog.isSetup()))");
                    return;
                }
                requestId = this.lastLog.getRequestId();
            } else {
                requestId = e.getRequestId();
            }
            if (log.isDebugEnabled()) {
                log.debug(ctx, "\t\tlogEvent:" + requestId + ":" + state + ":" + type);
            }
            RequestLogMessage nextLog = null;
            if (this.lastLog != null) {
                if (!this.lastLog.isSetup()) {
                    this.lastLog.setUp(e, 0);
                    this.sendLog(this.lastLog, ctx);
                }
                nextLog = new RequestLogMessage(this.lastLog, data, type, state, ctx);
            } else {
                nextLog = new RequestLogMessage(requestId, data, type, state, ctx);
            }
            this.sendLog(nextLog, ctx);
            this.lastLog = nextLog;
        }
        finally {
            this.stopState(RequestState.JMS_SEND_LOGS, ctx);
        }
    }

    public void sendLog(RequestLogMessage m, WintellActionContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug(ctx, "sendingMessage:" + m.getRequestLogId());
        }
        this.logSend = true;
        this.logMessages.add(new LogMessage(m, String.valueOf(ctx.getSubproject().toString()) + ":R:" + m.getRequestId()));
    }

    public void sendStats(WintellActionContext ctx) {
        String reqId = ctx.getSubproject().toString();
        if (!this.containsFlag("R")) {
            return;
        }
        reqId = String.valueOf(reqId) + ":R:" + this.getFlag("R");
        if (log.isDebugEnabled()) {
            log.debug(ctx, "sendingStats:" + reqId);
        }
        try {
            this.sendMessage(ctx, new WintellStatsMessage(this), reqId);
        }
        catch (Exception e) {
            log.error(ctx, "Caught exception while sending REQUEST stats", (Throwable)e);
        }
    }

    public boolean isLogSend() {
        return this.logSend;
    }

    public void setLogSend(boolean logSend) {
        this.logSend = logSend;
    }

    private IWintellJmsSender newStatsSender() throws NamingException {
        InitialContext c = new InitialContext();
        return (IWintellJmsSender)c.lookup("java:app/wintell.jar/wintellJmsSender");
    }

    private void sendMessage(WintellActionContext ctx, Serializable m, String jmsCorrelationID) throws Exception {
        int retryCount = 5;
        while (retryCount > 0) {
            if (log.isDebugEnabled()) {
                log.debug(ctx, "sendMessage(jmsCorrelationID=" + jmsCorrelationID + ",before retryCount=" + retryCount + "x)");
            }
            try {
                IWintellJmsSender sender = this.newStatsSender();
                sender.sendMessage("monitoringQueue", m, jmsCorrelationID);
                return;
            }
            catch (Exception e) {
                log.warn(ctx, "sendMessage(jmsCorrelationID=" + jmsCorrelationID + ",try to retry " + retryCount + "x) " + e);
                --retryCount;
            }
        }
        log.error(ctx, "sendMessage(jmsCorrelationID=" + jmsCorrelationID + "): " + m.toString());
    }

    public void setDoLog(boolean b) {
        this.doLog = true;
    }

    public void merge(WintellStats s) {
        for (Map.Entry<RequestState, Long> e : s.getTimeDeltas().entrySet()) {
            long val = s.getTime(e.getKey());
            if (this.timeStamps.containsKey((Object)e.getKey())) {
                val += this.getTime(e.getKey()).longValue();
            }
            this.timeDeltasPut(e.getKey(), val);
        }
        s.clear();
    }

    static class LogMessage {
        public RequestLogMessage m;
        public String corelationId;

        LogMessage(RequestLogMessage m, String corelationId) {
            this.m = m;
            this.corelationId = corelationId;
        }
    }

    public static enum RequestState {
        DELIVERY_TIME,
        EVALUATING_IN_BLAZE,
        GATHERING_DATA,
        RENDERING_RESPONSE,
        JMS_SEND_STATS,
        JMS_SEND_LOGS,
        HISTORY_SEARCHING,
        HANDLE_ACTIONS,
        DB_FLUSH,
        ALL;

    }
}

