/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.WintellStats;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WintellStatsMessage
implements Serializable {
    private static final long serialVersionUID = 652907298860868772L;
    private HashMap<WintellStats.RequestState, Long> timeDeltas = null;
    private HashMap<String, String> flags = null;

    WintellStatsMessage() {
        this.clear();
    }

    WintellStatsMessage(WintellStatsMessage old) {
        this.flags = old.getFlags();
        this.timeDeltas = old.getTimeDeltas();
        old.clear();
    }

    public HashMap<WintellStats.RequestState, Long> getTimeDeltas() {
        return this.timeDeltas;
    }

    public HashMap<String, String> getFlags() {
        return this.flags;
    }

    public void flagsPut(String key, String value) {
        this.flags.put(key, value);
    }

    public String getFlag(String flag) {
        return this.flags.get(flag);
    }

    public boolean containsFlag(String flag) {
        return this.flags.containsKey(flag);
    }

    public void timeDeltasPut(WintellStats.RequestState state, Long delta) {
        this.timeDeltas.put(state, delta);
    }

    public Long getTime(WintellStats.RequestState state) {
        return this.timeDeltas.get((Object)state);
    }

    public Set<Map.Entry<WintellStats.RequestState, Long>> timeDeltasEntrySet() {
        return this.timeDeltas.entrySet();
    }

    public Set<Map.Entry<String, String>> flagsEntrySet() {
        return this.flags.entrySet();
    }

    public Integer getNodeId() {
        try {
            return Integer.parseInt(this.flags.get("NODE"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setErrCode(Integer errCode) {
        this.flagsPut("ERR_CODE", errCode.toString());
    }

    public void setErrCodeOK() {
        if (this.getErrCode() != null) {
            return;
        }
        this.setErrCode(0);
    }

    public Integer getErrCode() {
        try {
            return Integer.parseInt(this.flags.get("ERR_CODE"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Long getRequestId() {
        try {
            return Long.parseLong(this.flags.get("R"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clear() {
        this.timeDeltas = new HashMap();
        this.flags = new HashMap();
    }
}

