/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.WintellOfferActivityButtons;
import cz.nextiraone.tmobile.wintell.context.DefaultWintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.logger.identifiers.LogIdFactory;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class WintellTab
implements Serializable {
    private static final long serialVersionUID = 2830113070883617319L;
    private static final WintellLogger log = WintellLogger.getLogger(WintellTab.class);
    private String defaultClfyUser;
    private long sessionId;
    private String objIdStr;
    private String tabTitle;
    private Date lastUse;
    private Map<Long, WintellOfferActivityButtons> buttons = new TreeMap<Long, WintellOfferActivityButtons>();
    private long corelationId = -1L;
    private boolean useMSISDN;
    private String msisdn;
    private String pin;
    private String interId;
    private boolean hideMoreInfo;

    public WintellTab(String objIdStr, long wintellSessionId) {
        this.sessionId = wintellSessionId;
        this.objIdStr = objIdStr == null ? "??NO OBJECT??" : new String(objIdStr);
        this.activity();
        DefaultWintellActionContext ctx = new DefaultWintellActionContext(WintellSubprojectEnum.AGS, LogIdFactory.createWintellSessionId((long)this.sessionId));
        log.info((WintellActionContext)ctx, "new WintellTab -> " + objIdStr);
    }

    protected void finalize() throws Throwable {
        DefaultWintellActionContext ctx = new DefaultWintellActionContext(WintellSubprojectEnum.AGS, LogIdFactory.createWintellSessionId((long)this.sessionId));
        log.info((WintellActionContext)ctx, "delete WintellTab -> " + this.objIdStr);
        super.finalize();
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public Map<Long, WintellOfferActivityButtons> getButtons() {
        return this.buttons;
    }

    public void setButtons(Map<Long, WintellOfferActivityButtons> buttons) {
        this.buttons = buttons;
    }

    public void setTabTitle(String tabTitle) {
        this.tabTitle = new String(tabTitle);
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    public String getObjIdStr() {
        return this.objIdStr;
    }

    public void resetButtons(WintellOfferActivity a) {
        this.buttons.remove(a.getOfferActivityId());
        this.getButtons(a);
    }

    public WintellOfferActivityButtons getButtons(WintellOfferActivity a) {
        WintellOfferActivityButtons bs = this.buttons.get(a.getOfferActivityId());
        if (bs != null) {
            return bs;
        }
        if (log.isDebugEnabled()) {
            DefaultWintellActionContext ctx = new DefaultWintellActionContext(WintellSubprojectEnum.AGS, LogIdFactory.createWintellSessionId((long)this.sessionId));
            log.debug((WintellActionContext)ctx, String.valueOf(this.toString()) + ".getButtons(" + a + ")");
        }
        bs = new WintellOfferActivityButtons(a);
        this.buttons.put(a.getOfferActivityId(), bs);
        return bs;
    }

    public boolean isChanged(WintellOfferActivity a) {
        WintellOfferActivityButtons bs = this.buttons.get(a.getOfferActivityId());
        if (bs == null) {
            if (log.isDebugEnabled()) {
                DefaultWintellActionContext ctx = new DefaultWintellActionContext(WintellSubprojectEnum.AGS, LogIdFactory.createWintellSessionId((long)this.sessionId));
                log.debug((WintellActionContext)ctx, String.valueOf(this.toString()) + ".isChanged(" + a + ") : " + "null buttons");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            String ch = bs.isChangedDebug(a);
            DefaultWintellActionContext ctx = new DefaultWintellActionContext(WintellSubprojectEnum.AGS, LogIdFactory.createWintellSessionId((long)this.sessionId));
            log.debug((WintellActionContext)ctx, String.valueOf(this.toString()) + ".isChanged(" + a + ") : " + ch);
        }
        return bs.isChanged(a);
    }

    public String getDefaultClfyUser() {
        return this.defaultClfyUser;
    }

    public void setDefaultClfyUser(String defaultClfyUser) {
        this.defaultClfyUser = new String(defaultClfyUser);
    }

    public void setObjIdStr(String objIdStr) {
        this.objIdStr = objIdStr;
    }

    public void activity() {
        this.lastUse = new Date();
    }

    public Date getLastUse() {
        return this.lastUse;
    }

    public boolean useMSISDN() {
        return this.useMSISDN;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public long getCorelationId() {
        if (this.corelationId < 0L) {
            this.corelationId = this.sessionId * 1000L;
        }
        ++this.corelationId;
        return this.corelationId;
    }

    public String getPin() {
        return this.pin;
    }

    public String getInterId() {
        return this.interId;
    }

    public void setHideMoreInfo(boolean hideMoreInfo) {
        this.hideMoreInfo = hideMoreInfo;
    }

    public boolean isHideMoreInfo() {
        return this.hideMoreInfo;
    }

    public void setRequest(boolean useMSISDN, String msisdn, String pin, String interId, boolean hideMoreInfo) {
        this.useMSISDN = useMSISDN;
        this.msisdn = msisdn;
        this.pin = pin;
        this.interId = interId;
        this.hideMoreInfo = hideMoreInfo;
    }

    static class TimeSort<T>
    implements Comparator<T> {
        TimeSort() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            Date i1 = ((WintellTab)obj1).getLastUse();
            Date i2 = ((WintellTab)obj2).getLastUse();
            return -i1.compareTo(i2);
        }
    }
}

