/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.WintellOffer;
import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.WintellOfferActivityButtons;
import cz.nextiraone.tmobile.wintell.WintellOfferActivityCategory;
import cz.nextiraone.tmobile.wintell.WintellOfferCategory;
import cz.nextiraone.tmobile.wintell.WintellSession;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.AgsEvent;
import cz.nextiraone.tmobile.wintell.events.GeneralEvent;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityManager;

public class WintellTabRequestCache {
    private static final WintellLogger log = WintellLogger.getLogger(WintellTabRequestCache.class);
    private boolean activated;
    private boolean submitable;
    private List<WintellOfferActivity> sortedOffers = null;
    private List<WintellOfferActivity> sortedMessages = null;
    private List<WintellOfferActivityCategory> sortedCategories = null;
    private ArrayList<AgsEvent> sortEvents = null;
    private boolean focus;
    private boolean hideMoreInfo;
    private String tabTitle;
    private long sessionId;
    private Map<Long, WintellOfferActivityButtons> buttons = new TreeMap<Long, WintellOfferActivityButtons>();
    private WintellActionContext ctx;

    WintellTabRequestCache(long sessionId, String tabTitle, boolean hideMoreInfo, WintellActionContext httpSessionContext) {
        this.sessionId = sessionId;
        this.tabTitle = tabTitle;
        this.ctx = httpSessionContext;
        this.hideMoreInfo = hideMoreInfo;
    }

    public void setSubmitable(boolean submitable) {
        this.submitable = submitable;
    }

    public boolean isSubmitable(EntityManager em) {
        this.activate(em);
        return this.submitable;
    }

    public List<WintellOfferActivity> getAllOffers(EntityManager em) {
        this.activate(em);
        if (log.isDebugEnabled()) {
            log.debug(this.ctx, "getAllOffers()");
            for (WintellOfferActivity woa : this.sortedOffers) {
                log.debug(this.ctx, "\twoa=" + woa);
            }
        }
        return this.sortedOffers;
    }

    public List<WintellOfferActivity> getAllMessages(EntityManager em) {
        this.activate(em);
        return this.sortedMessages;
    }

    public List<WintellOfferActivityCategory> getAllCategories(EntityManager em) {
        this.activate(em);
        return this.sortedCategories;
    }

    public List<AgsEvent> getSessionEvents(EntityManager em) {
        this.activate(em);
        return this.sortEvents;
    }

    public boolean isFocus(EntityManager em) {
        this.activate(em);
        return this.focus;
    }

    public void setHideMoreInfo(boolean hideMoreInfo) {
        this.hideMoreInfo = hideMoreInfo;
    }

    public boolean isHideMoreInfo() {
        return this.hideMoreInfo;
    }

    public void deactivate() {
        this.activated = false;
        this.submitable = false;
        this.sortedOffers = null;
        this.sortedMessages = null;
        this.sortedCategories = null;
        this.sortEvents = null;
    }

    private void activate(EntityManager em) {
        if (this.activated) {
            return;
        }
        WintellSession session = (WintellSession)em.find(WintellSession.class, (Object)this.sessionId);
        long eTime = new Date().getTime();
        this.submitable = false;
        this.focus = false;
        this.sortEvents = null;
        HashSet<WintellOffer> allOffers = new HashSet<WintellOffer>();
        HashSet<WintellOffer> firstOffers = new HashSet<WintellOffer>();
        HashSet<WintellOfferActivity> allOfferActivities = new HashSet<WintellOfferActivity>();
        HashMap offersInCategories = new HashMap();
        this.sortedMessages = new ArrayList<WintellOfferActivity>();
        long numActivities = 0L;
        boolean firstEvent = true;
        if (session != null) {
            em.refresh((Object)session);
            this.sortEvents = new ArrayList(session.getWintellEvents());
        } else {
            this.sortEvents = new ArrayList();
            if (this.tabTitle != null && !"errorTab".equals(this.tabTitle) && this.sessionId != -1L) {
                log.error(this.ctx, "cannot lookup session [where sessionId=" + this.sessionId + "] in activate(), tabTitle=" + this.tabTitle, new Throwable());
            }
        }
        Collections.sort(this.sortEvents, new EventsSort());
        for (AgsEvent agsEvent : this.sortEvents) {
            if (log.isDebugEnabled()) {
                log.debug(this.ctx, "\trequestId=" + agsEvent.getRequestId());
            }
            for (WintellOfferActivityCategory c : agsEvent.getOfferTypes()) {
                if (log.isDebugEnabled()) {
                    log.debug(this.ctx, "\t\tcategory=" + c.getCategory().getName());
                }
                for (WintellOfferActivity a : c.getOffers()) {
                    boolean isError;
                    em.refresh((Object)a);
                    ++numActivities;
                    if (log.isDebugEnabled()) {
                        log.debug(this.ctx, "\t\t\tofferActivityId=" + a.getOfferActivityId() + ", offerType=" + a.getOffer().getOfferType() + ", offerId=" + a.getOffer().getOfferId());
                    }
                    a.isAcceptable();
                    a.isMoreInfo();
                    if (!firstEvent) {
                        firstOffers.remove(a.getOffer());
                    }
                    if (a.isDisabled()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug(this.ctx, "\t\t\t\t.isDisabled");
                        continue;
                    }
                    if (allOffers.contains(a.getOffer())) {
                        a.setDisabled(true);
                        if (!log.isDebugEnabled()) continue;
                        log.debug(this.ctx, "\t\t\t\t.setDisabled()");
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(this.ctx, "\t\t\t\t.isEnabled");
                    }
                    allOffers.add(a.getOffer());
                    if (!this.submitable) {
                        this.submitable = a.isSubmitable();
                    }
                    allOfferActivities.add(a);
                    if (!offersInCategories.containsKey(a.getOfferCategory())) {
                        offersInCategories.put(a.getOfferCategory(), new HashMap());
                    }
                    ((Map)offersInCategories.get(a.getOfferCategory())).put(a.getOffer().getOfferId(), a);
                    if (!a.isMessage()) continue;
                    boolean bl = isError = a.getOffer().getOfferId() < 0;
                    if ((!isError || !firstEvent) && isError) continue;
                    this.sortedMessages.add(a);
                }
            }
            if (!firstEvent) continue;
            firstEvent = false;
            for (WintellOffer o : allOffers) {
                if (o.getOfferId() < 0) continue;
                firstOffers.add(o);
            }
        }
        if (!firstOffers.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug(this.ctx, "firstOffers is not empty:");
                for (WintellOffer wintellOffer : firstOffers) {
                    log.debug(this.ctx, "\t" + wintellOffer.getOfferId() + ":" + wintellOffer.getDescription());
                }
            }
            this.focus = true;
        }
        this.sortedOffers = new ArrayList<WintellOfferActivity>(allOfferActivities);
        Collections.sort(this.sortedOffers, new WintellOfferActivityCategory.OfferActivitySort());
        this.sortedCategories = new ArrayList<WintellOfferActivityCategory>();
        for (Map.Entry entry : offersInCategories.entrySet()) {
            this.sortedCategories.add(new WintellOfferActivityCategory((WintellOfferCategory)entry.getKey(), new ArrayList(((Map)entry.getValue()).values())));
        }
        Collections.sort(this.sortedCategories, new GeneralEvent.CategorySort());
        Collections.sort(this.sortedMessages, new WintellOfferActivityCategory.OfferActivitySort());
        log.info(this.ctx, "activate tab: time=" + (new Date().getTime() - eTime) + "ms,numActivities=" + numActivities + ",title=" + this.tabTitle);
        this.activated = true;
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    public void setTabTitle(String tabTitle) {
        this.tabTitle = tabTitle;
    }

    public WintellOfferActivityButtons getButtons(long offerActivityId) {
        return this.buttons.get(offerActivityId);
    }

    public void setButtons(Map<Long, WintellOfferActivityButtons> buttons) {
        this.buttons = buttons;
    }

    static class EventsSort<T>
    implements Comparator<T> {
        EventsSort() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            Long i2;
            Long i1 = ((AgsEvent)obj1).getTs().getTime() / 1000L;
            if (i1.equals(i2 = Long.valueOf(((AgsEvent)obj2).getTs().getTime() / 1000L))) {
                return -new Long(((AgsEvent)obj1).getRequestId()).compareTo(((AgsEvent)obj2).getRequestId());
            }
            return -i1.compareTo(i2);
        }
    }
}

