/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.tibco.WintellServiceHandlerRemote;
import cz.nextiraone.tmobile.wintell.IWintellSessionManager;
import cz.nextiraone.tmobile.wintell.IWintellTabs;
import cz.nextiraone.tmobile.wintell.IWintellTabsDG;
import cz.nextiraone.tmobile.wintell.IvccWintellHandler;
import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.WintellOfferActivityButtons;
import cz.nextiraone.tmobile.wintell.WintellOfferActivityCategory;
import cz.nextiraone.tmobile.wintell.WintellStats;
import cz.nextiraone.tmobile.wintell.WintellTab;
import cz.nextiraone.tmobile.wintell.WintellTabData;
import cz.nextiraone.tmobile.wintell.context.DefaultWintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.exceptions.WintellAppException;
import cz.nextiraone.tmobile.wintell.exceptions.WintellDGException;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.logger.identifiers.LogIdFactory;
import cz.nextiraone.tmobile.wintell.utils.HttpSessionContext;
import cz.tmobile.ei.wintell.datatypes.MoreInfoResp;
import cz.tmobile.ei.wintell.datatypes.WintellResponse;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.AccessTimeout;
import javax.ejb.EJBException;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.ejb.SessionSynchronization;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ejb3.annotation.Clustered;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Synchronized;

@Stateful(name="wintellTabs")
@Name(value="wintellTabs")
@Scope(value=ScopeType.SESSION)
@Synchronized
@AccessTimeout(value=20L, unit=TimeUnit.SECONDS)
@Clustered
public class WintellTabs
implements Serializable,
SessionSynchronization,
IWintellTabs {
    public static final String ERROR_TAB_NAME = "errorTab";
    private static final long serialVersionUID = -4389419375609457563L;
    private static final WintellLogger log = WintellLogger.getLogger(WintellTabs.class);
    private HttpSessionContext httpSessionContext = new HttpSessionContext();
    private String loggedUser = null;
    private boolean showErrorTab;
    private boolean errorTabActive;
    private String lastError = null;
    private boolean debugEvent = false;
    private Map<String, Map<String, Boolean>> tabNodesMap = new HashMap<String, Map<String, Boolean>>();
    private transient IWintellSessionManager sm = null;
    IWintellTabsDG wTabsDG;
    private transient HashMap<String, WintellTab> wintellTabs = null;
    private ArrayList<WintellTab> wintellTabsList = new ArrayList();
    private String activeTabId;
    private transient boolean modified = false;
    private transient boolean finished = false;

    public Long getActiveSessionId() {
        if (this.activeTabId != null) {
            WintellTab t = this.getTab(this.activeTabId);
            if (t != null) {
                return t.getSessionId();
            }
            return null;
        }
        return null;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public WintellTab getTab(String objStrId) {
        String objStrIdS = objStrId;
        if (objStrIdS == null) {
            objStrIdS = "_NULL_";
        }
        String ret = "_NULL_";
        if (this.getWintellTabs().get(objStrId) != null) {
            ret = this.getWintellTabs().get(objStrId).toString();
        }
        log.info((WintellActionContext)this.httpSessionContext, "1-WintellTabs:" + this.toString() + ".getTab(" + objStrIdS + ") -> " + ret);
        return this.getWintellTabs().get(objStrId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public long getTab(String tabObjectId, String tabTitle, String defaultClfyUser, String user, String objectId, int objectType, boolean useMSISDN, String msisdn, String pin, String interId, boolean hideMoreInfo, WintellActionContext requestContext) throws WintellAppException {
        WintellTab t = this.getTab(tabObjectId);
        log.info(requestContext, "Looking for session for tab id: " + tabObjectId);
        if (t != null) {
            log.info(requestContext, "tab just exists for: '" + tabObjectId + "' -> " + t.getSessionId());
            t.setRequest(useMSISDN, msisdn, pin, interId, hideMoreInfo);
            return t.getSessionId();
        }
        long sessionId = -1L;
        try {
            sessionId = this.sm.allocSession(user, tabObjectId, objectId, objectType, requestContext);
        }
        catch (Exception e) {
            throw new WintellAppException(e);
        }
        log.info(requestContext, "hideMoreInfo=" + hideMoreInfo);
        this.createTab(tabObjectId, sessionId, defaultClfyUser, tabTitle, true, requestContext);
        t = this.getTab(tabObjectId);
        t.setRequest(useMSISDN, msisdn, pin, interId, hideMoreInfo);
        return sessionId;
    }

    private Map<String, WintellTab> getWintellTabs() {
        if (this.wintellTabs == null) {
            this.wintellTabs = new HashMap();
            for (WintellTab t : this.wintellTabsList) {
                this.wintellTabs.put(t.getObjIdStr(), t);
            }
        }
        return this.wintellTabs;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void createTab(String objIdStr, long wintellSessionId, String defaultClfyUser, String tabTitle, boolean activateNewTab, WintellActionContext requestContext) throws WintellAppException {
        try {
            this.modified = true;
            WintellTab wt = new WintellTab(objIdStr, wintellSessionId);
            wt.setDefaultClfyUser(defaultClfyUser);
            wt.setTabTitle(tabTitle);
            this.wTabsDG.setDefaultClfyUser(objIdStr, defaultClfyUser);
            if (!this.getWintellTabs().containsKey(objIdStr)) {
                this.getWintellTabs().put(objIdStr, wt);
                this.wintellTabsList.add(wt);
            }
            if (activateNewTab) {
                this.activate(wt.getObjIdStr());
            }
            log.info(requestContext, "created new tab, sessionId:" + wintellSessionId);
        }
        catch (Exception er) {
            if (er instanceof WintellAppException) {
                throw (WintellAppException)er;
            }
            throw new WintellAppException(er);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void closeAll() throws WintellAppException {
        try {
            this.modified = true;
            this.setShowErrorTab(false);
            this.setErrorTabActive(false);
            if (this.wintellTabsList == null) {
                this.wintellTabsList = new ArrayList();
            }
            Date stopDate = new Date();
            for (WintellTab t : this.getTabsList()) {
                this.stopSession(t, stopDate);
            }
            this.wTabsDG.closeAll();
            this.wintellTabs = null;
            this.wintellTabsList.clear();
            this.tabNodesMap.clear();
            this.activeTabId = null;
            log.info((WintellActionContext)this.httpSessionContext, "all tabs closed");
        }
        catch (Exception er) {
            if (er instanceof WintellAppException) {
                throw (WintellAppException)er;
            }
            throw new WintellAppException(er);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean closeTab(String tabIdtoClose) throws WintellAppException {
        block10: {
            block11: {
                block9: {
                    this.modified = true;
                    if (!ERROR_TAB_NAME.equals(tabIdtoClose)) break block9;
                    if (this.errorTabActive) {
                        this.activateLast();
                    }
                    this.showErrorTab = false;
                    this.errorTabActive = false;
                    tabIdtoClose = null;
                    return true;
                }
                try {
                    if (this.wintellTabs == null || tabIdtoClose == null) break block10;
                    WintellTab t = this.getTab(tabIdtoClose);
                    if (t == null) break block11;
                    this.stopSession(t, new Date());
                    if (t.getObjIdStr().equals(this.activeTabId)) {
                        log.info((WintellActionContext)this.httpSessionContext, "closed tab is activeTabId");
                        WintellTab nx = null;
                        Boolean match = false;
                        for (WintellTab tt : this.wintellTabsList) {
                            if (tt == t) {
                                match = true;
                                continue;
                            }
                            if (nx != null && match.booleanValue()) break;
                            nx = tt;
                        }
                        this.activeTabId = nx != null ? nx.getObjIdStr() : null;
                    }
                    this.wintellTabs.remove(tabIdtoClose);
                    this.wintellTabsList.remove(t);
                    log.info((WintellActionContext)this.httpSessionContext, "closeTab(" + tabIdtoClose + ") with sessionId=" + t.getSessionId() + ", next activeTabId=" + this.activeTabId);
                    tabIdtoClose = null;
                    return true;
                }
                catch (Exception er) {
                    if (er instanceof WintellAppException) {
                        throw (WintellAppException)er;
                    }
                    throw new WintellAppException(er);
                }
            }
            this.removeTabNodes(tabIdtoClose);
            this.wTabsDG.closeTab(tabIdtoClose);
        }
        return false;
    }

    private void stopSession(WintellTab t, Date stopDate) throws WintellAppException {
        try {
            this.sm.closeSession(t.getSessionId(), stopDate);
        }
        catch (Exception e) {
            log.error((WintellActionContext)this.httpSessionContext, "tab cannot close session: title=" + t.getTabTitle() + ", sessionId=" + t.getSessionId());
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String getActiveTabId() {
        if (this.errorTabActive) {
            return ERROR_TAB_NAME;
        }
        if (this.activeTabId != null) {
            return this.activeTabId;
        }
        return "???";
    }

    private void removeTabNodes(String tabId) {
        this.modified = true;
        if (this.tabNodesMap.containsKey(tabId)) {
            this.tabNodesMap.remove(this.getActiveTabId());
        }
    }

    public void activateLast() {
        if (this.wintellTabsList != null && this.wintellTabsList.size() > 0) {
            this.activeTabId = this.wintellTabsList.get(this.wintellTabs.size() - 1).getObjIdStr();
            this.modified = true;
        } else if (this.activeTabId != null) {
            this.activeTabId = null;
            this.modified = true;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void activate(String tabId) {
        this.modified = true;
        this.activeTabId = tabId;
        if (ERROR_TAB_NAME.equals(tabId)) {
            this.errorTabActive = true;
        } else {
            this.errorTabActive = false;
            WintellTab tab = this.getActiveTab();
            if (tab != null) {
                tab.activity();
            }
        }
    }

    public List<WintellTab> getTabsList() {
        return this.wintellTabsList;
    }

    private Map<String, Boolean> getOpenNodesMap() {
        if (!this.tabNodesMap.containsKey(this.activeTabId)) {
            this.tabNodesMap.put(this.activeTabId, new HashMap());
        }
        return this.tabNodesMap.get(this.activeTabId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Boolean adviseNodeOpened(String key, Object rowData, Set<Integer> foldedCategories) {
        Map<String, Boolean> openNodesMap = this.getOpenNodesMap();
        if (!openNodesMap.containsKey(key)) {
            if (rowData instanceof WintellOfferActivityCategory) {
                WintellOfferActivityCategory oc = (WintellOfferActivityCategory)rowData;
                if (foldedCategories != null && foldedCategories.contains(oc.getCategoryId())) {
                    log.info((WintellActionContext)this.httpSessionContext, String.format("adviseNodeOpened(%s,%s).closed -> %s", key, rowData.toString(), "false"));
                    openNodesMap.put(key, Boolean.FALSE);
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        }
        return openNodesMap.get(key);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void toggleListener(String key) {
        Map<String, Boolean> openNodesMap = this.getOpenNodesMap();
        if (!openNodesMap.containsKey(key)) {
            log.info((WintellActionContext)this.httpSessionContext, String.format("toggleListener(%s).first -> false", key));
            openNodesMap.put(key, Boolean.FALSE);
        } else {
            log.info((WintellActionContext)this.httpSessionContext, String.format("toggleListener(%s) : %s -> %s", key, "" + openNodesMap.get(key), "" + (openNodesMap.get(key) == false)));
            openNodesMap.put(key, openNodesMap.get(key) == false);
        }
        this.modified = true;
    }

    public void setActiveTab(WintellTab activeTab) {
        this.activeTabId = activeTab.getObjIdStr();
        this.modified = true;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public WintellTab getActiveTab() {
        if (this.activeTabId != null) {
            WintellTab activeTab = this.getTab(this.activeTabId);
            if (activeTab != null) {
                activeTab.activity();
                this.modified = true;
            }
            return activeTab;
        }
        return null;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean trimLru(Integer n) throws WintellAppException {
        block7: {
            if (this.getTabsList().size() > n) break block7;
            return false;
        }
        try {
            ArrayList<WintellTab> sortedTabs = new ArrayList<WintellTab>();
            sortedTabs.addAll(this.getTabsList());
            Collections.sort(sortedTabs, new WintellTab.TimeSort());
            if (log.isDebugEnabled()) {
                log.debug((WintellActionContext)this.httpSessionContext, "trimLru - sorted tabs:");
                for (WintellTab t : sortedTabs) {
                    log.debug((WintellActionContext)this.httpSessionContext, "\t" + t.getTabTitle() + " -> " + t.getLastUse());
                }
            }
            log.info((WintellActionContext)this.httpSessionContext, "evicting: numTabs=" + this.getTabsList().size() + ", maxTabs=" + n);
            for (WintellTab t : sortedTabs.subList(n, this.getTabsList().size())) {
                log.info((WintellActionContext)this.httpSessionContext, "evicting: closing LRU TAB:" + t.getTabTitle() + "(lastUse=" + t.getLastUse() + ")");
                this.closeTab(t.getObjIdStr());
            }
        }
        catch (Exception er) {
            if (er instanceof WintellAppException) {
                throw (WintellAppException)er;
            }
            throw new WintellAppException(er);
        }
        return true;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isLogged() {
        return this.loggedUser != null;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void logIn(String user) {
        this.modified = true;
        this.loggedUser = user;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        long t = new Date().getTime();
        stream.defaultReadObject();
        this.getWintellTabs();
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "readObject:time=" + (new Date().getTime() - t));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        long t = new Date().getTime();
        stream.defaultWriteObject();
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "writeObject:time=" + (new Date().getTime() - t));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isShowErrorTab() {
        return this.showErrorTab;
    }

    public void setShowErrorTab(boolean showErrorTab) {
        this.showErrorTab = showErrorTab;
        this.modified = true;
    }

    public boolean isErrorTabActive() {
        return this.errorTabActive;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setErrorTabActive(boolean errorTabActive) {
        this.errorTabActive = errorTabActive;
        this.modified = true;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String getLastError() {
        return this.lastError;
    }

    public void setLastError(String lastError) {
        this.lastError = lastError;
        this.modified = true;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isDebugEvent() {
        return this.debugEvent;
    }

    public void setDebugEvent(boolean debugEvent) {
        this.debugEvent = debugEvent;
        this.modified = true;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void failRequest(String message) {
        this.showErrorTab = true;
        this.errorTabActive = true;
        this.lastError = message;
        this.modified = true;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean togleDebug() {
        this.debugEvent = !this.debugEvent;
        this.modified = true;
        return this.debugEvent;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isModified() {
        if (!this.modified) {
            return false;
        }
        this.modified = false;
        this.finished = false;
        return true;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void finishRequest() {
        this.finished = true;
    }

    @PostConstruct
    public void postConstruct() {
        log.info((WintellActionContext)this.httpSessionContext, "@PostConstruct: this=" + this);
    }

    @PostActivate
    public void postActivate() {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "@PostActivate: this=" + this);
        }
        if (this.wTabsDG != null) {
            try {
                this.wTabsDG.checkLocalInterface();
            }
            catch (Exception e) {
                log.info((WintellActionContext)this.httpSessionContext, "PostActivate: deactivate wTabsDG -> wTabsDG = null");
                this.wTabsDG = null;
            }
        }
    }

    @PrePassivate
    public void prePassivate() {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "@PrePassivate: this=" + this);
        }
    }

    @PreDestroy
    public void preDestroy() {
        log.info((WintellActionContext)this.httpSessionContext, "@PreDesroy: this=" + this);
        if (this.wTabsDG != null) {
            try {
                this.wTabsDG.remove();
            }
            catch (Exception e) {
                log.info((WintellActionContext)this.httpSessionContext, "error in call wTabsDG.remove()");
            }
            this.wTabsDG = null;
        }
    }

    @Override
    @Remove
    public void remove() {
        log.info((WintellActionContext)this.httpSessionContext, "@Remove: this=" + this);
    }

    @Override
    @Destroy
    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "@Destroy: this=" + this);
        }
    }

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "aroundInvoke:" + ctx.getMethod() + ", this=" + this);
        }
        if (ctx.getMethod().getAnnotation(Destroy.class) == null && ctx.getMethod().getAnnotation(Remove.class) == null) {
            this.checkDG();
            this.checkSM();
        }
        Object ret = ctx.proceed();
        this.sm = null;
        return ret;
    }

    private void checkDG() {
        if (this.wTabsDG == null) {
            try {
                InitialContext c = new InitialContext();
                this.wTabsDG = (IWintellTabsDG)c.lookup("java:global/wintell/wintell.jar/wintellTabsDG");
            }
            catch (NamingException e1) {
                log.error((WintellActionContext)this.httpSessionContext, "cannot find wintellTabs", (Throwable)e1);
            }
        }
    }

    private void checkSM() {
        if (this.sm == null) {
            try {
                InitialContext c = new InitialContext();
                this.sm = (IWintellSessionManager)c.lookup("java:app/wintell.jar/wintellSessionManager");
            }
            catch (NamingException e1) {
                log.error((WintellActionContext)this.httpSessionContext, "cannot find sessionManager", (Throwable)e1);
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public WintellTabData getActiveTabData(boolean doDG, WintellActionContext ctx) throws WintellAppException {
        if (this.activeTabId == null) {
            return null;
        }
        return this.getTabData(this.activeTabId, doDG, ctx);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public WintellTabData getTabData(String tabId, boolean doDG, WintellActionContext ctx) throws WintellAppException {
        if (tabId == null) {
            return null;
        }
        if (doDG && !this.wTabsDG.isDG(tabId)) {
            DefaultWintellActionContext actionContext = this.httpSessionContext.getMoreSpecificContext(LogIdFactory.createWintellSessionId((long)this.getSessionId(tabId)));
            String ret = "_NULL_";
            if (this.getTab(tabId) != null) {
                ret = this.getTab(tabId).toString();
            }
            log.info((WintellActionContext)this.httpSessionContext, "2-WintellTabs:" + this.toString() + ".getTab(" + tabId + ") -> " + ret);
            this.wTabsDG.doDG(this.getTab(tabId), (WintellActionContext)actionContext);
        }
        return this.wTabsDG.getTabData(tabId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public MoreInfoResp getMiResp(String tabObjectId, boolean doDG, WintellActionContext ctx) throws WintellAppException {
        if (doDG && !this.wTabsDG.isDG(tabObjectId)) {
            this.wTabsDG.doDG(this.getTab(tabObjectId), ctx);
        }
        return this.getMiResp(tabObjectId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public MoreInfoResp getMiResp(String tabObjectId) {
        return this.wTabsDG.getMiResp(tabObjectId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public WintellResponse getRvaResponse(String tabObjectId, boolean doDG, WintellActionContext ctx) throws WintellAppException {
        if (doDG && !this.wTabsDG.isDG(tabObjectId)) {
            this.wTabsDG.doDG(this.getTab(tabObjectId), ctx);
        }
        return this.getRvaResponse(tabObjectId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public WintellResponse getRvaResponse(String tabObjectId) {
        return this.wTabsDG.getRvaResponse(tabObjectId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setMiResp(String tabObjectId, MoreInfoResp reqMoreInfo) {
        this.wTabsDG.setMiResp(tabObjectId, reqMoreInfo);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setRvaResponse(String tabObjectId, WintellResponse object) {
        this.wTabsDG.setRvaResponse(tabObjectId, object);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public long getSessionId(String objIdStr) {
        WintellTab tab = this.getTab(objIdStr);
        if (tab == null) {
            return -1L;
        }
        return tab.getSessionId();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<String> getTabIdsList() {
        ArrayList<String> ret = new ArrayList<String>();
        for (WintellTab t : this.getTabsList()) {
            ret.add(t.getObjIdStr());
        }
        return ret;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String getTabTitle(String objIdStr) {
        WintellTab tab = this.getTab(objIdStr);
        if (tab == null) {
            return null;
        }
        return tab.getTabTitle();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean isHideMoreInfo(String objIdStr) {
        WintellTab activeTab;
        block3: {
            try {
                activeTab = null;
                activeTab = objIdStr == null ? this.getActiveTab() : this.getTab(objIdStr);
                if (activeTab != null) break block3;
                return true;
            }
            catch (Exception e) {
                log.error((WintellActionContext)this.httpSessionContext, "isHideMoreInfo(" + objIdStr + ")", (Throwable)e);
                return true;
            }
        }
        return activeTab.isHideMoreInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void submit(WintellServiceHandlerRemote handler, WintellStats stats) throws WintellAppException, WintellDGException {
        try {
            WintellTabs wintellTabs = this;
            synchronized (wintellTabs) {
                WintellTabData activeTabData;
                WintellTab activeTab = this.getActiveTab();
                if (activeTab == null) {
                    throw new WintellAppException("submit: activeTab == null");
                }
                try {
                    stats.startState(WintellStats.RequestState.GATHERING_DATA, (WintellActionContext)this.httpSessionContext);
                    activeTabData = this.getActiveTabData(true, (WintellActionContext)this.httpSessionContext);
                    stats.stopState(WintellStats.RequestState.GATHERING_DATA, (WintellActionContext)this.httpSessionContext);
                }
                catch (Exception e) {
                    throw new WintellDGException(e);
                }
                this.sm.submit(activeTab, activeTabData, handler, stats);
            }
        }
        catch (Exception e) {
            throw new WintellAppException(e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Map<Long, WintellOfferActivityButtons> getButtons(String tabId, List<WintellOfferActivity> allOffers) {
        HashMap<Long, WintellOfferActivityButtons> ret = new HashMap<Long, WintellOfferActivityButtons>();
        WintellTab t = this.getTab(tabId);
        if (t == null) {
            log.error((WintellActionContext)this.httpSessionContext, "getButtons, cannot find tabId=" + tabId);
        } else {
            this.modified = true;
            for (WintellOfferActivity woa : allOffers) {
                if (log.isDebugEnabled()) {
                    log.debug((WintellActionContext)this.httpSessionContext, "buttons(size=" + t.getButtons().size() + ").WintellOfferActivity=" + woa);
                }
                t.getButtons(woa);
            }
            ret.putAll(t.getButtons());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public IvccWintellHandler submitWeb(WintellOfferActivity woa, int buttonId, WintellServiceHandlerRemote handler, WintellStats stats) throws WintellAppException, WintellDGException {
        try {
            WintellTabs wintellTabs = this;
            synchronized (wintellTabs) {
                WintellTabData activeTabData;
                WintellTab activeTab = this.getActiveTab();
                if (activeTab == null) {
                    throw new WintellAppException("submit: activeTab == null");
                }
                try {
                    stats.startState(WintellStats.RequestState.GATHERING_DATA, (WintellActionContext)this.httpSessionContext);
                    activeTabData = this.getActiveTabData(true, (WintellActionContext)this.httpSessionContext);
                    stats.stopState(WintellStats.RequestState.GATHERING_DATA, (WintellActionContext)this.httpSessionContext);
                }
                catch (Exception e) {
                    throw new WintellDGException(e);
                }
                return this.sm.submitWeb(activeTab, activeTabData, woa.getOfferActivityId(), buttonId, handler, stats);
            }
        }
        catch (WintellAppException e) {
            throw e;
        }
        catch (WintellDGException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WintellAppException(e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setErrorMessage(String tabId, String errorMessage) {
        this.wTabsDG.setErrorMessage(tabId, errorMessage);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String getErrorMessage(String tabId) {
        return this.wTabsDG.getErrorMessage(tabId);
    }

    public void afterBegin() throws EJBException, RemoteException {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "{ afterBegin: this=" + this);
        }
    }

    public void afterCompletion(boolean succ) throws EJBException, RemoteException {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "} afterCompletion(" + succ + "):" + " this=" + this);
        }
    }

    public void beforeCompletion() throws EJBException, RemoteException {
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "beforeCompletion: this=" + this);
        }
    }
}

