/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.tibco.WintellServiceHandlerRemote;
import cz.nextiraone.tmobile.wintell.IWintellTabsDG;
import cz.nextiraone.tmobile.wintell.WintellTab;
import cz.nextiraone.tmobile.wintell.WintellTabData;
import cz.nextiraone.tmobile.wintell.context.DefaultWintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.exceptions.WintellAppException;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.rva.TibRvaError;
import cz.tmobile.ei.wintell.datatypes.MoreInfoReq;
import cz.tmobile.ei.wintell.datatypes.MoreInfoResp;
import cz.tmobile.ei.wintell.datatypes.WintellRequest;
import cz.tmobile.ei.wintell.datatypes.WintellResponse;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.ejb.AccessTimeout;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.InitialContext;
import org.jboss.seam.annotations.Name;

@Stateful(name="wintellTabsDG")
@Name(value="wintellTabsDG")
@AccessTimeout(value=20L, unit=TimeUnit.SECONDS)
@Remote(value={IWintellTabsDG.class})
public class WintellTabsDG
implements Serializable,
IWintellTabsDG {
    private static final long serialVersionUID = -1277778305374013753L;
    private static final WintellLogger log = WintellLogger.getLogger(WintellTabsDG.class);
    private HashMap<String, WintellTabData> wintellTabsData = new HashMap();

    private WintellTabData getTabData(String tabId, boolean allocIt) {
        WintellTabData d = this.wintellTabsData.get(tabId);
        if (d == null && allocIt) {
            d = new WintellTabData();
            this.wintellTabsData.put(tabId, d);
        }
        return d;
    }

    @Override
    public WintellTabData getTabData(String tabId) {
        return this.getTabData(tabId, false);
    }

    @Override
    public MoreInfoResp getMiResp(String tabId) {
        try {
            return this.getTabData(tabId, false).getMiResp();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public WintellResponse getRvaResponse(String tabId) {
        try {
            return this.getTabData(tabId, false).getRvaResponse();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setDefaultClfyUser(String tabId, String defaultClfyUser) {
        this.getTabData(tabId, true).setDefaultClfyUser(defaultClfyUser);
    }

    @Override
    public void setMiResp(String tabId, MoreInfoResp miResp) {
        this.getTabData(tabId, true).setMiResp(miResp);
    }

    @Override
    public void setRvaResponse(String tabId, WintellResponse rvaResp) {
        this.getTabData(tabId, true).setRvaResponse(rvaResp);
    }

    @Override
    public void closeAll() {
        this.wintellTabsData.clear();
    }

    @Override
    public void closeTab(String tabIdtoClose) {
        this.wintellTabsData.remove(tabIdtoClose);
    }

    @PreDestroy
    public void preDestroy() {
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @Remove
    public void remove() {
    }

    @Override
    public void destroy() {
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void doDG(WintellTab tab, WintellActionContext ctx) throws WintellAppException {
        WintellTabData tabData = null;
        try {
            String tabObjectId = tab.getObjIdStr();
            tabData = this.getTabData(tabObjectId, true);
            log.error(ctx, "PRE doDG - error: " + tabData.getExceptionInfo());
            WintellAppException wE = tabData.getException();
            if (wE != null) {
                throw wE;
            }
            this.setDefaultClfyUser(tabObjectId, tab.getDefaultClfyUser());
            WintellServiceHandlerRemote handler = null;
            InitialContext c = new InitialContext();
            handler = (WintellServiceHandlerRemote)c.lookup("java:global/wintell-tibco/wintell-tibco/wintell/WintellServiceHandler");
            WintellRequest req = new WintellRequest();
            String[] xx = tabObjectId.split(":");
            if (tab.useMSISDN() && tab.getMsisdn() != null) {
                req.setMSISDN(new String(tab.getMsisdn()));
            } else {
                int objType = Integer.parseInt(xx[0]);
                int objId = Integer.parseInt(xx[1]);
                WintellRequest.Consumer consumer = new WintellRequest.Consumer();
                consumer.setCSTYPE(objType);
                consumer.setEXTIDCS(objId);
                req.setConsumer(consumer);
                consumer = null;
            }
            this.setRvaResponse(tabObjectId, handler.reqFindCallerAGS(req, tab.getInterId(), tab.getCorelationId(), ctx));
            MoreInfoReq miReq = new MoreInfoReq();
            if (tab.useMSISDN() && tab.getMsisdn() != null) {
                miReq.setMSISDN(tab.getMsisdn());
            } else {
                int objType = Integer.parseInt(xx[0]);
                int objId = Integer.parseInt(xx[1]);
                miReq.setSubscriberId(new BigInteger("" + objId));
            }
            miReq.setBillingArrangementInfo(true);
            miReq.setPacList(true);
            boolean useSkillList = handler.isConfValueTrueDefaultTrue("ags.useSkillList");
            if (tab.getPin() != null && !"".equals(tab.getPin())) {
                miReq.setUserPin(new BigInteger(tab.getPin()));
            } else {
                useSkillList = false;
            }
            miReq.setSkillList(useSkillList);
            boolean useCustomerInfo = handler.isConfValueTrueDefaultTrue("ags.useCustomerInfo");
            miReq.setCustomerInfo(useCustomerInfo);
            boolean useSubscriberInfo = handler.isConfValueTrueDefaultTrue("ags.useSubscriberInfo");
            miReq.setSubscriberInfo(useSubscriberInfo);
            miReq.setTLSPoints(true);
            miReq.setTeamMemberFullInfo(false);
            this.setMiResp(tabObjectId, handler.reqMoreInfo(miReq, tab.getInterId(), tab.getCorelationId(), ctx));
        }
        catch (WintellAppException e) {
            throw e;
        }
        catch (TibRvaError e) {
            WintellAppException e2 = new WintellAppException("error in gathering data doDG(" + e.getMessage() + ")", e);
            tabData.setException(e2);
            throw e2;
        }
        catch (Exception e) {
            log.error(ctx, "error in gathering data doDG(" + e.getMessage() + ")", (Throwable)e);
            WintellAppException e2 = new WintellAppException("error in gathering data doDG(" + e.getMessage() + ")", e);
            tabData.setException(e2);
            throw e2;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setErrorMessage(String tabId, String errorMessage) {
        try {
            this.getTabData(tabId, false).setErrorMessage(errorMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String getErrorMessage(String tabId) {
        try {
            return this.getTabData(tabId, false).getErrorMessage();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isDG(String tabObjectId) {
        try {
            return this.getTabData(tabObjectId, false).isDG();
        }
        catch (Exception e) {
            log.error((WintellActionContext)new DefaultWintellActionContext(WintellSubprojectEnum.AGS), "error in isDG()", (Throwable)e);
            return false;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void checkLocalInterface() {
    }
}

