/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.rva;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvDate;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvMsgField;
import com.tibco.tibrv.TibrvRvaTransport;
import com.tibco.tibrv.TibrvTransport;
import com.tibco.tibrv.TibrvXml;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.context.WintellSystemActionContext;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.rva.TibRvaError;
import cz.nextiraone.tmobile.wintell.rva.TibRvaTimeout;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.StackKeyedObjectPool;

public class TibRvaTransport {
    private static final WintellLogger log = WintellLogger.getLogger(TibRvaTransport.class);
    private static final WintellActionContext systemActionContext = new WintellSystemActionContext(WintellSubprojectEnum.NONE);
    protected JAXBContext jaxbContext = null;
    public String jaxbPath = "net.tmobile.ei.messaging.datatypes";
    private KeyedObjectPool RvaPool;
    private String host;
    private Integer port;
    private String subjPrefix;
    private TibrvTransport transport = null;
    private double queryTimeout;
    static Boolean rvInitialized = false;
    static int maxPoolSize = 12;
    static int initPoolSize = 5;
    static Pattern pXML = Pattern.compile("^(\\s*<\\?xml\\s+.*?>)(.*?>)(.*)(</.*?>\\s*)$", 42);

    public TibRvaTransport(String host, Integer port, String subjPrefix, double queryTimeout, WintellActionContext ctx) throws TibrvException, JAXBException {
        this.host = host;
        this.port = port;
        this.subjPrefix = subjPrefix;
        this.queryTimeout = queryTimeout;
        this.jaxbContext = JAXBContext.newInstance((String)this.jaxbPath);
        this.connect(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(WintellActionContext ctx) throws TibrvException, JAXBException {
        log.info(ctx, "Init Tibco Library");
        Boolean bl = rvInitialized;
        synchronized (bl) {
            try {
                if (!rvInitialized.booleanValue()) {
                    Tibrv.open();
                    rvInitialized = true;
                }
                log.info(ctx, "TIBCO Rendezvous V" + Tibrv.getVersion() + " Java API");
            }
            catch (TibrvException e) {
                log.fatal(ctx, "Failed to open Tibrv implementation: " + e.getMessage(), (Throwable)e);
                throw e;
            }
            log.info(ctx, "connecting to RVA: " + this.host + ":" + this.port);
            try {
                if (this.transport == null) {
                    log.info(ctx, "connecting to RVA: " + this.host + ":" + this.port);
                    this.transport = new TibrvRvaTransport(this.host, this.port.intValue());
                    this.transport.setDescription("WintellRvaClient");
                }
            }
            catch (TibrvException e) {
                log.fatal(ctx, "Failed to create TibrvRvaTransport: " + e.getMessage(), (Throwable)e);
                throw e;
            }
            log.info(ctx, "Allocating Pool");
            this.RvaPool = new StackKeyedObjectPool((KeyedPoolableObjectFactory)new MsgHandleFactory(), maxPoolSize, initPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws TibrvException {
        Boolean bl = rvInitialized;
        synchronized (bl) {
            Tibrv.close();
            rvInitialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sendMessage(String subject, byte[] xml, String corelationId, String requestId) throws TibrvException, TibRvaError {
        Object error;
        MsgHandle handle = null;
        Exception ee = null;
        try {
            Boolean bl = rvInitialized;
            synchronized (bl) {
                handle = (MsgHandle)this.RvaPool.borrowObject((Object)subject);
            }
        }
        catch (Exception e) {
            ee = e;
        }
        if (handle == null) {
            error = "Unable to borrow MsgHandle(" + subject + ") from pool";
            if (ee == null) {
                throw new TibRvaTimeout(subject, corelationId, requestId, (String)error, true);
            }
            throw new TibRvaTimeout(subject, corelationId, requestId, (String)error + "/" + ee.getMessage(), true);
        }
        try {
            error = handle;
            synchronized (error) {
                byte[] byArray = handle.send(xml, corelationId, requestId);
                return byArray;
            }
        }
        finally {
            block27: {
                try {
                    if (null == handle) break block27;
                    Boolean bl = rvInitialized;
                    synchronized (bl) {
                        this.RvaPool.returnObject((Object)subject, (Object)handle);
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> sendMessage(String subject, String corelationId, String requestId, List<String> order, Map<String, Object> request, WintellActionContext actionContext) throws TibrvException, TibRvaTimeout {
        Object error;
        MsgHandle handle = null;
        Exception ee = null;
        try {
            Boolean bl = rvInitialized;
            synchronized (bl) {
                handle = (MsgHandle)this.RvaPool.borrowObject((Object)subject);
            }
        }
        catch (Exception e) {
            ee = e;
        }
        if (handle == null) {
            error = "Unable to borrow MsgHandle(" + subject + ") from pool";
            if (ee == null) {
                throw new TibRvaTimeout(subject, corelationId, requestId, (String)error, true);
            }
            throw new TibRvaTimeout(subject, corelationId, requestId, (String)error + "/" + ee.getMessage(), true);
        }
        try {
            error = handle;
            synchronized (error) {
                Map<String, Object> map = handle.sendHash(order, request, actionContext);
                return map;
            }
        }
        finally {
            block27: {
                try {
                    if (null == handle) break block27;
                    Boolean bl = rvInitialized;
                    synchronized (bl) {
                        this.RvaPool.returnObject((Object)subject, (Object)handle);
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    public Object sendMessage(String subject, Object req, Class<?> retType, String corelationId, String requestId, WintellActionContext ctx) throws TibrvException, TibRvaError {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal(req, (Writer)writer);
            marshaller = null;
            String xmlBody = writer.toString();
            try {
                writer.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            writer = null;
            Matcher mI = pXML.matcher(xmlBody);
            if (mI.matches()) {
                xmlBody = mI.group(1) + "\n<body>" + mI.group(2) + mI.group(3) + mI.group(4) + "</body>\n";
            }
            mI = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug(ctx, "SEND REQUEST(" + subject + "): " + xmlBody);
                }
                byte[] ret = this.sendMessage(subject, xmlBody.getBytes("UTF8"), corelationId, requestId);
                xmlBody = null;
                if (ret == null) {
                    return null;
                }
                String xmlResp = new String(ret, "utf8");
                if (log.isDebugEnabled()) {
                    log.debug(ctx, "GET RESPONSE: " + xmlResp);
                }
                ret = null;
                Matcher mO = pXML.matcher(xmlResp);
                if (mO.matches()) {
                    xmlResp = mO.group(1) + mO.group(3);
                }
                mO = null;
                StringBuffer xmlStr = new StringBuffer(xmlResp);
                xmlResp = null;
                StringReader xmlSr = new StringReader(xmlStr.toString());
                xmlStr = null;
                StreamSource xmlSs = new StreamSource(xmlSr);
                xmlSr = null;
                Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
                JAXBElement retX = unmarshaller.unmarshal((Source)xmlSs, retType);
                xmlSs = null;
                unmarshaller = null;
                Object retO = retX.getValue();
                retX = null;
                return retO;
            }
            catch (UnsupportedEncodingException e) {
                log.fatal(ctx, "UnsupportedEncodingException exeption:" + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        catch (JAXBException e) {
            log.fatal(ctx, "caught jaxb exeption:" + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            log.fatal(ctx, "runtime exeption:" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public class MsgHandleFactory
    extends BaseKeyedPoolableObjectFactory {
        public void destroyObject(Object key, Object obj) {
            MsgHandle m = (MsgHandle)obj;
            m.subject = null;
            m.queryMsg = null;
        }

        public Object makeObject(Object subject) throws Exception {
            try {
                String devSubject = TibRvaTransport.this.subjPrefix + "." + (String)subject;
                log.info(systemActionContext, "Allocating MsgHandle(" + devSubject + ")");
                return new MsgHandle(devSubject);
            }
            catch (TibrvException e) {
                log.fatal(systemActionContext, "cannot alloc subject on RVA-transport: " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    private class MsgHandle {
        private String subject;
        private TibrvMsg queryMsg;

        public MsgHandle(String subject) throws TibrvException {
            String responseSubject;
            this.subject = subject;
            try {
                responseSubject = TibRvaTransport.this.transport.createInbox();
            }
            catch (TibrvException e) {
                log.fatal(systemActionContext, "Failed to create response_subject: " + e.getMessage());
                throw e;
            }
            this.queryMsg = new TibrvMsg();
            try {
                this.queryMsg.setSendSubject(subject);
                this.queryMsg.setReplySubject(responseSubject);
            }
            catch (TibrvException e) {
                log.error(systemActionContext, "Failed to set message: query_subject=" + subject + ", response_subject=" + responseSubject);
                throw e;
            }
        }

        private void marshall(TibrvMsg msg, List<String> order, Map<String, Object> hash, WintellActionContext actionContext) throws TibrvException {
            if (order != null) {
                for (String k : order) {
                    Object o = hash.get(k);
                    this.marshallOne(msg, k, o, actionContext);
                }
                return;
            }
            if (hash instanceof LinkedHashMap) {
                LinkedHashMap hm = (LinkedHashMap)hash;
                for (Map.Entry es : hm.entrySet()) {
                    String k = (String)es.getKey();
                    Object o = es.getValue();
                    this.marshallOne(msg, k, o, actionContext);
                }
            }
        }

        private Object marshallOne(TibrvMsg msg, String k, Object o, WintellActionContext actionContext) throws TibrvException {
            if (o instanceof List) {
                TibrvMsg outer = new TibrvMsg();
                List objA = (List)o;
                for (Object oo : objA) {
                    Object mo = this.marshallOne(null, null, oo, actionContext);
                    outer.add("item", mo);
                }
                if (msg != null) {
                    msg.update(k, (Object)outer);
                }
                if (log.isDebugEnabled()) {
                    log.debug(actionContext, "\t" + (k == null ? "_NULL_" : k) + "=" + outer.toString());
                }
                return outer;
            }
            if (o instanceof LinkedHashMap) {
                TibrvMsg outer = new TibrvMsg();
                this.marshall(outer, null, (Map)o, actionContext);
                if (msg != null) {
                    msg.update(k, (Object)outer);
                }
                if (log.isDebugEnabled()) {
                    log.debug(actionContext, "\t" + (k == null ? "_NULL_" : k) + "=" + outer.toString());
                }
                return outer;
            }
            if (msg == null) {
                return o;
            }
            if (o == null) {
                return null;
            }
            if (o instanceof String) {
                msg.update(k, (Object)((String)o));
            } else if (o instanceof Long) {
                msg.update(k, (Object)((Long)o));
            } else if (o instanceof Integer) {
                msg.update(k, (Object)((Integer)o));
            } else if (o instanceof BigInteger) {
                msg.update(k, (Object)((BigInteger)o));
            } else if (o instanceof Date) {
                msg.update(k, (Object)((Date)o));
            } else {
                String err = "object of unsupported class for key=" + k + ":" + o.getClass().getName();
                log.error(actionContext, err);
                throw new RuntimeException(err);
            }
            if (log.isDebugEnabled()) {
                log.debug(actionContext, "\t" + k + "=" + o);
            }
            return o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Object> sendHash(List<String> order, Map<String, Object> hash, WintellActionContext actionContext) throws TibrvException {
            TibrvMsg replyMsg = null;
            TibrvMsg tibrvMsg = this.queryMsg;
            synchronized (tibrvMsg) {
                if (log.isDebugEnabled()) {
                    log.debug(actionContext, "sendRequest.request: " + this.subject);
                }
                this.marshall(this.queryMsg, order, hash, actionContext);
                replyMsg = TibRvaTransport.this.transport.sendRequest(this.queryMsg, TibRvaTransport.this.queryTimeout);
            }
            if (replyMsg == null) {
                log.error(actionContext, "timeout (after " + TibRvaTransport.this.queryTimeout + "sec) while receiving message");
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug(actionContext, "sendRequest.response:");
            }
            Map<String, Object> ret = this.getRvMsg(replyMsg, "\t", actionContext);
            replyMsg = null;
            return ret;
        }

        private Map<String, Object> getRvMsg(TibrvMsg msg, String prefixL, WintellActionContext actionContext) throws TibrvException {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            for (int i = 0; i < msg.getNumFields(); ++i) {
                String err;
                TibrvMsgField f = msg.getFieldByIndex(i);
                if (f == null) {
                    err = "reply doesn't contain " + i + "-th field";
                    log.error(actionContext, err);
                    throw new RuntimeException(err);
                }
                if (log.isDebugEnabled()) {
                    log.debug(actionContext, prefixL + f.data.getClass().getName() + ":" + f.name + "=" + f.data);
                }
                if ("java.lang".equals(f.data.getClass().getPackage().getName())) {
                    this.putObj(ret, f.name, f.data);
                    continue;
                }
                if (f.data instanceof TibrvDate) {
                    this.putObj(ret, f.name, new Date(((TibrvDate)f.data).getTime()));
                    continue;
                }
                if (f.data instanceof TibrvMsg) {
                    this.putObj(ret, f.name, this.getRvMsg((TibrvMsg)f.data, prefixL + "\t", actionContext));
                    continue;
                }
                err = "Field '" + f.name + "' of unsupported Data Type:" + f.data.getClass().getName();
                log.error(actionContext, err);
            }
            return ret;
        }

        private void putObj(Map<String, Object> ret, String name, Object data) {
            Object o = ret.get(name);
            if (o == null) {
                ret.put(name, data);
                return;
            }
            ArrayList<Object> a = null;
            if (o instanceof ArrayList) {
                a = (ArrayList<Object>)o;
            } else {
                a = new ArrayList<Object>();
                a.add(o);
                ret.put(name, a);
            }
            a.add(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] send(byte[] xml, String corelationId, String requestId) throws TibrvException, TibRvaError {
            TibrvMsg replyMsg = null;
            TibrvMsg tibrvMsg = this.queryMsg;
            synchronized (tibrvMsg) {
                this.queryMsg.update("xml", (Object)new TibrvXml(xml));
                replyMsg = TibRvaTransport.this.transport.sendRequest(this.queryMsg, TibRvaTransport.this.queryTimeout);
                this.queryMsg.removeField("xml");
            }
            if (replyMsg == null) {
                throw new TibRvaTimeout(this.subject, corelationId, requestId, "timeout (after " + TibRvaTransport.this.queryTimeout + "sec) while receiving message");
            }
            TibrvMsgField f = replyMsg.getField("xml");
            if (f == null) {
                throw new TibRvaError(this.subject, corelationId, requestId, "reply doesn't contain 'xml' field");
            }
            if (f.type != 47) {
                throw new TibRvaError(this.subject, corelationId, requestId, "'xml' field in reply doesn't match TibrvMsg.XML type");
            }
            TibrvXml xx = (TibrvXml)f.data;
            byte[] ret = xx.getBytes();
            xx = null;
            return ret;
        }
    }
}

