/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.tibco;

import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.tibco.TibcoErrorCodes;
import cz.nextiraone.tmobile.wintell.tibco.TibcoException;
import cz.nextiraone.tmobile.wintell.tibor.TibOr;
import cz.nextiraone.tmobile.wintell.tibor.TibOrElemRecord;
import cz.nextiraone.tmobile.wintell.tibor.TibOrException;
import cz.nextiraone.tmobile.wintell.tibor.TibOrMessage;
import cz.nextiraone.tmobile.wintell.tibor.TibOrMsgHdr;
import cz.nextiraone.tmobile.wintell.tibor.model.TibcoBody;
import cz.nextiraone.tmobile.wintell.tibor.model.TibcoHeader;
import cz.nextiraone.tmobile.wintell.tibor.model.TibcoMessage;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlType;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class Tibco {
    private static final WintellLogger log = WintellLogger.getLogger(Tibco.class);
    protected JAXBContext jaxbContext = JAXBContext.newInstance((String)this.jaxbPath);
    static final String WINTELL_USER = "WINTELL";
    public String jaxbPath = "cz.nextiraone.tmobile.wintell.tibor.model:net.tmobile.ei.messaging.datatypes";
    TibOr tibor = null;

    public Tibco(Connection c) throws JAXBException {
        this.tibor = new TibOr(c);
    }

    public void accept(TibcoMessage m, WintellActionContext ctx) throws TibOrException {
        TibcoHeader h = m.getHeader();
        this.tibor.accept_msg(h.getMsg_id(), h.getMsg_name(), WINTELL_USER, ctx);
    }

    public List<Long> getMsgList(Class classFactory, WintellActionContext ctx) throws TibOrException {
        return this.tibor.get_msg_list(this.getMessageNameForClass(classFactory), WINTELL_USER, ctx);
    }

    public String vccngConvertWintell(String icaller_type, String icaller_id, String itarget_type, String itarget_id, String imodule_id, Integer imedium_id, String iinteraction_id, String iclarify_user, WintellActionContext ctx) throws TibOrException {
        return this.tibor.vccng_convert_wintell(icaller_type, icaller_id, itarget_type, itarget_id, imodule_id, imedium_id, iinteraction_id, iclarify_user, ctx);
    }

    public String vccConvertBoost(String iuser, String idirectory_number, Integer iaction_id, String imedium_id, String iinteraction_id, WintellActionContext ctx) throws TibOrException {
        return this.tibor.vcc_convert_boost(iuser, idirectory_number, iaction_id, imedium_id, iinteraction_id, ctx);
    }

    public int sendMessageRaw(String msgName, Map<String, String> body, Long businessProcessId, WintellActionContext ctx) throws TibOrException {
        TibOrMsgHdr tiborHeader = new TibOrMsgHdr();
        tiborHeader.setBusiness_process_id(businessProcessId);
        tiborHeader.setMsg_name(msgName);
        tiborHeader.setSend_datim(new Timestamp(new Date().getTime()));
        TibOrMessage tiborMesage = new TibOrMessage(tiborHeader, null);
        ArrayList<TibOrElemRecord> ba = new ArrayList<TibOrElemRecord>();
        Integer i = 1;
        for (Map.Entry<String, String> e : body.entrySet()) {
            TibOrElemRecord r = new TibOrElemRecord();
            r.setElem_small_value(e.getValue());
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            r.setElem_idx(n);
            r.setElem_name(e.getKey());
            ba.add(r);
            if (!log.isDebugEnabled()) continue;
            log.debug(ctx, "FLDNAME=VALUE:" + e.getKey() + "=" + e.getValue());
        }
        tiborMesage.body = new Object[ba.size()];
        ba.toArray(tiborMesage.body);
        this.tibor.send_msg(tiborMesage, WINTELL_USER, ctx);
        return 0;
    }

    public int sendMessage(TibcoBody b, Long businessProcessId, WintellActionContext ctx) throws TibOrException {
        String msgName = null;
        XmlType annot = b.getClass().getAnnotation(XmlType.class);
        msgName = annot != null ? annot.name() : b.getClass().getSimpleName();
        TibOrMsgHdr tiborHeader = new TibOrMsgHdr();
        tiborHeader.setBusiness_process_id(businessProcessId);
        tiborHeader.setMsg_name(msgName);
        tiborHeader.setSend_datim(new Timestamp(new Date().getTime()));
        TibOrMessage tiborMesage = new TibOrMessage(tiborHeader, null);
        ArrayList<TibOrElemRecord> ba = new ArrayList<TibOrElemRecord>();
        Integer i = 1;
        for (Field f : b.getClass().getFields()) {
            TibOrElemRecord r = new TibOrElemRecord();
            String elem_small_value = null;
            try {
                Object o;
                if (f.getType() == String.class) {
                    elem_small_value = f.getName().equals("TIB_PROCESS_ID") ? businessProcessId.toString() : (String)f.get(b);
                } else if (f.getType() == Integer.class) {
                    o = (Integer)f.get(b);
                    if (o != null) {
                        elem_small_value = ((Integer)o).toString();
                    }
                } else if (f.getType() == Long.class) {
                    o = (Long)f.get(b);
                    if (o != null) {
                        elem_small_value = ((Long)o).toString();
                    }
                } else if (f.getType() == Date.class) {
                    Calendar c = Calendar.getInstance();
                    elem_small_value = String.format("%04d-%02d-%02d %02d:%02d:%02d", c.get(1), c.get(2), c.get(5), c.get(11), c.get(12), c.get(13));
                } else {
                    o = f.get(b);
                    if (o != null) {
                        Marshaller marshaller = this.jaxbContext.createMarshaller();
                        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                        StringWriter writer = new StringWriter();
                        marshaller.marshal(o, (Writer)writer);
                        elem_small_value = writer.toString();
                    }
                }
            }
            catch (IllegalArgumentException e) {
                log.info(ctx, "IllegalArgumentException: " + e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.info(ctx, "IllegalAccessException: " + e.getMessage(), (Throwable)e);
            }
            catch (PropertyException e) {
                log.info(ctx, "PropertyException: " + e.getMessage(), (Throwable)e);
            }
            catch (JAXBException e) {
                log.info(ctx, "JAXBException: " + e.getMessage(), (Throwable)e);
            }
            r.setElem_small_value(elem_small_value);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            r.setElem_idx(n);
            r.setElem_name(f.getName());
            ba.add(r);
            if (!log.isDebugEnabled()) continue;
            log.debug(ctx, "FLDNAME/CLASS/VALUE:" + f.getName() + "/" + f.getType().getName() + "/" + elem_small_value);
        }
        tiborMesage.body = new Object[ba.size()];
        ba.toArray(tiborMesage.body);
        this.tibor.send_msg(tiborMesage, WINTELL_USER, ctx);
        return 0;
    }

    public void reject(TibcoMessage m, Integer iapp_err_code, String iapp_err_msg, WintellActionContext ctx) throws TibOrException {
        TibcoHeader h = m.getHeader();
        this.tibor.reject_msg(h.getMsg_id(), h.getMsg_name(), WINTELL_USER, iapp_err_code, iapp_err_msg, ctx);
    }

    public TibcoMessage readMessage(Class classFactory, Long itib_mhi_id, WintellActionContext ctx) throws TibOrException {
        try {
            return this.readMessageEx(classFactory, itib_mhi_id, ctx);
        }
        catch (TibcoException e) {
            Long msgId = e.getMsg().getHeader().getMsg_id();
            if (e.getErrCode() == TibcoErrorCodes.ERR_CLASS_EXCEPTION.code) {
                log.fatal(ctx, "Cannot get Tibco message(" + msgId + "): " + e.getMessage(), (Throwable)e);
                return null;
            }
            try {
                this.reject(e.getMsg(), e.getErrCode(), e.getErrMsg(), ctx);
                log.error(ctx, "Rejecting in Tibco message(" + msgId + "):" + e.getErrMsg(), (Throwable)e);
                return e.getMsg();
            }
            catch (TibOrException e1) {
                log.fatal(ctx, "Cannot reject Tibco message(" + msgId + "):" + e1.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    public int getTibMessagesCount(Class classFactory, WintellActionContext ctx) throws TibOrException {
        return this.tibor.count_msg_in(this.getMessageNameForClass(classFactory), WINTELL_USER, ctx);
    }

    private TibcoMessage readMessageEx(Class classFactory, Long itib_mhi_id, WintellActionContext ctx) throws TibcoException, TibOrException {
        TibOrMessage m = null;
        String msgName = this.getMessageNameForClass(classFactory);
        m = itib_mhi_id == null ? this.tibor.read_first_msg(msgName, WINTELL_USER, ctx) : this.tibor.read_msg(itib_mhi_id, msgName, WINTELL_USER, ctx);
        if (m == null) {
            return null;
        }
        TibcoMessage msg = new TibcoMessage();
        msg.setHeader(new TibcoHeader(m.header));
        msg.setJaxbContext(this.jaxbContext);
        TibcoBody sc = null;
        try {
            sc = (TibcoBody)classFactory.newInstance();
        }
        catch (InstantiationException e1) {
            throw new TibcoException(msg, TibcoErrorCodes.ERR_CLASS_EXCEPTION, " cannot get class: " + classFactory.getName() + "; ERROR: " + e1.getLocalizedMessage());
        }
        catch (IllegalAccessException e1) {
            throw new TibcoException(msg, TibcoErrorCodes.ERR_CLASS_EXCEPTION, " cannot get class: " + classFactory.getName() + "; ERROR: " + e1.getLocalizedMessage());
        }
        String fName = null;
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            for (Object o : m.body) {
                TibOrElemRecord r = (TibOrElemRecord)o;
                fName = r.getElem_name();
                Field f = null;
                try {
                    f = classFactory.getField(fName);
                    String val = r.getElem_small_value();
                    if (val == null && r.getElem_large_value() != null) {
                        Long len = r.getElem_large_value().length();
                        val = r.getElem_large_value().getSubString(1L, len.intValue());
                    }
                    if (f.getType() == String.class) {
                        f.set(sc, val);
                        continue;
                    }
                    if (f.getType() == Integer.class) {
                        f.set(sc, Integer.parseInt(val));
                        continue;
                    }
                    if (f.getType() == Long.class) {
                        f.set(sc, new Long(val));
                        continue;
                    }
                    if (f.getType() == Date.class) {
                        String tz = val.substring(19);
                        tz = "".equals(tz) ? "CET" : "GMT" + tz;
                        String[] dd = val.split("[-:\\s\\+]");
                        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(tz));
                        c.set(Integer.parseInt(dd[0]), Integer.parseInt(dd[1]) - 1, Integer.parseInt(dd[2]), Integer.parseInt(dd[3]), Integer.parseInt(dd[4]), Integer.parseInt(dd[5]));
                        f.set(sc, c.getTime());
                        if (!log.isDebugEnabled()) continue;
                        log.debug(ctx, "TZ='" + tz + "':" + c.getTimeZone() + "STRING='" + val + "', PARSED='" + c.getTime() + "'");
                        continue;
                    }
                    ByteArrayInputStream input = new ByteArrayInputStream(val.getBytes());
                    JAXBElement paramsX = unmarshaller.unmarshal((Source)new StreamSource(input), f.getType().getClass());
                    f.set(sc, paramsX.getValue());
                }
                catch (NumberFormatException e) {
                    throw new TibcoException(msg, TibcoErrorCodes.ERR_FIELD_FORMAT, " of " + fName + "; ERROR: " + e.getLocalizedMessage());
                }
                catch (IllegalArgumentException e) {
                    throw new TibcoException(msg, TibcoErrorCodes.ERR_FIELD_SET, " of " + fName + "; ERROR: " + e.getLocalizedMessage());
                }
                catch (IllegalAccessException e) {
                    throw new TibcoException(msg, TibcoErrorCodes.ERR_FIELD_SET, " of " + fName + "; ERROR: " + e.getLocalizedMessage());
                }
                catch (NoSuchFieldException e) {
                    log.warn(ctx, (Object)((Object)TibcoErrorCodes.ERR_FIELD_NOTEXISTS) + ": " + fName + "; WARNING: " + e.getLocalizedMessage());
                }
                catch (SQLException e) {
                    throw new TibcoException(msg, TibcoErrorCodes.ERR_XML_PARSING, " of " + fName + "; ERROR: sql.clob - " + e.getLocalizedMessage());
                }
            }
        }
        catch (JAXBException e) {
            throw new TibcoException(msg, TibcoErrorCodes.ERR_XML_PARSING, " of " + fName + "; ERROR: " + e.getLocalizedMessage());
        }
        msg.setBody(sc);
        return msg;
    }

    private String getMessageNameForClass(Class classFactory) {
        String msgName = null;
        XmlType annot = classFactory.getAnnotation(XmlType.class);
        if (annot != null) {
            msgName = annot.name();
            if (msgName.equals("##default")) {
                msgName = classFactory.getSimpleName();
            }
        } else {
            msgName = classFactory.getSimpleName();
        }
        return msgName;
    }
}

