/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.rva;

import com.tibco.tibrv.TibrvException;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.rva.TibRvaError;
import cz.nextiraone.tmobile.wintell.rva.TibRvaTimeout;
import cz.nextiraone.tmobile.wintell.rva.TibRvaTransport;
import cz.tmobile.ei.wintell.datatypes.IntegrationMessage;
import cz.tmobile.ei.wintell.datatypes.MainMessage;
import cz.tmobile.ei.wintell.datatypes.MoreInfoErrorResponse;
import cz.tmobile.ei.wintell.datatypes.WintellErrorResponse;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import net.tmobile.ei.messaging.datatypes.EIMessageContext;

public class TibRvaWintell
extends TibRvaTransport {
    private static final WintellLogger log = WintellLogger.getLogger(TibRvaWintell.class);

    public TibRvaWintell(String host, Integer port, String subjPrefix, double queryTimeout, WintellActionContext ctx) throws TibrvException, JAXBException {
        super(host, port, subjPrefix, queryTimeout, ctx);
        this.jaxbPath = this.jaxbPath + ":cz.tmobile.ei.wintell.datatypes";
        this.jaxbContext = JAXBContext.newInstance((String)this.jaxbPath);
    }

    public IntegrationMessage callMessage(String subject, IntegrationMessage req, String corelationId, Long requestId, WintellActionContext ctx) throws TibrvException, TibRvaError {
        MainMessage m = new MainMessage();
        EIMessageContext h = new EIMessageContext();
        h.setSender("Wintell");
        h.setCorrelationId(corelationId);
        h.setRequestId(String.format("WIN%010d", requestId));
        if (log.isInfoEnabled()) {
            log.info(ctx, "sending message: subject=" + subject + ", corelationId=" + corelationId + ", requestId=" + h.getRequestId());
        }
        m.setHeader(h);
        m.setPart(req);
        MainMessage rep = (MainMessage)this.sendMessage(subject, m, MainMessage.class, corelationId, "" + requestId, ctx);
        if (rep == null) {
            throw new TibRvaTimeout(subject, corelationId, h.getRequestId(), null);
        }
        IntegrationMessage resp = rep.getPart();
        if (resp instanceof WintellErrorResponse) {
            throw new TibRvaError(subject, corelationId, h.getRequestId(), ((WintellErrorResponse)resp).getErrorMessage());
        }
        if (resp instanceof MoreInfoErrorResponse) {
            throw new TibRvaError(subject, corelationId, h.getRequestId(), ((MoreInfoErrorResponse)resp).getErrorMessage());
        }
        return resp;
    }

    public Map<String, Object> callMessage(String subject, List<String> order, Map<String, Object> req, String corelationId, Long requestId, WintellActionContext ctx) throws TibrvException, TibRvaError {
        return this.sendMessage(subject, corelationId, requestId.toString(), order, req, ctx);
    }
}

