/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.tibor;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class PlSqlCall {
    private CallableStatement cstmt;
    private int paramN;
    private HashMap<String, ParamEntry> h;
    private List<ParamEntry> a;
    private String sql;
    private String ret_type;
    Connection con;
    public static String RET_NAME = "!_._RET_._!";

    public PlSqlCall(Connection con, String sql_name, String ret_type) throws SQLException {
        this.con = con;
        this.ret_type = ret_type;
        this.paramN = 1;
        this.h = new HashMap();
        this.a = new ArrayList<ParamEntry>();
        this.cstmt = null;
        this.sql = "{";
        if (!ret_type.equals("")) {
            this.registerParam(RET_NAME, "OUT", ret_type);
            this.sql = this.sql + "? = ";
        }
        this.sql = this.sql + "call " + sql_name + "(";
    }

    public void prepare() throws SQLException {
        this.sql = this.sql + ")}";
        this.cstmt = this.con.prepareCall(this.sql);
        for (ParamEntry p : this.a) {
            p.init(this.cstmt);
        }
    }

    public void registerParam(String name, String io, String type) throws SQLException {
        ParamEntry p = new ParamEntry(this.paramN, name, io, type);
        this.h.put(name, p);
        this.a.add(p);
        ++this.paramN;
        if (!name.equals(RET_NAME)) {
            if (this.sql.endsWith("?")) {
                this.sql = this.sql + ",";
            }
            this.sql = this.sql + "?";
        }
    }

    public boolean execute() throws SQLException {
        return this.cstmt.execute();
    }

    public String getString(String paramName) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return null;
        }
        return this.h.get(paramName).getString();
    }

    public void setString(String paramName, String val) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return;
        }
        this.h.get(paramName).setString(val);
    }

    public int getInt(String paramName) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return -1;
        }
        return this.h.get(paramName).getInt();
    }

    public void setInt(String paramName, int val) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return;
        }
        this.h.get(paramName).setInt(val);
    }

    public long getLong(String paramName) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return -1L;
        }
        return this.h.get(paramName).getLong();
    }

    public void setLong(String paramName, Long val) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return;
        }
        this.h.get(paramName).setLong(val);
    }

    public Map<String, Class<?>> getMap(String paramName) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return null;
        }
        return this.h.get(paramName).getMap();
    }

    public void setMap(String paramName, Map<String, Class<?>> map) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return;
        }
        this.h.get(paramName).setMap(map);
    }

    public Object getObject(String paramName) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return null;
        }
        return this.h.get(paramName).getObject();
    }

    public void setObject(String paramName, Object o) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return;
        }
        this.h.get(paramName).setObject(o);
    }

    public void setTimestamp(String paramName, Timestamp o) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return;
        }
        this.h.get(paramName).setTimestamp(o);
    }

    public Object[] getArray(String paramName) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return null;
        }
        return this.h.get(paramName).getArray();
    }

    public void setArray(String paramName, Object[] o) throws SQLException {
        if (!this.h.containsKey(paramName)) {
            return;
        }
        this.h.get(paramName).setArray(o);
    }

    public String toString() {
        String str = "FUNCTION: " + this.sql;
        for (ParamEntry p : this.a) {
            if (p.name.equals(RET_NAME)) continue;
            str = str + "\n" + p.name + "\t" + (p.isIn ? "IN" : "") + (p.isOut ? "OUT" : "") + "\t" + p.type;
            if (p.structdesc == null) continue;
            try {
                str = str + "\tSTRUCT " + p.structdesc.getJavaClassName() + "{";
            }
            catch (SQLException e1) {
                // empty catch block
            }
            str = str + "}\n";
        }
        if (!this.ret_type.equals("")) {
            str = str + "\nRETURNS " + this.ret_type;
        }
        return str;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public class ParamEntry {
        public int n;
        public String type;
        public boolean isIn;
        public boolean isOut;
        public String name;
        private CallableStatement cstmt;
        private StructDescriptor structdesc;
        ArrayDescriptor arrayDescriptor;

        public ParamEntry(int n, String name, String io, String tx) throws SQLException {
            this.n = n;
            this.cstmt = null;
            this.name = name;
            this.type = tx;
            this.isIn = false;
            this.isOut = false;
            this.structdesc = null;
            if (io.matches("OUT")) {
                this.isOut = true;
            }
            if (io.matches("IN")) {
                this.isIn = true;
            }
        }

        public void init(CallableStatement cstmt) throws SQLException {
            String tx;
            this.cstmt = cstmt;
            int t = 2002;
            if (this.type.matches(".*\\[\\]")) {
                t = 2003;
                tx = this.type.replaceFirst("\\[\\]", "");
                this.arrayDescriptor = ArrayDescriptor.createDescriptor((String)tx.toUpperCase(), (Connection)cstmt.getConnection());
            } else if (this.type.equals("INTEGER")) {
                t = 4;
            } else if (this.type.equals("NUMBER")) {
                t = 2;
            } else if (this.type.equals("VARCHAR2") || this.type.equals("VARCHAR")) {
                t = 12;
            } else {
                this.structdesc = null;
            }
            if (this.isOut) {
                if (t == 2002) {
                    cstmt.registerOutParameter(this.n, t, this.type);
                } else if (t == 2003) {
                    tx = this.type.replaceFirst("\\[\\]", "");
                    cstmt.registerOutParameter(this.n, t, tx);
                } else {
                    cstmt.registerOutParameter(this.n, t);
                }
            }
        }

        public String getString() throws SQLException {
            return this.cstmt.getString(this.n);
        }

        public void setString(String val) throws SQLException {
            this.cstmt.setString(this.n, val);
        }

        public int getInt() throws SQLException {
            return this.cstmt.getInt(this.n);
        }

        public void setInt(int val) throws SQLException {
            this.cstmt.setInt(this.n, val);
        }

        public Map<String, Class<?>> getMap() throws SQLException {
            Struct s = (Struct)this.cstmt.getObject(this.n);
            Map<String, Class<?>> map = null;
            s.getAttributes(map);
            return map;
        }

        public void setMap(Map<String, Class<?>> map) throws SQLException {
            STRUCT s = new STRUCT(this.structdesc, this.cstmt.getConnection(), map);
            this.cstmt.setObject(this.n, (Object)s);
        }

        public Object getObject() throws SQLException {
            return this.cstmt.getObject(this.n);
        }

        public void setObject(Object o) throws SQLException {
            this.cstmt.setObject(this.n, o);
        }

        public Object[] getArray() throws SQLException {
            return (Object[])((ARRAY)this.cstmt.getObject(this.n)).getArray();
        }

        public void setArray(Object[] o) throws SQLException {
            ARRAY sqlArray = new ARRAY(this.arrayDescriptor, this.cstmt.getConnection(), (Object)o);
            this.cstmt.setArray(this.n, (Array)sqlArray);
        }

        public void setTimestamp(Timestamp o) throws SQLException {
            this.cstmt.setTimestamp(this.n, o);
        }

        public void setLong(Long val) throws SQLException {
            this.cstmt.setLong(this.n, (long)val);
        }

        public long getLong() throws SQLException {
            return this.cstmt.getLong(this.n);
        }
    }
}

