/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.loaders;

import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.context.WintellSystemActionContext;
import cz.nextiraone.tmobile.wintell.loaders.WintellLoaderServiceLocal;
import cz.nextiraone.tmobile.wintell.loaders.WintellLoaderServiceManagement;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Local;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@Startup
@Singleton(name="wintell/loaderService")
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@Local(value={WintellLoaderServiceLocal.class})
public class WintellLoaderService
implements WintellLoaderServiceManagement,
WintellLoaderServiceLocal {
    public static final String WINTELL_PROPERTIES_FILENAME = "../server/wintell1/config/connections.properties";
    private static final WintellLogger log = WintellLogger.getLogger(WintellLoaderService.class);
    private static final WintellActionContext systemActionContext = new WintellSystemActionContext(WintellSubprojectEnum.NONE);
    private Properties properties = new Properties();
    private MBeanServer platformMBeanServer;
    private ObjectName objectName = null;

    public void create() {
        log.info(systemActionContext, this.getClass().getSimpleName() + " bean create");
        this.reloadConfiguration();
    }

    public void destroy() {
        log.info(systemActionContext, this.getClass().getSimpleName() + " bean destroy");
    }

    public void start() {
        log.info(systemActionContext, this.getClass().getSimpleName() + " bean start");
    }

    public void stop() {
        log.info(systemActionContext, this.getClass().getSimpleName() + " bean stop");
    }

    @Override
    public void reloadConfiguration() {
        FileInputStream in = null;
        try {
            in = new FileInputStream(WINTELL_PROPERTIES_FILENAME);
            this.properties.clear();
            this.properties.load(in);
            log.info(systemActionContext, "proper file load");
            this.listPropertiesToLog();
        }
        catch (FileNotFoundException e) {
            log.fatal(systemActionContext, "properties file not found", (Throwable)e);
        }
        catch (IOException e) {
            log.fatal(systemActionContext, "properties file not loaded: IOException: ", (Throwable)e);
        }
    }

    @Override
    public String getValue(String name) {
        String retString = null;
        if (this.properties != null) {
            retString = this.properties.getProperty(name);
        }
        return retString;
    }

    @Override
    public void setValue(String key, String value) {
        this.properties.setProperty(key, value);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    private void listPropertiesToLog() {
        String propsList = null;
        try {
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            this.properties.list(printWriter);
            propsList = strWriter.getBuffer().toString();
            printWriter.close();
            strWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info(systemActionContext, "Listing properties: \n" + propsList);
    }

    @PostConstruct
    public void registerInJMX() {
        try {
            this.objectName = new ObjectName("wintell:custom=loaderService");
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.platformMBeanServer.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during registration of Monitoring into JMX:" + e);
        }
        this.create();
        this.start();
    }

    @PreDestroy
    public void unregisterFromJMX() {
        try {
            this.platformMBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during unregistration of Monitoring into JMX:" + e);
        }
        this.stop();
    }
}

