/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.rva.service;

import com.tibco.tibrv.TibrvException;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.context.WintellSystemActionContext;
import cz.nextiraone.tmobile.wintell.loaders.WintellLoaderServiceLocal;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.rva.TibRvaError;
import cz.nextiraone.tmobile.wintell.rva.TibRvaWintell;
import cz.nextiraone.tmobile.wintell.rva.service.WintellRvaServiceLocal;
import cz.nextiraone.tmobile.wintell.rva.service.WintellRvaServiceManagement;
import cz.tmobile.ei.wintell.datatypes.IntegrationMessage;
import cz.tmobile.ei.wintell.datatypes.MoreInfoReq;
import cz.tmobile.ei.wintell.datatypes.MoreInfoResp;
import cz.tmobile.ei.wintell.datatypes.WintellRequest;
import cz.tmobile.ei.wintell.datatypes.WintellResponse;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.bind.JAXBException;

@Startup
@Singleton(name="wintell/rvaService")
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@Local(value={WintellRvaServiceLocal.class})
public class WintellRvaService
implements WintellRvaServiceManagement,
WintellRvaServiceLocal {
    private static final WintellLogger log = WintellLogger.getLogger(WintellRvaService.class);
    private static final WintellActionContext systemActionContext = new WintellSystemActionContext(WintellSubprojectEnum.NONE);
    private MBeanServer platformMBeanServer;
    private ObjectName objectName = null;
    @EJB(name="wintell/loader-service")
    WintellLoaderServiceLocal ls;
    TibRvaWintell rva = null;
    private String host;
    private Integer port;
    private String subprefix;
    private double timeout;
    private String message = new String("Initial state. Rva not connected.");
    private State state = State.RVADISCONNECT;

    @Override
    public String getConnectionConf() {
        return new String("Host: " + this.host + ", Port: " + this.port + ", Subprefix: " + this.subprefix + ", Timeout: " + this.timeout);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State state) {
        State state2 = this.state;
        synchronized (state2) {
            this.state = state;
        }
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
        this.reconnect(systemActionContext);
    }

    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setPort(Integer port) {
        this.port = port;
        this.reconnect(systemActionContext);
    }

    public String getSubprefix() {
        return this.subprefix;
    }

    @Override
    public void setSubprefix(String subprefix) {
        this.subprefix = subprefix;
        this.reconnect(systemActionContext);
    }

    public double getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(double timeout) {
        this.timeout = timeout;
        this.reconnect(systemActionContext);
    }

    private void reconnect(WintellActionContext ctx) {
        this.disconnect(ctx);
        this.connect(ctx);
    }

    public Map<String, Object> trySendMessage(String subject, List<String> order, Map<String, Object> req, String corelationId, Long requestId, WintellActionContext ctx) throws TibrvException, TibRvaError {
        String reqId = String.format("WIN%010d", requestId % 100000000000L);
        if (this.rva == null) {
            this.connect(ctx);
            if (this.rva == null) {
                throw new TibRvaError(subject, corelationId, reqId, "cannot connect");
            }
        }
        Date now = new Date();
        Map<String, Object> ret = null;
        req.put("CALLER", "Wintell");
        req.put("TIB_PROCESS_ID", reqId);
        req.put("TIB_CORRELATION_ID", corelationId);
        req.put("TIB_SEND_DATIM", now);
        req.put("TIB_PROCESS_TIMESTAMP", now);
        try {
            ret = this.rva.sendMessage(subject, corelationId, requestId.toString(), order, req, ctx);
        }
        catch (TibrvException e) {
            this.message = "Tibor connection fail djuring invocation method tryCallMessage(String subject, String type, IntegrationMessage req)";
            log.error(ctx, "Tibor connection fail during tryCallMessage: " + e.getMessage(), (Throwable)e);
            this.setState(State.RVADISCONNECT);
            throw e;
        }
        return ret;
    }

    @Override
    public Map<String, Object> sendMessage(String subject, List<String> order, Map<String, Object> req, String corelationId, Long requestId, WintellActionContext ctx) throws TibRvaError {
        if (this.state == State.RVADISCONNECT) {
            this.connect(ctx);
        }
        Map<String, Object> ret = null;
        try {
            ret = this.trySendMessage(subject, order, req, corelationId, requestId, ctx);
        }
        catch (TibrvException e) {
            this.setState(State.RVADISCONNECT);
            this.connect(ctx);
            try {
                ret = this.trySendMessage(subject, order, req, corelationId, requestId, ctx);
            }
            catch (Exception e1) {
                this.message = "TiborService tries seccond connect" + this.getClass().getSimpleName() + "!!!\n" + e.getMessage();
                log.error(ctx, "Exception while TiborService tries second connect: " + e.getMessage(), (Throwable)e);
                this.setState(State.RVADISCONNECT);
                throw new TibRvaError(subject, corelationId, requestId.toString(), "cannot reconnect to TibcoRVA: " + e1.getMessage());
            }
        }
        return ret;
    }

    private IntegrationMessage tryCallMessage(String subject, String type, IntegrationMessage req, String corelationId, Long requestId, WintellActionContext ctx) throws TibrvException, TibRvaError {
        String reqId = String.format("WIN%010d", requestId);
        if (this.rva == null) {
            this.connect(ctx);
            if (this.rva == null) {
                throw new TibRvaError(subject, corelationId, reqId, "cannot connect");
            }
        }
        IntegrationMessage im = null;
        req.setType(type);
        try {
            im = this.rva.callMessage(subject, req, corelationId, requestId, ctx);
        }
        catch (TibrvException e) {
            this.message = "Tibor connection fail djuring invocation method tryCallMessage(String subject, String type, IntegrationMessage req)";
            log.error(ctx, "Tibor connection fail during tryCallMessage: " + e.getMessage(), (Throwable)e);
            this.setState(State.RVADISCONNECT);
            throw e;
        }
        return im;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public IntegrationMessage callMessage(String subject, String type, IntegrationMessage req, String corelationId, Long requestId, WintellActionContext ctx) throws TibRvaError {
        if (this.state == State.RVADISCONNECT) {
            this.connect(ctx);
        }
        IntegrationMessage im = null;
        try {
            im = this.tryCallMessage(subject, type, req, corelationId, requestId, ctx);
        }
        catch (TibRvaError e) {
            throw e;
        }
        catch (TibrvException e) {
            this.setState(State.RVADISCONNECT);
            this.connect(ctx);
            try {
                im = this.tryCallMessage(subject, type, req, corelationId, requestId, ctx);
            }
            catch (Exception e1) {
                this.message = "TiborService tries seccond connect" + this.getClass().getSimpleName() + "!!!\n" + e.getMessage();
                log.error(ctx, "Exception while TiborService tries second connect: " + e.getMessage(), (Throwable)e);
                this.setState(State.RVADISCONNECT);
                throw new TibRvaError(subject, corelationId, requestId.toString(), "cannot reconnect to TibcoRVA: " + e1.getMessage());
            }
        }
        return im;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public WintellResponse reqFindCallerAGS(WintellRequest req, String corelationId, Long requestId, WintellActionContext ctx) throws TibRvaError {
        return (WintellResponse)this.callMessage("REQ.businessParty.NULL.findCaller.1", "AGS", req, corelationId, requestId, ctx);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public WintellResponse reqFindCallerBPA(WintellRequest req, String corelationId, Long requestId, WintellActionContext ctx) throws TibRvaError {
        return (WintellResponse)this.callMessage("REQ.businessParty.NULL.findCaller.1", "BPA", req, corelationId, requestId, ctx);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public MoreInfoResp reqMoreInfo(MoreInfoReq req, String corelationId, Long requestId, WintellActionContext ctx) throws TibRvaError {
        IntegrationMessage resp = this.callMessage("REQ.businessParty.subscriber.getMoreInfo.1", "MoreInfo", req, corelationId, requestId, ctx);
        return (MoreInfoResp)resp;
    }

    private void connect(WintellActionContext ctx) {
        try {
            this.rva = new TibRvaWintell(this.host, this.port, this.subprefix, this.timeout, ctx);
            this.message = "Rva connection succes.";
            this.setState(State.READY);
        }
        catch (TibrvException e) {
            this.message = "Rva connection fail djuring creating " + this.getClass().getSimpleName() + "!!!\n" + e.getMessage();
            log.error(ctx, e.getMessage(), (Throwable)e);
            this.setState(State.RVADISCONNECT);
        }
        catch (JAXBException e) {
            this.message = "JAXB fails djuring creating " + this.getClass().getSimpleName() + "!!!\n" + e.getMessage();
            log.error(ctx, e.getMessage(), (Throwable)e);
            this.setState(State.RVADISCONNECT);
        }
    }

    private void disconnect(WintellActionContext ctx) {
        try {
            if (this.rva != null) {
                this.rva.disconnect();
            }
            this.state = State.RVADISCONNECT;
        }
        catch (TibrvException e) {
            this.message = "Rva disconnection fail. Class: " + this.getClass().getSimpleName() + "!!!\n" + e.getMessage();
            log.error(ctx, "Rva disconnect failed, caught TibrvException: " + e.getMessage(), (Throwable)e);
            this.setState(State.RVADISCONNECT);
        }
        catch (Exception e) {
            this.message = "Rva disconnection fail. Class: " + this.getClass().getSimpleName() + "!!!\n" + e.getMessage();
            log.error(ctx, "Rva disconnect failed, caught other exception: " + e.getMessage(), (Throwable)e);
            this.setState(State.RVADISCONNECT);
        }
    }

    private void loadConfiguration() {
        this.host = this.ls.getValue("rva.host");
        this.port = Integer.parseInt(this.ls.getValue("rva.port"));
        this.subprefix = this.ls.getValue("rva.subPrefix");
        this.timeout = Double.parseDouble(this.ls.getValue("rva.timeout"));
    }

    @Override
    public void create() {
        log.info(systemActionContext, this.getClass().getSimpleName() + " bean create");
    }

    @Override
    public void destroy() {
        log.info(systemActionContext, this.getClass().getSimpleName() + " bean destroy");
        if (this.state == State.READY && this.rva != null) {
            this.disconnect(systemActionContext);
        }
    }

    @Override
    public void start() {
        log.info(systemActionContext, this.getClass().getSimpleName() + " bean start");
        try {
            this.ls.reloadConfiguration();
            this.loadConfiguration();
            log.info(systemActionContext, this.host + this.port + this.subprefix + this.timeout);
            if (this.state == State.RVADISCONNECT) {
                this.connect(systemActionContext);
            }
        }
        catch (RuntimeException e) {
            log.error(systemActionContext, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stop() {
        log.info(systemActionContext, this.getClass().getSimpleName() + " bean stop");
        this.disconnect(systemActionContext);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Object sendMessage(String subject, Object req, Class<?> retType, String corelationId, String requestId, WintellActionContext ctx) {
        if (this.state == State.RVADISCONNECT) {
            this.connect(ctx);
        }
        Object o = null;
        try {
            o = this.rva.sendMessage(subject, req, retType, corelationId, requestId, ctx);
        }
        catch (TibrvException e) {
            this.message = "Tibor throws exception. Messages wasn't send by method sendMessage(String subject, Object req, Class<?> retType);\n" + e.getMessage();
            log.error(ctx, "Tibor exception while sendMessage: " + e.getMessage(), (Throwable)e);
            this.setState(State.RVADISCONNECT);
        }
        catch (Exception e) {
            this.message = e.getMessage();
            log.error(ctx, "Other exception while Tibor sendMessage: " + e.getMessage(), (Throwable)e);
            this.setState(State.RVADISCONNECT);
        }
        return o;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public byte[] sendMessage(String subject, byte[] xml, String corelationId, String requestId, WintellActionContext ctx) {
        if (this.state == State.RVADISCONNECT) {
            this.connect(ctx);
        }
        byte[] ret = null;
        try {
            ret = this.rva.sendMessage(subject, xml, corelationId, requestId);
        }
        catch (TibrvException e) {
            this.message = "Tibor throws exception. Messages wasn't send by method sendMessage(String subject, byte[] xml);\n" + e.getMessage();
            log.error(ctx, "Caught TibrvException while sendMessage: " + e.getMessage(), (Throwable)e);
            this.setState(State.RVADISCONNECT);
        }
        catch (Exception e) {
            this.message = e.getMessage();
            log.error(ctx, "Caught other exception while sendMessage: " + e.getMessage(), (Throwable)e);
            this.setState(State.RVADISCONNECT);
        }
        return ret;
    }

    @Override
    public String test() {
        if (this.state == State.RVADISCONNECT) {
            this.connect(systemActionContext);
        }
        String retString = new String();
        System.out.println("hallo test");
        WintellRequest.Consumer cons = new WintellRequest.Consumer();
        WintellRequest wr = new WintellRequest();
        wr.setConsumer(cons);
        wr.setMSISDN("1111");
        retString = retString + "\nWintellRequest\n";
        retString = retString + wr.toString();
        WintellResponse wres = null;
        try {
            wres = this.reqFindCallerBPA(wr, "WIN88888888", 1L, systemActionContext);
        }
        catch (TibRvaError e) {
            log.error(systemActionContext, "Caught TibRvaError while testing reqFindCallerBPA: " + e.getMessage(), (Throwable)e);
        }
        retString = retString + "WintellResponse\n";
        if (wres != null) {
            retString = retString + wres.toString();
            log.info(systemActionContext, "mam odpoved");
            log.info(systemActionContext, wres.toString());
        }
        retString = retString + "konec testu";
        return retString;
    }

    @Override
    public void reconnectFromConfFile() {
        this.ls.reloadConfiguration();
        this.loadConfiguration();
        this.reconnect(systemActionContext);
    }

    @PostConstruct
    public void registerInJMX() {
        try {
            this.objectName = new ObjectName("wintell:custom=rvaService");
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.platformMBeanServer.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during registration of Monitoring into JMX:" + e);
        }
        this.create();
        this.start();
    }

    @PreDestroy
    public void unregisterFromJMX() {
        try {
            this.platformMBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during unregistration of Monitoring into JMX:" + e);
        }
        this.stop();
    }

    public static enum State {
        READY,
        RVADISCONNECT;

    }
}

