/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.tibor;

import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.context.WintellSystemActionContext;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.tibor.PlSqlCall;
import cz.nextiraone.tmobile.wintell.tibor.PlSqlFunction;
import cz.nextiraone.tmobile.wintell.tibor.TibOrElemRecord;
import cz.nextiraone.tmobile.wintell.tibor.TibOrException;
import cz.nextiraone.tmobile.wintell.tibor.TibOrMessage;
import cz.nextiraone.tmobile.wintell.tibor.TibOrMsgHdr;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TibOr {
    private static final WintellLogger log = WintellLogger.getLogger(TibOr.class);
    private static final WintellActionContext systemActionContext = new WintellSystemActionContext(WintellSubprojectEnum.NONE);
    private Connection con = null;
    private Map<String, Class<?>> myMap = null;
    private Map<String, PlSqlCall> h;

    public TibOr(Connection myCon) {
        this.con = myCon;
        this.h = new HashMap<String, PlSqlCall>();
        try {
            this.myMap = this.con.getTypeMap();
            this.myMap.put("SY_WINTELL.MSG_HEADER_O", TibOrMsgHdr.class);
            this.myMap.put("SY_WINTELL.ELEM_RECORD_O", TibOrElemRecord.class);
            this.con.setTypeMap(this.myMap);
        }
        catch (SQLException e) {
            log.error(systemActionContext, "Exception in TibOr constructor: " + e.getMessage(), (Throwable)e);
        }
        this.readAnnotations();
    }

    private PlSqlCall getStatement(WintellActionContext ctx) throws TibOrException {
        String fn = new Throwable().getStackTrace()[1].getMethodName();
        PlSqlCall call = this.h.get(fn);
        if (call == null) {
            throw new TibOrException(new Throwable("cannot get cstmt in function:" + fn));
        }
        if (log.isDebugEnabled()) {
            log.debug(ctx, "Waiting (in fuction:" + fn + ") for PL/SQL statement: " + call.getSql() + " ...");
        }
        return call;
    }

    private void readAnnotations() {
        try {
            for (Method m : this.getClass().getMethods()) {
                Annotation[] annos;
                for (Annotation a : annos = m.getAnnotations()) {
                    if (a instanceof PlSqlFunction) {
                        PlSqlFunction ta = (PlSqlFunction)a;
                        PlSqlCall cstmt = null;
                        try {
                            cstmt = new PlSqlCall(this.con, ta.sql_fn(), ta.returns());
                            for (String p : ta.params()) {
                                String[] s = p.split("\\s+");
                                String nm = s[0];
                                String io = s[1];
                                String ty = s[2];
                                cstmt.registerParam(nm, io, ty);
                            }
                            cstmt.prepare();
                            this.h.put(m.getName(), cstmt);
                            if (!log.isDebugEnabled()) continue;
                            log.debug(systemActionContext, "DUMP" + cstmt.toString());
                        }
                        catch (SQLException e) {
                            log.error(systemActionContext, "Caught exception in readAnnotations: " + e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    log.error(systemActionContext, "annotation:" + ((Object)a).toString());
                }
            }
        }
        catch (Exception e) {
            log.fatal(systemActionContext, "read_annotation:" + e.getMessage(), (Throwable)e);
        }
    }

    @PlSqlFunction(sql_fn="sy_tibor.tibor_app_pck.count_msg_in", params={"imsg_name    IN       VARCHAR2", "iuser_name   IN       VARCHAR2", "ocount_msg   OUT      NUMBER", "oerr_code    OUT      NUMBER", "oerr_msg     OUT      VARCHAR2"}, returns="NUMBER")
    public Integer count_msg_in(String imsg_name, String iuser_name, WintellActionContext ctx) throws TibOrException {
        PlSqlCall cstmt = this.getStatement(ctx);
        long before = System.currentTimeMillis();
        PlSqlCall plSqlCall = cstmt;
        synchronized (plSqlCall) {
            log.info(ctx, "PL/SQL statement " + cstmt.getSql() + " obtained in " + (System.currentTimeMillis() - before) + "ms, going to execute query...");
            try {
                cstmt.setString("imsg_name", imsg_name);
                cstmt.setString("iuser_name", iuser_name);
                before = System.currentTimeMillis();
                cstmt.execute();
                log.info(ctx, "PL/SQL statement " + cstmt.getSql() + " executed in " + (System.currentTimeMillis() - before) + "ms");
                if (cstmt.getInt("oerr_code") != 0 || cstmt.getInt(PlSqlCall.RET_NAME) != 0) {
                    throw new TibOrException(cstmt);
                }
                return cstmt.getInt("ocount_msg");
            }
            catch (SQLException e) {
                throw new TibOrException(cstmt, e.getMessage(), e.getErrorCode());
            }
        }
    }

    @PlSqlFunction(sql_fn="sy_wintell.tibor_jdbc_pck.read_msg", params={"itib_mhi_id   IN       NUMBER", "imsg_name     IN       VARCHAR2", "iuser_name    IN       VARCHAR2", "omsg_header   OUT      SY_WINTELL.MSG_HEADER_O", "omsg_body     OUT      SY_WINTELL.MSG_BODY_C[]", "omsg_count    OUT      NUMBER", "oerr_code     OUT      NUMBER", "oerr_msg      OUT      VARCHAR2"}, returns="NUMBER")
    public TibOrMessage read_msg(Long itib_mhi_id, String imsg_name, String iuser_name, WintellActionContext ctx) throws TibOrException {
        PlSqlCall cstmt = this.getStatement(ctx);
        long before = System.currentTimeMillis();
        PlSqlCall plSqlCall = cstmt;
        synchronized (plSqlCall) {
            if (log.isDebugEnabled()) {
                log.debug(ctx, "PL/SQL statement " + cstmt.getSql() + " obtained in " + (System.currentTimeMillis() - before) + "ms, going to execute query...");
            }
            try {
                cstmt.setLong("itib_mhi_id", itib_mhi_id);
                cstmt.setString("imsg_name", imsg_name);
                cstmt.setString("iuser_name", iuser_name);
                before = System.currentTimeMillis();
                cstmt.execute();
                if (log.isDebugEnabled()) {
                    log.debug(ctx, "PL/SQL statement " + cstmt.getSql() + " executed in " + (System.currentTimeMillis() - before) + "ms");
                }
                if (cstmt.getInt("oerr_code") != 0 || cstmt.getInt(PlSqlCall.RET_NAME) != 0) {
                    if (cstmt.getInt(PlSqlCall.RET_NAME) == 1 && cstmt.getInt("oerr_code") == 20501) {
                        return null;
                    }
                    throw new TibOrException(cstmt);
                }
                return new TibOrMessage((TibOrMsgHdr)cstmt.getObject("omsg_header"), cstmt.getArray("omsg_body"));
            }
            catch (SQLException e) {
                throw new TibOrException(cstmt, e.getMessage(), e.getErrorCode());
            }
        }
    }

    @PlSqlFunction(sql_fn="sy_wintell.tibor_jdbc_pck.read_first_msg", params={"imsg_name     IN       VARCHAR2", "iuser_name    IN       VARCHAR2", "omsg_header   OUT      SY_WINTELL.MSG_HEADER_O", "omsg_body     OUT      SY_WINTELL.MSG_BODY_C[]", "omsg_count    OUT      NUMBER", "oerr_code     OUT      NUMBER", "oerr_msg      OUT      VARCHAR2"}, returns="NUMBER")
    public TibOrMessage read_first_msg(String imsg_name, String iuser_name, WintellActionContext ctx) throws TibOrException {
        PlSqlCall cstmt = this.getStatement(ctx);
        long before = System.currentTimeMillis();
        PlSqlCall plSqlCall = cstmt;
        synchronized (plSqlCall) {
            log.info(ctx, "PL/SQL statement " + cstmt.getSql() + " obtained in " + (System.currentTimeMillis() - before) + "ms, going to execute query...");
            try {
                cstmt.setString("imsg_name", imsg_name);
                cstmt.setString("iuser_name", iuser_name);
                before = System.currentTimeMillis();
                cstmt.execute();
                log.info(ctx, "PL/SQL statement " + cstmt.getSql() + " executed in " + (System.currentTimeMillis() - before) + "ms");
                if (cstmt.getInt("oerr_code") != 0 || cstmt.getInt(PlSqlCall.RET_NAME) != 0) {
                    if (cstmt.getInt(PlSqlCall.RET_NAME) == 1 && cstmt.getInt("oerr_code") == 20501) {
                        return null;
                    }
                    throw new TibOrException(cstmt);
                }
                return new TibOrMessage((TibOrMsgHdr)cstmt.getObject("omsg_header"), cstmt.getArray("omsg_body"));
            }
            catch (SQLException e) {
                throw new TibOrException(cstmt, e.getMessage(), e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PlSqlFunction(sql_fn="sy_tibor.tibor_app_pck.accept_msg", params={"itib_mhi_id   IN       NUMBER", "imsg_name     IN       VARCHAR2", "iuser_name    IN       VARCHAR2", "oerr_code     OUT      NUMBER", "oerr_msg      OUT      VARCHAR2"}, returns="NUMBER")
    public void accept_msg(Long long1, String imsg_name, String iuser_name, WintellActionContext ctx) throws TibOrException {
        PlSqlCall cstmt = this.getStatement(ctx);
        long before = System.currentTimeMillis();
        PlSqlCall plSqlCall = cstmt;
        synchronized (plSqlCall) {
            if (log.isDebugEnabled()) {
                log.debug(ctx, "PL/SQL statement " + cstmt.getSql() + " obtained in " + (System.currentTimeMillis() - before) + "ms, going to execute query...");
            }
            try {
                cstmt.setLong("itib_mhi_id", long1);
                cstmt.setString("imsg_name", imsg_name);
                cstmt.setString("iuser_name", iuser_name);
                before = System.currentTimeMillis();
                cstmt.execute();
                if (log.isDebugEnabled()) {
                    log.debug(ctx, "PL/SQL statement " + cstmt.getSql() + " executed in " + (System.currentTimeMillis() - before) + "ms");
                }
                if (cstmt.getInt("oerr_code") != 0 || cstmt.getInt(PlSqlCall.RET_NAME) != 0) {
                    throw new TibOrException(cstmt);
                }
            }
            catch (SQLException e) {
                throw new TibOrException(cstmt, e.getMessage(), e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PlSqlFunction(sql_fn="sy_tibor.tibor_app_pck.reject_msg", params={"itib_mhi_id     IN       NUMBER", "imsg_name       IN       VARCHAR2", "iuser_name      IN       VARCHAR2", "iapp_err_code   IN       NUMBER", "iapp_err_msg    IN       VARCHAR2", "oerr_code       OUT      NUMBER", "oerr_msg        OUT      VARCHAR2"}, returns="NUMBER")
    public void reject_msg(Long long1, String imsg_name, String iuser_name, Integer iapp_err_code, String iapp_err_msg, WintellActionContext ctx) throws TibOrException {
        PlSqlCall cstmt = this.getStatement(ctx);
        long before = System.currentTimeMillis();
        PlSqlCall plSqlCall = cstmt;
        synchronized (plSqlCall) {
            if (log.isDebugEnabled()) {
                log.debug(ctx, "PL/SQL statement " + cstmt.getSql() + " obtained in " + (System.currentTimeMillis() - before) + "ms, going to execute query...");
            }
            try {
                cstmt.setLong("itib_mhi_id", long1);
                cstmt.setString("imsg_name", imsg_name);
                cstmt.setString("iuser_name", iuser_name);
                cstmt.setInt("iapp_err_code", iapp_err_code);
                cstmt.setString("iapp_err_msg", iapp_err_msg);
                before = System.currentTimeMillis();
                cstmt.execute();
                if (log.isDebugEnabled()) {
                    log.debug(ctx, "PL/SQL statement " + cstmt.getSql() + " executed in " + (System.currentTimeMillis() - before) + "ms");
                }
                if (cstmt.getInt("oerr_code") != 0 || cstmt.getInt(PlSqlCall.RET_NAME) != 0) {
                    throw new TibOrException(cstmt);
                }
            }
            catch (SQLException e) {
                throw new TibOrException(cstmt, e.getMessage(), e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PlSqlFunction(sql_fn="sy_wintell.tibor_jdbc_pck.send_msg", params={"itib_process_id   IN       NUMBER", "itib_send_datim   IN       DATE", "imsg_name         IN       VARCHAR2", "imsg_body         IN       SY_WINTELL.MSG_BODY_C[]", "iuser_name        IN       VARCHAR2", "oerr_code         OUT      NUMBER", "oerr_msg          OUT      VARCHAR2"}, returns="NUMBER")
    public void send_msg(TibOrMessage m, String iuser_name, WintellActionContext ctx) throws TibOrException {
        PlSqlCall cstmt = this.getStatement(ctx);
        long before = System.currentTimeMillis();
        PlSqlCall plSqlCall = cstmt;
        synchronized (plSqlCall) {
            log.info(ctx, "PL/SQL statement " + cstmt.getSql() + " obtained in " + (System.currentTimeMillis() - before) + "ms, going to execute query...");
            try {
                cstmt.setLong("itib_process_id", m.header.getBusiness_process_id());
                cstmt.setTimestamp("itib_send_datim", m.header.getSend_datim());
                cstmt.setString("imsg_name", m.header.getMsg_name());
                cstmt.setArray("imsg_body", m.body);
                cstmt.setString("iuser_name", iuser_name);
                before = System.currentTimeMillis();
                cstmt.execute();
                log.info(ctx, "PL/SQL statement " + cstmt.getSql() + " executed in " + (System.currentTimeMillis() - before) + "ms");
                if (cstmt.getInt("oerr_code") != 0 || cstmt.getInt(PlSqlCall.RET_NAME) != 0) {
                    throw new TibOrException(cstmt);
                }
            }
            catch (SQLException e) {
                throw new TibOrException(cstmt, e.getMessage(), e.getErrorCode());
            }
        }
    }

    @PlSqlFunction(sql_fn="sy_wintell.tibor_jdbc_pck.get_msg_list", params={"imsg_name          IN       VARCHAR2", "iuser_name         IN       VARCHAR2", "omsg_header_list   OUT      SY_WINTELL.MSG_HEADER_C[]", "omsg_count         OUT      NUMBER", "oerr_code          OUT      NUMBER", "oerr_msg           OUT      VARCHAR2", "icount             IN       INTEGER"}, returns="NUMBER")
    public List<Long> get_msg_list(String imsg_name, String iuser_name, WintellActionContext ctx) throws TibOrException {
        PlSqlCall cstmt = this.getStatement(ctx);
        long before = System.currentTimeMillis();
        PlSqlCall plSqlCall = cstmt;
        synchronized (plSqlCall) {
            log.info(ctx, "PL/SQL statement " + cstmt.getSql() + " obtained in " + (System.currentTimeMillis() - before) + "ms, going to execute query...");
            try {
                cstmt.setString("imsg_name", imsg_name);
                cstmt.setString("iuser_name", iuser_name);
                cstmt.setInt("icount", 90000);
                before = System.currentTimeMillis();
                cstmt.execute();
                log.info(ctx, "PL/SQL statement " + cstmt.getSql() + " executed in " + (System.currentTimeMillis() - before) + "ms");
                if (cstmt.getInt("oerr_code") != 0 || cstmt.getInt(PlSqlCall.RET_NAME) != 0) {
                    throw new TibOrException(cstmt);
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                for (Object o : cstmt.getArray("omsg_header_list")) {
                    TibOrMsgHdr th = (TibOrMsgHdr)o;
                    ids.add(th.getMsg_id());
                }
                log.info(ctx, "PL/SQL statement " + cstmt.getSql() + " returned: " + ids.size() + " records");
                return ids;
            }
            catch (SQLException e) {
                throw new TibOrException(cstmt, e.getMessage(), e.getErrorCode());
            }
        }
    }

    @PlSqlFunction(sql_fn="sy_wintell.VCCNG_CONVERT_WINTEL", params={"icaller_type    IN    VARCHAR2", "icaller_id      IN    VARCHAR2", "itarget_type    IN    VARCHAR2", "itarget_id      IN    VARCHAR2", "imodule_id      IN    VARCHAR2", "imedium_id      IN    NUMBER", "iinteraction_id IN    VARCHAR2", "iclarify_user   IN    VARCHAR2", "oout_text       OUT   VARCHAR2", "oerror_text     OUT   VARCHAR2"}, returns="INTEGER")
    public String vccng_convert_wintell(String icaller_type, String icaller_id, String itarget_type, String itarget_id, String imodule_id, Integer imedium_id, String iinteraction_id, String iclarify_user, WintellActionContext ctx) throws TibOrException {
        PlSqlCall cstmt = this.getStatement(ctx);
        long before = System.currentTimeMillis();
        PlSqlCall plSqlCall = cstmt;
        synchronized (plSqlCall) {
            if (log.isDebugEnabled()) {
                log.debug(ctx, "PL/SQL statement " + cstmt.getSql() + " obtained in " + (System.currentTimeMillis() - before) + "ms, going to execute query...");
            }
            try {
                cstmt.setString("icaller_type", icaller_type);
                cstmt.setString("icaller_id", icaller_id);
                cstmt.setString("itarget_type", itarget_type);
                cstmt.setString("itarget_id", itarget_id);
                cstmt.setString("imodule_id", imodule_id);
                cstmt.setInt("imedium_id", imedium_id);
                cstmt.setString("iinteraction_id", iinteraction_id);
                cstmt.setString("iclarify_user", iclarify_user);
                before = System.currentTimeMillis();
                cstmt.execute();
                if (log.isDebugEnabled()) {
                    log.debug(ctx, "PL/SQL statement " + cstmt.getSql() + " executed in " + (System.currentTimeMillis() - before) + "ms");
                }
                if (cstmt.getInt(PlSqlCall.RET_NAME) != 0) {
                    throw new TibOrException(cstmt, cstmt.getString("oerror_text"));
                }
                return cstmt.getString("oout_text");
            }
            catch (SQLException e) {
                throw new TibOrException(cstmt, e.getMessage(), e.getErrorCode());
            }
        }
    }

    @PlSqlFunction(sql_fn="sy_wintell.VCC_CONVERT_BOOST", params={"iuser             IN  VARCHAR2", "idirectory_number IN  VARCHAR2", "iaction_id        IN  NUMBER", "imedium_id        IN  VARCHAR2", "iinteraction_id   IN  VARCHAR2", "oout_text         OUT VARCHAR2", "oerror            OUT NUMBER"}, returns="INTEGER")
    public String vcc_convert_boost(String iuser, String idirectory_number, Integer iaction_id, String imedium_id, String iinteraction_id, WintellActionContext ctx) throws TibOrException {
        PlSqlCall cstmt = this.getStatement(ctx);
        long before = System.currentTimeMillis();
        PlSqlCall plSqlCall = cstmt;
        synchronized (plSqlCall) {
            if (log.isDebugEnabled()) {
                log.debug(ctx, "PL/SQL statement " + cstmt.getSql() + " obtained in " + (System.currentTimeMillis() - before) + "ms, going to execute query...");
            }
            try {
                cstmt.setString("iuser", iuser);
                cstmt.setString("idirectory_number", idirectory_number);
                cstmt.setInt("iaction_id", iaction_id);
                cstmt.setString("imedium_id", imedium_id);
                cstmt.setString("iinteraction_id", iinteraction_id);
                before = System.currentTimeMillis();
                cstmt.execute();
                if (log.isDebugEnabled()) {
                    log.debug(ctx, "PL/SQL statement " + cstmt.getSql() + " executed in " + (System.currentTimeMillis() - before) + "ms");
                }
                if (cstmt.getInt(PlSqlCall.RET_NAME) != 0) {
                    throw new TibOrException(cstmt, cstmt.getString("oerror"));
                }
                return cstmt.getString("oout_text");
            }
            catch (SQLException e) {
                throw new TibOrException(cstmt, e.getMessage(), e.getErrorCode());
            }
        }
    }
}

