/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.tibor.service;

import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.context.WintellSystemActionContext;
import cz.nextiraone.tmobile.wintell.loaders.WintellLoaderServiceLocal;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.tibco.Tibco;
import cz.nextiraone.tmobile.wintell.tibor.TibOrException;
import cz.nextiraone.tmobile.wintell.tibor.model.ChangeSUTariff;
import cz.nextiraone.tmobile.wintell.tibor.model.CreateCaseWorkflow;
import cz.nextiraone.tmobile.wintell.tibor.model.SMServiceChanged;
import cz.nextiraone.tmobile.wintell.tibor.model.SubscriptionPropertyChange1;
import cz.nextiraone.tmobile.wintell.tibor.model.TibcoBody;
import cz.nextiraone.tmobile.wintell.tibor.model.TibcoMessage;
import cz.nextiraone.tmobile.wintell.tibor.service.TiborServiceLocal;
import cz.nextiraone.tmobile.wintell.tibor.service.TiborServiceManagement;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@Startup
@Singleton(name="wintell/TiborService")
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@Local(value={TiborServiceLocal.class})
public class TiborService
implements TiborServiceLocal,
TiborServiceManagement {
    private static final WintellLogger log = WintellLogger.getLogger(TiborService.class);
    private static final WintellActionContext systemActionContext = new WintellSystemActionContext(WintellSubprojectEnum.NONE);
    private MBeanServer platformMBeanServer;
    private ObjectName objectName = null;
    @EJB(name="wintell/loader-service")
    WintellLoaderServiceLocal ls;
    private static final String driverClass = "oracle.jdbc.driver.OracleDriver";
    private static String connectionURL = "jdbc:oracle:thin:@192.168.1.1:1521:XE";
    private static String userID = "sy_wintell";
    private static String userPassword = "sy_wintell";
    private Connection c;
    private Tibco tibco;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<Long> getMsgList(Class messageClass, WintellActionContext ctx) throws TibOrException {
        log.info(ctx, "getMsgList");
        try {
            return this.tibco.getMsgList(messageClass, ctx);
        }
        catch (TibOrException tbre) {
            if (tbre.isExceptionBecauseDbRestart()) {
                log.error(ctx, "SQL_ERROR_CODE caught: " + tbre.sqlErrorCode);
                log.info(ctx, "Reconnecting to database...");
                this.reconnectFromFile();
                return this.tibco.getMsgList(messageClass, ctx);
            }
            throw tbre;
        }
    }

    @Override
    public String vccngConvertWintell(String icaller_type, String icaller_id, String itarget_type, String itarget_id, String imodule_id, Integer imedium_id, String iinteraction_id, String iclarify_user, WintellActionContext ctx) throws TibOrException {
        log.info(ctx, "vccngConvertWintell");
        try {
            return this.tibco.vccngConvertWintell(icaller_type, icaller_id, itarget_type, itarget_id, imodule_id, imedium_id, iinteraction_id, iclarify_user, ctx);
        }
        catch (TibOrException tbre) {
            if (tbre.isExceptionBecauseDbRestart()) {
                log.error(ctx, "SQL_ERROR_CODE caught: " + tbre.sqlErrorCode);
                log.info(ctx, "Reconnecting to database...");
                this.reconnectFromFile();
                return this.tibco.vccngConvertWintell(icaller_type, icaller_id, itarget_type, itarget_id, imodule_id, imedium_id, iinteraction_id, iclarify_user, ctx);
            }
            throw tbre;
        }
    }

    @Override
    public String vccConvertBoost(String iuser, String idirectory_number, Integer iaction_id, String imedium_id, String iinteraction_id, WintellActionContext ctx) throws TibOrException {
        log.info(ctx, "vccConvertBoost");
        try {
            return this.tibco.vccConvertBoost(iuser, idirectory_number, iaction_id, imedium_id, iinteraction_id, ctx);
        }
        catch (TibOrException tbre) {
            if (tbre.isExceptionBecauseDbRestart()) {
                log.error(ctx, "SQL_ERROR_CODE caught: " + tbre.sqlErrorCode);
                log.info(ctx, "Reconnecting to database...");
                this.reconnectFromFile();
                return this.tibco.vccConvertBoost(iuser, idirectory_number, iaction_id, imedium_id, iinteraction_id, ctx);
            }
            throw tbre;
        }
    }

    @Override
    public TibcoMessage getSMServiceChanged(WintellActionContext ctx, Long itib_mhi_id) {
        log.info(ctx, "getSMSevriceChanged");
        TibcoMessage tibMsg = null;
        try {
            tibMsg = this.readMessage(SMServiceChanged.class, itib_mhi_id, ctx);
        }
        catch (NullPointerException npe) {
            log.fatal(ctx, "SMServiceChanged not read, caught NullPointerException!", (Throwable)npe);
        }
        catch (TibOrException tbre) {
            log.fatal(ctx, "SMServiceChanged not read, caught TibOrException!", (Throwable)tbre);
        }
        return tibMsg;
    }

    @Override
    public int sendSubscriptionPropertyChange1(SubscriptionPropertyChange1 m, Long businessProcessId, WintellActionContext ctx) throws TibOrException {
        return this.sendMessage(m, businessProcessId, ctx);
    }

    private void loadConfiguration() {
        try {
            connectionURL = this.ls.getValue("tibor.connectionURL");
            userID = this.ls.getValue("tibor.login");
            userPassword = this.ls.getValue("tibor.password");
        }
        catch (Exception e) {
            log.fatal(systemActionContext, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String reconnectFromFile() throws TibOrException {
        this.ls.reloadConfiguration();
        this.loadConfiguration();
        this.reconnect();
        this.checkConnection();
        return "connected\n";
    }

    public void connect() {
        try {
            if (this.c != null && !this.c.isClosed()) {
                this.c.close();
            }
            log.info(systemActionContext, "  Loading JDBC Driver  -> oracle.jdbc.driver.OracleDriver");
            Class.forName(driverClass).newInstance();
            log.info(systemActionContext, "  Connecting to        -> " + connectionURL);
            this.c = DriverManager.getConnection(connectionURL, userID, userPassword);
            log.info(systemActionContext, "  Connected as         -> " + userID);
            this.tibco = new Tibco(this.c);
        }
        catch (Throwable t) {
            log.error(systemActionContext, "Caught exception while connect(): " + t.getMessage(), t);
        }
    }

    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    public void disconnect() {
        if (this.c != null) {
            try {
                if (!this.c.isClosed()) {
                    this.c.close();
                    log.info(systemActionContext, "closing connection of tibor service");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
        this.disconnect();
    }

    @Override
    public void start() {
        this.loadConfiguration();
        this.connect();
        try {
            if (this.c == null || !this.c.isClosed()) {
                this.connect();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        log.info(systemActionContext, "stop over" + this.getClass().getSimpleName());
        this.disconnect();
    }

    @Override
    public String getTiborConnectionSettings() {
        String lineBreak = "<br />";
        StringBuffer sbf = new StringBuffer();
        sbf.append("driverClass = oracle.jdbc.driver.OracleDriver" + lineBreak);
        sbf.append("connectionURL = " + connectionURL + lineBreak);
        sbf.append("login = " + userID + lineBreak);
        sbf.append("password = " + userPassword + lineBreak + lineBreak);
        sbf.append(connectionURL + ";" + userID + ";" + userPassword);
        return sbf.toString();
    }

    @Override
    public String getConnectionUrl() {
        return connectionURL;
    }

    @Override
    public String getLogin() {
        return userID;
    }

    @Override
    public String getPassword() {
        return userPassword;
    }

    @Override
    public TibcoMessage readMessage(Class messageClass, Long itib_mhi_id, WintellActionContext ctx) throws TibOrException {
        try {
            this.checkConnection();
            return this.tibco.readMessage(messageClass, itib_mhi_id, ctx);
        }
        catch (TibOrException tbre) {
            if (tbre.isExceptionBecauseDbRestart()) {
                log.error(ctx, "SQL_ERROR_CODE caught: " + tbre.sqlErrorCode);
                log.info(ctx, "Reconnecting to database...");
                this.reconnectFromFile();
                return this.tibco.readMessage(messageClass, itib_mhi_id, ctx);
            }
            throw tbre;
        }
    }

    @Override
    public void accept(TibcoMessage m, WintellActionContext ctx) throws TibOrException {
        try {
            this.checkConnection();
            this.tibco.accept(m, ctx);
        }
        catch (TibOrException tbre) {
            if (tbre.isExceptionBecauseDbRestart()) {
                log.error(ctx, "SQL_ERROR_CODE caught: " + tbre.sqlErrorCode);
                log.info(ctx, "Reconnecting to database...");
                this.reconnectFromFile();
                this.tibco.accept(m, ctx);
            }
            throw tbre;
        }
    }

    @Override
    public void reject(TibcoMessage m, Integer iapp_err_code, String iapp_err_msg, WintellActionContext ctx) throws TibOrException {
        try {
            this.checkConnection();
            this.tibco.reject(m, iapp_err_code, iapp_err_msg, ctx);
        }
        catch (TibOrException tbre) {
            if (tbre.isExceptionBecauseDbRestart()) {
                log.error(ctx, "SQL_ERROR_CODE caught: " + tbre.sqlErrorCode);
                log.info(ctx, "Reconnecting to database...");
                this.reconnectFromFile();
                this.tibco.reject(m, iapp_err_code, iapp_err_msg, ctx);
            }
            throw tbre;
        }
    }

    @Override
    public int sendMessage(TibcoBody b, Long businessProcessId, WintellActionContext ctx) throws TibOrException {
        try {
            this.checkConnection();
            return this.tibco.sendMessage(b, businessProcessId, ctx);
        }
        catch (TibOrException tbre) {
            if (tbre.isExceptionBecauseDbRestart()) {
                log.error(ctx, "SQL_ERROR_CODE caught: " + tbre.sqlErrorCode);
                log.info(ctx, "Reconnecting to database...");
                this.reconnectFromFile();
                return this.tibco.sendMessage(b, businessProcessId, ctx);
            }
            throw tbre;
        }
    }

    @Override
    public int sendMessageRaw(String msgName, Map<String, String> body, Long businessProcessId, WintellActionContext ctx) throws TibOrException {
        try {
            this.checkConnection();
            return this.tibco.sendMessageRaw(msgName, body, businessProcessId, ctx);
        }
        catch (TibOrException tbre) {
            if (tbre.isExceptionBecauseDbRestart()) {
                log.error(ctx, "SQL_ERROR_CODE caught: " + tbre.sqlErrorCode);
                log.info(ctx, "Reconnecting to database...");
                this.reconnectFromFile();
                return this.tibco.sendMessageRaw(msgName, body, businessProcessId, ctx);
            }
            throw tbre;
        }
    }

    @Override
    public int getTibMessagesCount(WintellActionContext ctx) throws TibOrException {
        try {
            this.checkConnection();
            return this.tibco.getTibMessagesCount(SMServiceChanged.class, ctx);
        }
        catch (TibOrException tbre) {
            if (tbre.isExceptionBecauseDbRestart()) {
                log.error(ctx, "SQL_ERROR_CODE caught: " + tbre.sqlErrorCode);
                log.info(ctx, "Reconnecting to database...");
                this.reconnectFromFile();
                return this.tibco.getTibMessagesCount(SMServiceChanged.class, ctx);
            }
            throw tbre;
        }
    }

    private void checkConnection() throws TibOrException {
        if (this.tibco == null) {
            this.connect();
            if (this.tibco == null) {
                throw new TibOrException("cannot reconnect", 17002);
            }
        }
    }

    @Override
    public void test() throws Throwable {
        CreateCaseWorkflow cc = new CreateCaseWorkflow();
        cc.setUSER_NAME("WINTELL");
        cc.setQUEUE("ACT");
        cc.setASSIGN_OWNER_NAME("AssignOwnerName");
        cc.setTEXT("Test text of test CreateCase");
        cc.setMSISDN("420739529012");
        cc.setMEDIA("Phone");
        cc.setPRIORITY("Urgent");
        cc.setSTATUS("V reseni");
        cc.setCASE_TYPE("CASE_TEST");
        cc.setTIB_SEND_DATIM(new Date());
        cc.setPROCESS("268437758");
        cc.setSUBJECT("805310013");
        cc.setSUBSUBJECT("805310016");
        cc.setSTEP("805310017");
        log.info(systemActionContext, "sending CreateCase to TibOr");
        this.sendMessage(cc, new Long(61000000000000L), systemActionContext);
        log.info(systemActionContext, "sending CreateCase to TibOr DONE");
    }

    @Override
    public void test2() throws Throwable {
        log.info(systemActionContext, "requesting read of SMServiceChanged TibOr event");
        TibcoMessage tmsg = this.getSMServiceChanged(systemActionContext);
        log.info(systemActionContext, "message received [" + tmsg.toString() + "]");
    }

    @Override
    public void test3() throws Throwable {
        log.info(systemActionContext, "test send subscriptionPropertyChange");
        SubscriptionPropertyChange1 ms = new SubscriptionPropertyChange1();
        ms.setACTION("a");
        ms.setCS_TYPE(4);
        ms.setEXTID_CS(12);
        ms.setINTERACTION_ID("INTERACTION_ID14");
        ms.setMEDIUM(1);
        ms.setPROPERTY_ID(15);
        ms.setTIB_PROCESS_ID("TIB_PROCESS_ID16");
        ms.setTIB_ROUTING_KEY("tib_routing_key");
        ms.setTIB_SEND_DATIM(new Date());
        ms.setTRX_CONTROL(17);
        ms.setUSERNAME("WINTELL");
        log.info(systemActionContext, "sending CreateCase to TibOr");
        log.info(systemActionContext, "start sending");
        this.sendSubscriptionPropertyChange1(ms, new Long(61000000000000L), systemActionContext);
        log.info(systemActionContext, "test sendSubscriptionPropertyChange1 end");
    }

    @Override
    public void testSuTarif() throws Throwable {
        log.info(systemActionContext, "test sending SUTarif");
        ChangeSUTariff sut = new ChangeSUTariff();
        sut.setEXTID_SU(234);
        sut.setOUTLET("20865");
        sut.setSUBS_TARIFF("144");
        sut.setTIB_PROCESS_ID("TIB_PROCESS_ID16");
        sut.setTIB_ROUTING_KEY("tib_routing_key");
        sut.setTIB_SEND_DATIM(new Date());
        sut.setUSERNAME("WINTELL");
        sut.setVALID_FROM(new Date());
        log.info(systemActionContext, "sending SUTarif finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidOracleConnection(Connection conn) {
        try {
            if (conn == null) {
                return false;
            }
            if (conn.isClosed()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        ResultSet rs = null;
        Statement stmt = null;
        String query = "SELECT 1 FROM DUAL";
        try {
            stmt = conn.createStatement();
            if (stmt == null) {
                boolean bl = false;
                return bl;
            }
            rs = stmt.executeQuery(query);
            if (rs == null) {
                boolean bl = false;
                return bl;
            }
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
                stmt.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public String testConnection() {
        return this.isValidOracleConnection(this.c) ? "OK" : "Broken";
    }

    @Override
    public TibcoMessage getSMServiceChanged(WintellActionContext ctx) {
        return this.getSMServiceChanged(ctx, null);
    }

    @PostConstruct
    public void registerInJMX() {
        try {
            this.objectName = new ObjectName("wintell:service=TiborService");
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.platformMBeanServer.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during registration of Monitoring into JMX:" + e);
        }
        this.create();
        this.start();
    }

    @PreDestroy
    public void unregisterFromJMX() {
        try {
            this.platformMBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during unregistration of Monitoring into JMX:" + e);
        }
        this.stop();
    }
}

