/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.utils.auth;

import cz.ryant.alfresco.utils.configurator.Configuration;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedEvent;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedListener;
import cz.ryant.alfresco.utils.watcher.FileModificationEvent;
import cz.ryant.alfresco.utils.watcher.FileModificationListener;
import cz.ryant.alfresco.utils.watcher.FileWatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmLdapLoginResolver
implements FileModificationListener,
ConfigurationChangedListener {
    private static final Logger log = LoggerFactory.getLogger(NtlmLdapLoginResolver.class);
    private static final String NTLM_LDAP_LOGIN_IS_ACTIVE = "ntlm-ldap-login.is.active";
    private static final String NTLM_LDAP_LOGIN_MAPPING_FILE = "ntlm-ldap-login.mapping.file";
    private String mappingFilePath;
    private FileWatcher fileWatcher;
    private final Pattern linePattern;
    private Map<Pattern, String> mapping;
    private volatile boolean enabled;
    private Configuration configuration;
    private Map<String, String> mappingCache;

    public NtlmLdapLoginResolver(Configuration configuration) {
        assert (configuration != null) : "configuration must not be null";
        this.mapping = new LinkedHashMap<Pattern, String>();
        this.linePattern = Pattern.compile("([^\\s]*)\\s*([^\\s]*)");
        this.mappingCache = new LinkedHashMap<String, String>();
        this.configuration = configuration;
        this.configuration.addListener(this);
        this.processConfiguration(configuration.getProperties());
    }

    public synchronized void enable(String filePath) {
        if (filePath == null) {
            log.warn("mapping file is not specified -> disabling");
            return;
        }
        File file = new File(filePath);
        this.enable(file.getParentFile(), file.getName());
    }

    public synchronized void enable(File folder, String fileName) {
        if (this.fileWatcher != null) {
            this.fileWatcher.dispose();
        }
        this.mapping = new LinkedHashMap<Pattern, String>();
        this.fileWatcher = new FileWatcher(folder, 15000);
        this.fileWatcher.addListener(this);
        File mappingFile = new File(folder, fileName);
        this.mappingFilePath = mappingFile.getAbsolutePath();
        this.readMappingFile(mappingFile);
        if (this.enabled) {
            log.debug("resolver has been enabled ('{}')", (Object)this.mappingFilePath);
        } else {
            log.debug("resolver is disabled");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void disable() {
        this.enabled = false;
        if (this.fileWatcher != null) {
            this.fileWatcher.dispose();
        }
        this.clearCahce();
        this.mapping.clear();
        log.debug("resolver has been disabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMappedLogin(String login) {
        NtlmLdapLoginResolver ntlmLdapLoginResolver = this;
        synchronized (ntlmLdapLoginResolver) {
            if (this.mappingCache.containsKey(login)) {
                if (log.isTraceEnabled()) {
                    log.trace("found cached login mapping '{}' -> '{}'", (Object)login, (Object)this.mappingCache.get(login));
                }
                return this.mappingCache.get(login);
            }
        }
        for (Map.Entry<Pattern, String> entry : this.mapping.entrySet()) {
            try {
                Matcher m = entry.getKey().matcher(login);
                boolean found = m.find();
                boolean matched = m.matches();
                if (!found || !matched) continue;
                String mappedLogin = m.replaceAll(entry.getValue());
                if (log.isTraceEnabled()) {
                    log.trace("found login mapping '{}' -> '{}'", (Object)login, (Object)mappedLogin);
                }
                this.addIntoCache(login, mappedLogin);
                return mappedLogin;
            }
            catch (Exception e) {
                String msg = String.format("cannot match login '%1$s' ('%2$s' -> %3$s", login, entry.getKey(), entry.getValue());
                log.warn(msg, (Throwable)e);
            }
        }
        this.addIntoCache(login, login);
        if (log.isTraceEnabled()) {
            log.trace("no mapped login found for user '{}'", (Object)login);
        }
        return login;
    }

    @Override
    public void handleFileModification(FileModificationEvent e) {
        String filePath = e.getFile().getAbsolutePath();
        if (!filePath.equals(this.mappingFilePath)) {
            return;
        }
        log.debug("file '{}' has been modified: {}", (Object)filePath, (Object)e.getOperation());
        this.readMappingFile(e.getFile());
    }

    @Override
    public void handleConfigurationChange(ConfigurationChangedEvent e) {
        this.processConfiguration(e.getProperties());
    }

    private void processConfiguration(Properties props) {
        if (props == null) {
            this.disable();
            return;
        }
        boolean isActive = Boolean.parseBoolean(props.getProperty(NTLM_LDAP_LOGIN_IS_ACTIVE, "false"));
        if (!isActive) {
            this.disable();
            return;
        }
        String mappingFile = props.getProperty(NTLM_LDAP_LOGIN_MAPPING_FILE, null);
        this.enable(mappingFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void readMappingFile(File mappingFile) {
        this.clearCahce();
        if (mappingFile == null || !mappingFile.exists()) {
            log.warn("mapping file does not exist");
            this.enabled = false;
            return;
        }
        BufferedReader br = null;
        String filePath = mappingFile.getAbsolutePath();
        log.trace("reading mapping file '{}'", (Object)filePath);
        LinkedHashMap<Pattern, String> newMapping = new LinkedHashMap<Pattern, String>();
        try {
            String line;
            br = new BufferedReader(new FileReader(mappingFile));
            int lineCounter = 0;
            while ((line = br.readLine()) != null) {
                ++lineCounter;
                if ((line = line.trim()).startsWith("#")) continue;
                Matcher m = this.linePattern.matcher(line);
                if (!m.find() || m.groupCount() != 2) {
                    log.warn("bad line {} in '{}' file -> ignoring line mappings", (Object)lineCounter, (Object)filePath);
                    continue;
                }
                try {
                    Pattern pattern = Pattern.compile(m.group(1));
                    newMapping.put(pattern, m.group(2));
                    if (!log.isTraceEnabled()) continue;
                    log.trace("\t{} -> {}", (Object)m.group(1), (Object)m.group(2));
                }
                catch (PatternSyntaxException e) {
                    log.warn("incorrect regexp pattern in '{}' file, line {} -> ignoring line mappings", (Object)filePath, (Object)lineCounter);
                }
            }
            this.enabled = true;
            log.trace("mapping file '{}' successfully read", (Object)filePath);
        }
        catch (Exception e) {
            try {
                String msg = String.format("cannot read mapping file '%1$s'", filePath);
                log.error(msg, (Throwable)e);
                newMapping.clear();
                this.enabled = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                this.mapping.clear();
                this.mapping = newMapping;
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)br);
            this.mapping.clear();
            this.mapping = newMapping;
        }
        IOUtils.closeQuietly((Reader)br);
        this.mapping.clear();
        this.mapping = newMapping;
    }

    private void clearCahce() {
        Map<String, String> _old = this.mappingCache;
        this.mappingCache = new LinkedHashMap<String, String>();
        _old.clear();
    }

    private synchronized void addIntoCache(String originalLogin, String newLogin) {
        this.mappingCache.put(originalLogin, newLogin);
    }
}

