/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.utils.configurator;

import cz.ryant.alfresco.utils.PropertiesReader;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedEvent;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedListener;
import cz.ryant.alfresco.utils.watcher.FileModificationEvent;
import cz.ryant.alfresco.utils.watcher.FileModificationListener;
import cz.ryant.alfresco.utils.watcher.FileWatcher;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements FileModificationListener {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private String cfgFilePath;
    private FileWatcher fileWatcher;
    private List<ConfigurationChangedListener> listeners = new ArrayList<ConfigurationChangedListener>();
    private Properties properties;

    public Configuration(String cfgFileName) {
        this.cfgFilePath = new File(Configuration.getSharedClassesFolder(), cfgFileName).getAbsolutePath();
        this.fileWatcher = new FileWatcher(Configuration.getSharedClassesFolder(), 15000);
        this.fileWatcher.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFileModification(FileModificationEvent e) {
        Configuration configuration = this;
        synchronized (configuration) {
            if (!e.getFile().getAbsolutePath().equals(this.cfgFilePath)) {
                return;
            }
            log.debug("cfg file '{}' has been changed -> reloading properties", (Object)this.cfgFilePath);
            this.properties = Configuration.getProperties(e.getFile());
        }
        ConfigurationChangedEvent event = new ConfigurationChangedEvent(this, this.properties);
        for (ConfigurationChangedListener listener : this.listeners) {
            listener.handleConfigurationChange(event);
        }
    }

    public synchronized void addListener(ConfigurationChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeListener(ConfigurationChangedListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void removeAllListeners() {
        List<ConfigurationChangedListener> _tmp = this.listeners;
        this.listeners = new ArrayList<ConfigurationChangedListener>();
        _tmp.clear();
    }

    public synchronized Properties getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        if (this.cfgFilePath == null) {
            log.debug("cfg file name is not specified");
            return null;
        }
        File file = new File(this.cfgFilePath);
        if (!file.exists()) {
            log.warn("cfg file '{}' not exists", (Object)this.cfgFilePath);
            return null;
        }
        log.debug("getting properties from cfg file '{}'", (Object)this.cfgFilePath);
        this.properties = Configuration.getProperties(file);
        return this.properties;
    }

    private static Properties getProperties(File propFile) {
        Properties props = PropertiesReader.loadProperties(propFile);
        if (log.isInfoEnabled()) {
            if (props != null) {
                StringBuffer sb = new StringBuffer();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    sb.append("\t");
                    sb.append(entry.getKey());
                    sb.append(":\t");
                    sb.append(entry.getValue());
                    sb.append("\n");
                }
                log.info("got new properties from cfg file '{}':\n{}", (Object)propFile.getAbsolutePath(), (Object)sb.toString());
            }
        } else {
            log.info("cannot get properties from cfg file '{}'", (Object)propFile.getAbsolutePath());
        }
        return props;
    }

    private static File getSharedClassesFolder() {
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaBase == null || "".equals(catalinaBase)) {
            log.error("catalina.base is not defined!");
            return null;
        }
        Path sharedClassesPath = Paths.get(catalinaBase, "shared", "classes");
        File sharedClassesFolder = sharedClassesPath.toFile();
        if (!sharedClassesFolder.exists()) {
            log.error("'{}' path does not exist!", (Object)sharedClassesPath);
            return null;
        }
        return sharedClassesFolder;
    }
}

