/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.utils.watcher;

import cz.ryant.alfresco.utils.watcher.FileModificationEvent;
import cz.ryant.alfresco.utils.watcher.FileModificationListener;
import cz.ryant.alfresco.utils.watcher.FileOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher {
    private static final Logger log = LoggerFactory.getLogger(FileWatcher.class);
    private List<FileModificationListener> listeners = new ArrayList<FileModificationListener>();
    private FileAlterationObserver fileObserver;
    private FileAlterationMonitor fileMonitor;
    private File monitoredFile;
    private int pollingInterval = 15000;

    public FileWatcher() {
    }

    public FileWatcher(File monitoredFile, int pollingInterval) {
        this();
        this.pollingInterval = pollingInterval;
        this.monitoredFile = monitoredFile;
        this.startWatching();
    }

    public synchronized void addListener(FileModificationListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(FileModificationListener listener) {
        this.listeners.remove(this.listeners);
    }

    public void setMonitoredFile(File file) {
        this.stopWatching();
        if (file == null) {
            log.warn("cannot monitor file - no file specified");
            return;
        }
        this.monitoredFile = file;
        this.startWatching();
    }

    public File getMonitoredFile() {
        return this.monitoredFile;
    }

    public void setPollingInterval(int interval) {
        this.pollingInterval = interval;
        this.setMonitoredFile(this.monitoredFile);
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public void dispose() {
        this.stopWatching();
    }

    private synchronized void fireEvent(File file, FileOperation operation) {
        FileModificationEvent event = new FileModificationEvent(this, file, operation);
        for (FileModificationListener listener : this.listeners) {
            listener.handleFileModification(event);
        }
    }

    private synchronized void startWatching() {
        if (this.monitoredFile == null) {
            log.warn("cannot start monitoring folder - no folder specified");
            return;
        }
        this.fileObserver = new FileAlterationObserver(this.monitoredFile);
        this.fileMonitor = new FileAlterationMonitor((long)this.pollingInterval);
        FileAlterationListenerAdaptor fileListener = new FileAlterationListenerAdaptor(){

            public void onFileCreate(File file) {
                FileWatcher.this.fireEvent(file, FileOperation.CREATED);
            }

            public void onFileChange(File file) {
                FileWatcher.this.fireEvent(file, FileOperation.MODIFIED);
            }

            public void onFileDelete(File file) {
                FileWatcher.this.fireEvent(file, FileOperation.DELETED);
            }
        };
        this.fileObserver.addListener((FileAlterationListener)fileListener);
        this.fileMonitor.addObserver(this.fileObserver);
        try {
            this.fileMonitor.start();
            log.debug("folder monitoring '{}' started", (Object)this.monitoredFile.getAbsolutePath());
        }
        catch (Exception e) {
            String msg = String.format("cannot start observing file '%1$s'", this.monitoredFile);
            log.error(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stopWatching() {
        this.removeAllListeners();
        try {
            if (this.fileObserver != null) {
                this.fileObserver.destroy();
                log.debug("file observer destroyed");
            }
        }
        catch (Exception e) {
            log.warn("cannot destroy file observer");
        }
        finally {
            this.fileObserver = null;
        }
        try {
            if (this.fileMonitor != null) {
                this.fileMonitor.stop();
            }
        }
        catch (Exception e) {
            log.warn("cannot stop monitoring file", (Throwable)e);
        }
        finally {
            this.fileMonitor = null;
        }
        log.debug("file watching has been stopped '{}'", (Object)(this.monitoredFile != null ? this.monitoredFile.getAbsolutePath() : "n/a"));
    }

    private void removeAllListeners() {
        this.listeners.clear();
    }
}

