/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.auth.repo;

import cz.ryant.alfresco.utils.auth.NtlmLdapLoginResolver;
import cz.ryant.alfresco.utils.configurator.Configuration;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedEvent;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedListener;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Properties;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.User;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import net.sf.acegisecurity.providers.encoding.PasswordEncoder;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantContextHolder;
import org.alfresco.repo.tenant.TenantDisabledException;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationComponentImpl
extends org.alfresco.repo.security.authentication.AuthenticationComponentImpl
implements ConfigurationChangedListener {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationComponentImpl.class);
    protected NtlmLdapLoginResolver loginResolver;
    protected boolean authenticateAlfrescoUsers = true;
    protected PasswordEncoder passwordEncoder;
    protected AuthenticationManager authenticationManager;
    private Configuration configuration;

    public void setLoginResolver(NtlmLdapLoginResolver loginResolver) {
        assert (loginResolver != null) : "loginResolver status must not be null";
        this.loginResolver = loginResolver;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        if (this.configuration != null) {
            this.configuration.addListener((ConfigurationChangedListener)this);
            this.processConfiguration(this.configuration.getProperties());
        }
    }

    protected UserDetails getUserDetails(String userName) {
        try {
            return super.getUserDetails(userName);
        }
        catch (UsernameNotFoundException unfe) {
            GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
            User userDetails = new User(userName, "", true, true, true, true, gas);
            return userDetails;
        }
    }

    public String getMD4HashedPassword(String userName) {
        String md4;
        if (log.isTraceEnabled()) {
            log.trace("getting MD4 hashed password for '{}'", (Object)userName);
        }
        String mappedUserName = this.getMappedUserName(userName);
        if (this.authenticateAlfrescoUsers && (md4 = super.getMD4HashedPassword(mappedUserName)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("got MD4 hashed password by parent method (user={}, md4={})", new Object[]{mappedUserName, md4});
            }
            return md4;
        }
        String md4HashedPassword = this.getMD4HashedPasswordFromPerson(mappedUserName);
        if (log.isTraceEnabled()) {
            log.trace("got MD4 hashed password for mapped user (mappedUser={}, md4={})", new Object[]{mappedUserName, md4HashedPassword});
        }
        return md4HashedPassword;
    }

    private String getMappedUserName(String userName) {
        String mappedUserName = this.loginResolver.getMappedLogin(userName);
        if (log.isTraceEnabled()) {
            log.trace("got mapped user '{}' -> '{}'", new Object[]{userName, mappedUserName});
        }
        return mappedUserName;
    }

    private String getMD4HashedPasswordFromPerson(String userName) {
        NodeRef userNodeRef = this.getPersonService().getPersonOrNull(userName);
        if (userNodeRef == null) {
            return null;
        }
        QName qn = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"md4HashedPassword");
        Serializable serializable = this.getNodeService().getProperty(userNodeRef, qn);
        if (serializable instanceof String) {
            return (String)((Object)serializable);
        }
        return null;
    }

    protected void authenticateImpl(String userNameIn, final char[] password) throws org.alfresco.repo.security.authentication.AuthenticationException {
        try {
            Pair userTenant = AuthenticationUtil.getUserTenant((String)userNameIn);
            final String userName = (String)userTenant.getFirst();
            final String tenantDomain = (String)userTenant.getSecond();
            String normalized = (String)this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                public String execute() throws Throwable {
                    return (String)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<String>(){

                        public String doWork() throws Exception {
                            if (AuthenticationComponentImpl.this.authenticateAlfrescoUsers) {
                                try {
                                    String normalized = AuthenticationComponentImpl.this.getPersonService().getUserIdentifier(userName);
                                    UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)(normalized == null ? userName : normalized), (Object)new String(password));
                                    AuthenticationComponentImpl.this.authenticationManager.authenticate((Authentication)authentication);
                                    return normalized;
                                }
                                catch (BadCredentialsException bce) {
                                    return AuthenticationComponentImpl.this.authenticateMappedUser(userName, new String(password));
                                }
                            }
                            return AuthenticationComponentImpl.this.authenticateMappedUser(userName, new String(password));
                        }
                    }, (String)tenantDomain);
                }
            }, true);
            if (normalized == null) {
                this.setCurrentUser(userName, AuthenticationComponent.UserNameValidationMode.CHECK_AND_FIX);
            } else {
                this.setCurrentUser(normalized, AuthenticationComponent.UserNameValidationMode.NONE);
            }
            TenantContextHolder.setTenantDomain((String)tenantDomain);
        }
        catch (TenantDisabledException tde) {
            throw new org.alfresco.repo.security.authentication.AuthenticationException(tde.getMessage(), (Throwable)tde);
        }
        catch (AuthenticationException ae) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            out.println(ae.toString());
            ae.printStackTrace(out);
            out.close();
            throw new org.alfresco.repo.security.authentication.AuthenticationException(sw.toString());
        }
    }

    private String authenticateMappedUser(String userName, String password) {
        String mappedUserName = this.getMappedUserName(userName);
        String md4Hash = this.getMD4HashedPassword(userName);
        String encodedPwd = this.passwordEncoder.encodePassword(password, null);
        if (encodedPwd.equalsIgnoreCase(md4Hash)) {
            log.debug("user '{}' has been authenticated and mapped to '{}'", new Object[]{userName, mappedUserName});
            return mappedUserName;
        }
        throw new BadCredentialsException(String.format("Cannot authentiate user '%1$s' - bad user name mapping (%2$s) or password hash (%3$s != %4$s)", userName, mappedUserName, md4Hash, encodedPwd));
    }

    public void handleConfigurationChange(ConfigurationChangedEvent e) {
        this.processConfiguration(e.getProperties());
    }

    private void processConfiguration(Properties properties) {
        this.authenticateAlfrescoUsers = Boolean.parseBoolean(properties.getProperty("ntlmAuthComponent.auth.alfresco.users", "true"));
        log.info("New properties:\n\tauthenticateAlfrescoUsers\t{}", new Object[]{this.authenticateAlfrescoUsers});
    }
}

