/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.auth.repo.webdav;

import cz.ryant.alfresco.auth.repo.webdav.NtlmLogonDetailsCache;
import cz.ryant.alfresco.auth.repo.webdav.NtlmLogonDetailsWrapper;
import cz.ryant.alfresco.utils.auth.NtlmLdapLoginResolver;
import cz.ryant.alfresco.utils.configurator.Configuration;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedEvent;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.BadCredentialsException;
import org.alfresco.jlan.server.auth.ntlm.NTLMLogonDetails;
import org.alfresco.jlan.server.auth.ntlm.NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.TargetInfo;
import org.alfresco.jlan.server.auth.ntlm.Type1NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type2NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type3NTLMMessage;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;
import org.alfresco.repo.security.authentication.ntlm.NTLMPassthruToken;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.auth.BasicAuthCredentials;
import org.alfresco.repo.web.auth.GuestCredentials;
import org.alfresco.repo.web.auth.NTLMCredentials;
import org.alfresco.repo.web.auth.TicketCredentials;
import org.alfresco.repo.web.auth.UnknownCredentials;
import org.alfresco.repo.web.auth.WebCredentials;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTLMAuthenticationFilter
extends org.alfresco.repo.webdav.auth.NTLMAuthenticationFilter
implements ConfigurationChangedListener {
    private static final Logger log = LoggerFactory.getLogger(NTLMAuthenticationFilter.class);
    protected static final String AUTH_BASIC = "BASIC";
    protected static final String NTLM_AUTH_LOGON_DETAILS = "_alfNTLMLogonDetails";
    protected boolean allowBasicAuthentication;
    protected Pattern excludeNtlmAuthUserAgentPattern;
    protected Pattern excludeBasicAuthUserAgentPattern;
    protected boolean allowNtlmDetailsStore;
    protected int ntlmDetailsStoreExpirationTaskPeriod;
    protected int ntlmDetailsStoreItemDuration;
    protected int ntlmDetailsSessionContextDuration;
    private Configuration configuration;
    protected NtlmLdapLoginResolver loginResolver;
    private Object ntlmLogonDetailsSyncObj = new Object();
    private NtlmLogonDetailsCache ntlmLogonDetailsCache;
    private NLTMAuthenticator nltmAuthenticator;
    private boolean m_allowGuest = false;
    private boolean m_mapUnknownUserToGuest = false;
    private Random m_random = new Random(System.currentTimeMillis());
    private int m_ntlmFlags;
    private boolean m_disableNTLMv2 = false;
    private static final int NTLM_FLAGS_NTLM2 = -1610087807;
    private static final int NTLM_FLAGS_NTLM1 = -2147483005;
    private static final String[] ENCODINGS = new String[]{"UTF-8", System.getProperty("file.encoding"), "ISO-8859-1"};
    private static final CharsetDecoder[] DECODERS;

    protected void init() throws ServletException {
        super.init();
        this.ntlmLogonDetailsCache = new NtlmLogonDetailsCache(this.ntlmDetailsStoreExpirationTaskPeriod, this.ntlmDetailsStoreItemDuration){

            @Override
            public WebCredentials getWebCredentials(Type3NTLMMessage type3Msg, String md4hash, NTLMLogonDetails ntlmDetails) {
                return NTLMAuthenticationFilter.this.authenticate(type3Msg, md4hash, ntlmDetails);
            }
        };
        this.nltmAuthenticator = (NLTMAuthenticator)this.authenticationComponent;
        this.m_allowGuest = this.authenticationComponent.guestUserAuthenticationAllowed();
        this.m_ntlmFlags = this.nltmAuthenticator.getNTLMMode() == NTLMMode.MD4_PROVIDER && !this.m_disableNTLMv2 ? -1610087807 : -2147483005;
    }

    public void setMapUnknownUserToGuest(boolean mapUnknownUserToGuest) {
        super.setMapUnknownUserToGuest(mapUnknownUserToGuest);
        this.m_mapUnknownUserToGuest = mapUnknownUserToGuest;
    }

    public void setLoginResolver(NtlmLdapLoginResolver loginResolver) {
        assert (loginResolver != null) : "loginResolver status must not be null";
        this.loginResolver = loginResolver;
    }

    public boolean authenticateRequest(ServletContext context, HttpServletRequest sreq, HttpServletResponse sresp) throws IOException, ServletException {
        String authHdr = sreq.getHeader("Authorization");
        AuthMethod authMethod = AuthMethod.NONE;
        String userAgent = sreq.getHeader("user-agent");
        if (authHdr != null) {
            if (authHdr.startsWith("NTLM")) {
                authMethod = AuthMethod.NTLM;
            } else if (authHdr.length() > 5 && authHdr.substring(0, 5).equalsIgnoreCase(AUTH_BASIC)) {
                authMethod = AuthMethod.BASIC;
            } else if (authHdr.startsWith("Negotiate")) {
                log.debug("Received 'Negotiate' from client, may be SPNEGO/Kerberos logon");
                this.restartLoginChallenge(context, sreq, sresp);
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("authenticateRequest (method={}, uri={}, authMethod={}, userAgent={})", new Object[]{sreq.getMethod(), sreq.getRequestURI(), authMethod, userAgent});
        }
        if (!this.allowBasicAuthentication) {
            return super.authenticateRequest(context, sreq, sresp);
        }
        SessionUser user = this.getSessionUser(context, sreq, sresp, true);
        if (user != null && authMethod == AuthMethod.NONE) {
            this.onValidate(context, sreq, sresp, (WebCredentials)new TicketCredentials(user.getTicket()));
            if (log.isDebugEnabled()) {
                log.debug("Authentication not required (user={}), chaining ...", (Object)user.getUserName());
            }
            return true;
        }
        if (this.hasLoginPage() && sreq.getRequestURI().endsWith(this.getLoginPage())) {
            log.debug("Login page requested, chaining ...");
            return true;
        }
        if (userAgent != null && userAgent.indexOf("Opera ") != -1) {
            log.debug("Opera detected, redirecting to login page");
            if (this.hasLoginPage()) {
                this.redirectToLoginPage(sreq, sresp);
            } else {
                this.restartLoginChallenge(context, sreq, sresp);
            }
            return false;
        }
        if (authHdr == null) {
            if (this.allowsTicketLogons() && this.checkForTicketParameter(context, sreq, sresp)) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("New NTLM auth request from {} ({}:{}) SID:{}", new Object[]{sreq.getRemoteHost(), sreq.getRemoteAddr(), sreq.getRemotePort(), sreq.getSession().getId()});
            }
            if (!NTLMAuthenticationFilter.match(this.excludeNtlmAuthUserAgentPattern, userAgent)) {
                sresp.setHeader("WWW-Authenticate", "NTLM");
                log.trace("authenticateRequest - offerring NTLM authentication");
            }
            if (!NTLMAuthenticationFilter.match(this.excludeBasicAuthUserAgentPattern, userAgent)) {
                String basicAuthHeaderValue = String.format("%1$s realm=\"Alfresco DAV Server\"", AUTH_BASIC);
                sresp.addHeader("WWW-Authenticate", basicAuthHeaderValue);
                log.trace("authenticateRequest - offerring BASIC authentication");
            }
            sresp.setStatus(401);
            this.writeLoginPageLink(context, sreq, sresp);
            sresp.flushBuffer();
            return false;
        }
        if (authMethod == AuthMethod.BASIC) {
            boolean result = this.processBasicAuth(sreq, sresp);
            if (!result) {
                this.restartLoginChallenge(context, sreq, sresp);
            }
            return result;
        }
        byte[] ntlmByts = Base64.decodeBase64((byte[])authHdr.substring(5).getBytes());
        int ntlmTyp = NTLMMessage.isNTLMType((byte[])ntlmByts);
        if (ntlmTyp == 1) {
            Type1NTLMMessage type1Msg = new Type1NTLMMessage(ntlmByts);
            this.processType1(type1Msg, sreq, sresp);
            return false;
        }
        if (ntlmTyp == 3) {
            Type3NTLMMessage type3Msg = new Type3NTLMMessage(ntlmByts);
            return this.processType3(type3Msg, context, sreq, sresp);
        }
        log.debug("NTLM blob not handled, redirecting to login page.");
        if (this.hasLoginPage()) {
            this.redirectToLoginPage(sreq, sresp);
        } else {
            this.restartLoginChallenge(context, sreq, sresp);
        }
        return false;
    }

    protected boolean processBasicAuth(HttpServletRequest httpReq, HttpServletResponse httpResp) throws ServletException, IOException {
        log.debug("Basic authentication details present in the header.");
        String authHdr = httpReq.getHeader("Authorization");
        byte[] encodedString = Base64.decodeBase64((byte[])authHdr.substring(5).getBytes());
        HashSet<String> attemptedAuths = new HashSet<String>(DECODERS.length * 2);
        for (CharsetDecoder decoder : DECODERS) {
            try {
                String basicAuth = decoder.decode(ByteBuffer.wrap(encodedString)).toString();
                if (!attemptedAuths.add(basicAuth)) continue;
                String username = null;
                String password = null;
                int pos = basicAuth.indexOf(":");
                if (pos != -1) {
                    username = basicAuth.substring(0, pos);
                    password = basicAuth.substring(pos + 1);
                } else {
                    username = basicAuth;
                    password = "";
                }
                this.authenticationService.authenticate(username, password.toCharArray());
                this.authenticationListener.userAuthenticated((WebCredentials)new BasicAuthCredentials(username, password));
                SessionUser user = this.createUserEnvironment(httpReq.getSession(), this.authenticationService.getCurrentUserName(), this.authenticationService.getCurrentTicket(), false);
                if (user == null) {
                    log.debug("No user/ticket, force the client to prompt for logon details.");
                    httpResp.setHeader("WWW-Authenticate", "BASIC realm=\"Alfresco DAV Server\"");
                    httpResp.setStatus(401);
                    httpResp.flushBuffer();
                    return false;
                }
                log.debug("User has been successfully authenticated by BASIC auth mechanism (user={})", (Object)user);
                return true;
            }
            catch (CharacterCodingException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("Didn't decode using %1$s", decoder.getClass().getName()), (Throwable)e);
            }
            catch (AuthenticationException ex) {
                log.debug("Authentication error ", (Throwable)ex);
            }
            catch (NoSuchPersonException e) {
                log.debug("There is no such person error ", (Throwable)e);
            }
        }
        return false;
    }

    private static boolean match(Pattern pattern, String str) {
        if (pattern == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(str);
        boolean matches = matcher.matches();
        return matches;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        if (this.configuration != null) {
            this.configuration.addListener((ConfigurationChangedListener)this);
            this.processConfiguration(this.configuration.getProperties());
        }
    }

    public void handleConfigurationChange(ConfigurationChangedEvent e) {
        this.processConfiguration(e.getProperties());
    }

    private void processConfiguration(Properties properties) {
        this.allowBasicAuthentication = Boolean.parseBoolean(properties.getProperty("ntlmAuthFilter.allow.Basic", "false"));
        String basicPattern = properties.getProperty("ntlmAuthFilter.exclude.Basic.user-agent", null);
        this.excludeBasicAuthUserAgentPattern = null;
        if (!StringUtils.isEmpty((String)basicPattern)) {
            try {
                this.excludeBasicAuthUserAgentPattern = Pattern.compile(basicPattern);
            }
            catch (Exception e) {
                log.warn(String.format("cannot create exlude user agent pattern for BASIC authentication (pattern=%1$s)", basicPattern), (Throwable)e);
                this.excludeBasicAuthUserAgentPattern = null;
            }
        }
        String ntlmPattern = properties.getProperty("ntlmAuthFilter.exclude.Ntlm.user-agent", null);
        this.excludeNtlmAuthUserAgentPattern = null;
        if (!StringUtils.isEmpty((String)ntlmPattern)) {
            try {
                this.excludeNtlmAuthUserAgentPattern = Pattern.compile(ntlmPattern);
            }
            catch (Exception e) {
                log.warn(String.format("cannot create exlude user agent pattern for NTLM authentication (pattern=%1$s)", ntlmPattern), (Throwable)e);
                this.excludeNtlmAuthUserAgentPattern = null;
            }
        }
        this.allowNtlmDetailsStore = Boolean.parseBoolean(properties.getProperty("ntlmAuthFilter.allow.NtlmDetailsStore", "false"));
        this.ntlmDetailsStoreExpirationTaskPeriod = Integer.parseInt(properties.getProperty("ntlmAuthFilter.NtlmDetailsStore.expiration-task-period", "60"));
        if (this.ntlmDetailsStoreExpirationTaskPeriod < 1) {
            this.ntlmDetailsStoreExpirationTaskPeriod = 1;
        }
        this.ntlmDetailsStoreItemDuration = Integer.parseInt(properties.getProperty("ntlmAuthFilter.NtlmDetailsStore.item-duration", "120"));
        if (this.ntlmDetailsStoreItemDuration < 1) {
            this.ntlmDetailsStoreItemDuration = 1;
        }
        if (this.ntlmLogonDetailsCache != null) {
            this.ntlmLogonDetailsCache.setHashWrapperDuration(this.ntlmDetailsStoreItemDuration);
            this.ntlmLogonDetailsCache.setTaskExpirationPeriod(this.ntlmDetailsStoreExpirationTaskPeriod);
        }
        this.ntlmDetailsSessionContextDuration = Integer.parseInt(properties.getProperty("ntlmAuthFilter.NtlmDetails.session-context-duration", "120"));
        if (this.ntlmDetailsSessionContextDuration < 1) {
            this.ntlmDetailsSessionContextDuration = 1;
        }
        log.info("New properties:\n\tallowBasicAuthentication\t\t\t\t{}\n\texcludeBasicAuthUserAgentPattern\t\t{}\n\texcludeNtlmAuthUserAgentPattern\t\t{}\n\tallowNtlmDetailsStore\t\t\t\t\t{}\n\tntlmDetailsStoreExpirationTaskPeriod\t{}\n\tntlmDetailsStoreItemDuration\t\t\t{}\n\tntlmDetailsSessionContextDuration\t\t{}", new Object[]{this.allowBasicAuthentication, this.excludeBasicAuthUserAgentPattern, this.excludeNtlmAuthUserAgentPattern, this.allowNtlmDetailsStore, this.ntlmDetailsStoreExpirationTaskPeriod, this.ntlmDetailsStoreItemDuration, this.ntlmDetailsSessionContextDuration});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebCredentials authenticate(Type3NTLMMessage type3Msg, String md4hash, NTLMLogonDetails ntlmDetails) {
        if (this.nltmAuthenticator.getNTLMMode() == NTLMMode.MD4_PROVIDER) {
            boolean authenticated = false;
            if (authenticated = this.validateLocalHashedPassword(type3Msg, ntlmDetails, authenticated, md4hash)) {
                return new NTLMCredentials(ntlmDetails.getUserName(), ntlmDetails.getNTLMHashedPassword());
            }
        } else {
            NTLMPassthruToken authToken = (NTLMPassthruToken)ntlmDetails.getAuthenticationToken();
            authToken.setUserAndPassword(type3Msg.getUserName(), type3Msg.getNTLMHash(), 1);
            try {
                this.nltmAuthenticator.authenticate((Authentication)authToken);
                NTLMCredentials nTLMCredentials = new NTLMCredentials(type3Msg.getUserName(), type3Msg.getNTLMHash());
                return nTLMCredentials;
            }
            catch (BadCredentialsException ex) {
            }
            catch (AuthenticationException ex) {
            }
            finally {
                ntlmDetails.setAuthenticationToken(null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NTLMLogonDetails getNtlmLogonDetails(HttpSession session, boolean checkIfExpired) {
        Object object = this.ntlmLogonDetailsSyncObj;
        synchronized (object) {
            NtlmLogonDetailsWrapper wrapper = (NtlmLogonDetailsWrapper)session.getAttribute(NTLM_AUTH_LOGON_DETAILS);
            if (log.isTraceEnabled()) {
                log.trace("Got NTLM logon details wrapper from session context (wrapper={})", (Object)wrapper);
            }
            if (wrapper == null || checkIfExpired && wrapper.isExpired()) {
                return null;
            }
            wrapper.prolongate();
            return wrapper.getLogonDetails();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNtlmLogonDetails(HttpSession session) {
        Object object = this.ntlmLogonDetailsSyncObj;
        synchronized (object) {
            NtlmLogonDetailsWrapper wrapper = (NtlmLogonDetailsWrapper)session.getAttribute(NTLM_AUTH_LOGON_DETAILS);
            if (wrapper != null) {
                session.removeAttribute(NTLM_AUTH_LOGON_DETAILS);
                if (log.isTraceEnabled()) {
                    log.trace("NTLM logon details wrapper has been removed from session context (wrapper={})", (Object)wrapper);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNtlmLogonDetails(HttpSession session, NTLMLogonDetails logonDetails) {
        Object object = this.ntlmLogonDetailsSyncObj;
        synchronized (object) {
            NtlmLogonDetailsWrapper wrapper = new NtlmLogonDetailsWrapper(logonDetails, this.ntlmDetailsSessionContextDuration);
            session.setAttribute(NTLM_AUTH_LOGON_DETAILS, (Object)wrapper);
            if (log.isTraceEnabled()) {
                log.trace("NTLM logon details wrapper has been added into session context (wrapper={})", (Object)wrapper);
            }
        }
    }

    protected void processType1(Type1NTLMMessage type1Msg, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Received type1 ({})", (Object)type1Msg);
        }
        NTLMLogonDetails ntlmDetails = null;
        HttpSession session = req.getSession();
        ntlmDetails = this.getNtlmLogonDetails(session, true);
        if (ntlmDetails != null && ntlmDetails.hasType2Message() && ntlmDetails.hasNTLMHashedPassword() && ntlmDetails.hasAuthenticationToken()) {
            Type2NTLMMessage cachedType2 = ntlmDetails.getType2Message();
            byte[] type2Bytes = cachedType2.getBytes();
            String ntlmBlob = "NTLM " + new String(Base64.encodeBase64((byte[])type2Bytes));
            if (log.isDebugEnabled()) {
                log.debug("Sending cached NTLM type2 to client ({})", (Object)cachedType2);
            }
            res.setHeader("WWW-Authenticate", ntlmBlob);
            res.setStatus(401);
            res.flushBuffer();
        } else {
            this.removeNtlmLogonDetails(session);
            byte[] challenge = null;
            NTLMPassthruToken authToken = null;
            if (this.nltmAuthenticator.getNTLMMode() == NTLMMode.MD4_PROVIDER) {
                if (ntlmDetails != null) {
                    challenge = ntlmDetails.getChallengeKey();
                }
                if (challenge == null) {
                    challenge = new byte[8];
                    DataPacker.putIntelLong((long)this.m_random.nextLong(), (byte[])challenge, (int)0);
                }
            } else {
                String domain = type1Msg.getDomain();
                if (domain == null || domain.length() == 0) {
                    domain = this.mapClientAddressToDomain(req.getRemoteAddr());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Client domain ({})", (Object)domain);
                }
                authToken = new NTLMPassthruToken(domain);
                this.nltmAuthenticator.authenticate((Authentication)authToken);
                if (authToken.getChallenge() != null) {
                    challenge = authToken.getChallenge().getBytes();
                }
            }
            int ntlmFlags = type1Msg.getFlags() & this.m_ntlmFlags;
            ArrayList<TargetInfo> tList = new ArrayList<TargetInfo>();
            String srvName = this.getServerName();
            tList.add(new TargetInfo(1, srvName));
            Type2NTLMMessage type2Msg = new Type2NTLMMessage();
            type2Msg.buildType2(ntlmFlags, srvName, challenge, null, tList);
            ntlmDetails = new NTLMLogonDetails();
            ntlmDetails.setType2Message(type2Msg);
            ntlmDetails.setAuthenticationToken((Object)authToken);
            this.setNtlmLogonDetails(session, ntlmDetails);
            if (this.allowNtlmDetailsStore) {
                this.ntlmLogonDetailsCache.addNtlmDetails(ntlmDetails);
            }
            if (log.isDebugEnabled()) {
                log.debug("Sending NTLM type2 to client ({})", (Object)type2Msg);
            }
            byte[] type2Bytes = type2Msg.getBytes();
            String ntlmBlob = "NTLM " + new String(Base64.encodeBase64((byte[])type2Bytes));
            res.setHeader("WWW-Authenticate", ntlmBlob);
            res.setStatus(401);
            res.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processType3(Type3NTLMMessage type3Msg, ServletContext context, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        GuestCredentials credentials;
        boolean authenticated;
        String domain;
        String workstation;
        String userName;
        HttpSession session;
        SessionUser user;
        NTLMLogonDetails ntlmDetails;
        block49: {
            block50: {
                block52: {
                    block51: {
                        if (log.isDebugEnabled()) {
                            log.debug("Received type3 ({})", (Object)type3Msg);
                        }
                        ntlmDetails = null;
                        user = null;
                        user = this.getSessionUser(context, req, res, true);
                        session = req.getSession();
                        ntlmDetails = this.getNtlmLogonDetails(session, false);
                        userName = type3Msg.getUserName();
                        workstation = type3Msg.getWorkstation();
                        domain = type3Msg.getDomain();
                        if (StringUtils.isEmpty((String)userName)) {
                            if (log.isDebugEnabled()) {
                                log.debug("processing type 3 message - userName is empty");
                            }
                            this.restartLoginChallenge(context, req, res);
                            return false;
                        }
                        final String userName_f = userName;
                        String normalized = (String)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                            public String execute() throws Throwable {
                                return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                                    public String doWork() throws Exception {
                                        String normalized = NTLMAuthenticationFilter.this.personService.getUserIdentifier(userName_f);
                                        return normalized;
                                    }
                                }, (String)"System");
                            }
                        }, true);
                        if (normalized != null) {
                            userName = normalized;
                        }
                        authenticated = false;
                        if (user != null && ntlmDetails != null && ntlmDetails.hasNTLMHashedPassword()) {
                            byte[] ntlmPwd = type3Msg.getNTLMHash();
                            byte[] cachedPwd = ntlmDetails.getNTLMHashedPassword();
                            if (ntlmPwd != null) {
                                authenticated = Arrays.equals(cachedPwd, ntlmPwd);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("Using cached NTLM hash (authenticated={})", (Object)authenticated);
                            }
                            this.onValidate(context, req, res, (WebCredentials)new NTLMCredentials(userName, ntlmPwd));
                            return true;
                        }
                        if (this.nltmAuthenticator.getNTLMMode() != NTLMMode.MD4_PROVIDER) break block50;
                        if (!this.m_allowGuest || !userName.equalsIgnoreCase(this.authenticationComponent.getGuestUserName())) break block51;
                        credentials = new GuestCredentials();
                        authenticated = true;
                        if (log.isDebugEnabled()) {
                            log.debug("Guest logon");
                        }
                        break block49;
                    }
                    String md4hash = this.getMD4Hash(userName);
                    if (log.isTraceEnabled()) {
                        log.trace("got MD4 hash password (user={}, md4={})", new Object[]{userName, md4hash});
                    }
                    if (md4hash == null) break block52;
                    if (ntlmDetails == null) {
                        credentials = null;
                        if (this.allowNtlmDetailsStore) {
                            credentials = this.ntlmLogonDetailsCache.getWebCredentials(type3Msg, md4hash);
                        }
                        if (credentials != null) {
                            authenticated = true;
                            break block49;
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("processing type 3 message - ntlmDetails is not defined");
                            }
                            this.restartLoginChallenge(context, req, res);
                            return false;
                        }
                    }
                    if ((authenticated = this.validateLocalHashedPassword(type3Msg, ntlmDetails, authenticated, md4hash)) && this.allowNtlmDetailsStore) {
                        this.ntlmLogonDetailsCache.prolongate(ntlmDetails);
                    }
                    credentials = new NTLMCredentials(ntlmDetails.getUserName(), ntlmDetails.getNTLMHashedPassword());
                    break block49;
                }
                if (this.m_mapUnknownUserToGuest) {
                    userName = this.authenticationComponent.getGuestUserName();
                    authenticated = true;
                    credentials = new GuestCredentials();
                    if (log.isDebugEnabled()) {
                        log.debug("User {} logged on as guest, no Alfresco account", (Object)userName);
                    }
                    break block49;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("User {} does not have Alfresco account", (Object)userName);
                    }
                    credentials = new UnknownCredentials();
                    authenticated = false;
                }
                break block49;
            }
            if (type3Msg.hasFlag(0x20000000) && type3Msg.hasFlag(524288) || type3Msg.getNTLMHash() != null && type3Msg.getNTLMHash().length > 24) {
                credentials = null;
                if (log.isErrorEnabled()) {
                    log.error("Client {} using NTLMv2 logon, not valid with passthru authentication", (Object)workstation);
                }
            } else {
                if (ntlmDetails == null) {
                    credentials = null;
                    if (this.allowNtlmDetailsStore) {
                        credentials = this.ntlmLogonDetailsCache.getWebCredentials(type3Msg, null);
                    }
                    if (credentials != null) {
                        authenticated = true;
                        break block49;
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("processing type 3 message - ntlmDetails is not defined");
                        }
                        this.restartLoginChallenge(context, req, res);
                        return false;
                    }
                }
                credentials = new NTLMCredentials(type3Msg.getUserName(), type3Msg.getNTLMHash());
                NTLMPassthruToken authToken = (NTLMPassthruToken)ntlmDetails.getAuthenticationToken();
                authToken.setUserAndPassword(type3Msg.getUserName(), type3Msg.getNTLMHash(), 1);
                try {
                    this.nltmAuthenticator.authenticate((Authentication)authToken);
                    authenticated = true;
                    if (this.allowNtlmDetailsStore) {
                        this.ntlmLogonDetailsCache.prolongate(ntlmDetails);
                    }
                    if (authToken.isGuestLogon()) {
                        userName = this.authenticationComponent.getGuestUserName();
                    }
                    this.authenticationComponent.setCurrentUser(userName);
                }
                catch (BadCredentialsException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Authentication failed, {})", (Object)ex.getMessage());
                    }
                }
                catch (AuthenticationException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Authentication failed, {}", (Object)ex.getMessage());
                    }
                }
                finally {
                    ntlmDetails.setAuthenticationToken(null);
                }
            }
        }
        if (authenticated) {
            boolean userInit = false;
            if (user == null) {
                try {
                    String mappedUser = this.loginResolver.getMappedLogin(userName);
                    user = this.createUserEnvironment(session, mappedUser);
                    userInit = true;
                }
                catch (AuthenticationException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Failed to validate user %1$s", userName), (Throwable)ex);
                    }
                    this.onValidateFailed(context, req, res, session, (WebCredentials)credentials);
                    return false;
                }
            }
            this.onValidate(context, req, res, (WebCredentials)credentials);
            String srvName = this.getServerName();
            if (ntlmDetails == null) {
                ntlmDetails = new NTLMLogonDetails(userName, workstation, domain, false, srvName);
                ntlmDetails.setNTLMHashedPassword(type3Msg.getNTLMHash());
                this.setNtlmLogonDetails(session, ntlmDetails);
                if (log.isDebugEnabled()) {
                    log.debug("No cached NTLM details, created");
                }
            } else {
                ntlmDetails.setDetails(userName, workstation, domain, false, srvName);
                ntlmDetails.setNTLMHashedPassword(type3Msg.getNTLMHash());
                if (log.isDebugEnabled()) {
                    log.debug("Updated cached NTLM details");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("User logged on via NTLM, {}", (Object)ntlmDetails);
            }
            if (!this.onLoginComplete(context, req, res, userInit)) return false;
            return true;
        }
        this.restartLoginChallenge(context, req, res);
        return false;
    }

    static {
        LinkedHashMap<String, CharsetDecoder> decoders = new LinkedHashMap<String, CharsetDecoder>(ENCODINGS.length * 2);
        for (String encoding : ENCODINGS) {
            if (decoders.containsKey(encoding)) continue;
            decoders.put(encoding, Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT));
        }
        DECODERS = new CharsetDecoder[decoders.size()];
        decoders.values().toArray(DECODERS);
    }

    private static enum AuthMethod {
        NONE,
        BASIC,
        NTLM;

    }
}

