/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.auth.repo.webdav;

import com.coremedia.iso.Hex;
import cz.ryant.alfresco.auth.repo.webdav.NtlmLogonDetailsWrapper;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.alfresco.jlan.server.auth.ntlm.NTLMLogonDetails;
import org.alfresco.jlan.server.auth.ntlm.Type3NTLMMessage;
import org.alfresco.repo.web.auth.WebCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NtlmLogonDetailsCache {
    private static final Logger log = LoggerFactory.getLogger(NtlmLogonDetailsCache.class);
    private int taskExpirationPeriod;
    private int hashWrapperDuration;
    private Map<String, NtlmLogonDetailsWrapper> ntlmLogonDetailsMap = new HashMap<String, NtlmLogonDetailsWrapper>();
    private Timer timer;
    private TimerTask timerTask;

    public NtlmLogonDetailsCache(int taskExpirationPeriod, int hashWrapperDuration) {
        this.setHashWrapperDuration(hashWrapperDuration);
        this.setTaskExpirationPeriod(taskExpirationPeriod);
        this.rescheduleRemoveTask();
    }

    public void setHashWrapperDuration(int hashWrapperDuration) {
        this.hashWrapperDuration = hashWrapperDuration;
    }

    public synchronized void addNtlmDetails(NTLMLogonDetails ntlmLogonDetails) {
        NtlmLogonDetailsWrapper wrapper = new NtlmLogonDetailsWrapper(ntlmLogonDetails, this.hashWrapperDuration);
        String challenge = Hex.encodeHex((byte[])ntlmLogonDetails.getChallengeKey());
        this.ntlmLogonDetailsMap.put(challenge, wrapper);
        if (log.isTraceEnabled()) {
            log.trace("NTLM-Details-Store: new details has been added into cache (details={})", (Object)wrapper);
        }
    }

    public void setTaskExpirationPeriod(int taskExpirationPeriod) {
        this.taskExpirationPeriod = taskExpirationPeriod;
    }

    public synchronized int removeExpiredNtlmLogonDetails() {
        int removeCnt = 0;
        Iterator<Map.Entry<String, NtlmLogonDetailsWrapper>> iterator = this.ntlmLogonDetailsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, NtlmLogonDetailsWrapper> entry = iterator.next();
            NtlmLogonDetailsWrapper wrapper = entry.getValue();
            if (!wrapper.isExpired()) continue;
            iterator.remove();
            ++removeCnt;
            if (!log.isTraceEnabled()) continue;
            log.trace("NTLM-Details-Store: details has been expired -> removed (details={})", (Object)wrapper);
        }
        if (removeCnt > 0 && log.isTraceEnabled()) {
            log.trace("NTLM-Details-Store: {} details has been removed", (Object)removeCnt);
        }
        return this.ntlmLogonDetailsMap.size();
    }

    public synchronized WebCredentials getWebCredentials(Type3NTLMMessage type3Msg, String md4hash) {
        Iterator<Map.Entry<String, NtlmLogonDetailsWrapper>> iterator = this.ntlmLogonDetailsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, NtlmLogonDetailsWrapper> entry = iterator.next();
            NtlmLogonDetailsWrapper wrapper = entry.getValue();
            if (wrapper.isExpired()) {
                iterator.remove();
                if (!log.isTraceEnabled()) continue;
                log.trace("NTLM-Details-Store: removed expired details (details={})", (Object)wrapper);
                continue;
            }
            WebCredentials webCredentials = this.getWebCredentials(type3Msg, md4hash, wrapper.getLogonDetails());
            if (webCredentials == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("NTLM-Details-Store: user has been successfully authenticated (details={})", (Object)wrapper);
            }
            wrapper.prolongate();
            return webCredentials;
        }
        return null;
    }

    public synchronized void prolongate(NTLMLogonDetails ntlmLogonDetails) {
        String challenge = Hex.encodeHex((byte[])ntlmLogonDetails.getChallengeKey());
        NtlmLogonDetailsWrapper wrapper = this.ntlmLogonDetailsMap.get(challenge);
        if (wrapper != null) {
            wrapper.prolongate();
        } else if (log.isTraceEnabled()) {
            log.trace("cannot prolongate NTLM logon detail - no wrapper found in cache (challenge={})", (Object)challenge);
        }
    }

    public abstract WebCredentials getWebCredentials(Type3NTLMMessage var1, String var2, NTLMLogonDetails var3);

    private void rescheduleRemoveTask() {
        if (log.isTraceEnabled()) {
            log.trace("NTLM-Details-Store: creating new timer task (period={})", (Object)this.taskExpirationPeriod);
        }
        if (this.timer != null) {
            this.timer.cancel();
            log.trace("NTLM-Details-Store: timer canceled");
        }
        this.timer = new Timer();
        log.trace("NTLM-Details-Store: new timer created");
        if (this.timerTask != null) {
            this.timerTask.cancel();
            log.trace("NTLM-Details-Store: timerTask canceled");
        }
        final int period = this.taskExpirationPeriod;
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("NTLM-logon-details-cache-remove-task");
                if (log.isTraceEnabled()) {
                    log.trace("NTLM-Details-Store: Remove expired details task scheduled...");
                }
                int remains = NtlmLogonDetailsCache.this.removeExpiredNtlmLogonDetails();
                if (log.isTraceEnabled()) {
                    log.trace("NTLM-Details-Store: Remove expired details task done (remaining={})", (Object)remains);
                }
                if (period != NtlmLogonDetailsCache.this.taskExpirationPeriod) {
                    NtlmLogonDetailsCache.this.rescheduleRemoveTask();
                }
            }
        };
        this.timer.schedule(this.timerTask, new Date(), (long)(this.taskExpirationPeriod * 1000));
        if (log.isTraceEnabled()) {
            log.trace("NTLM-Details-Store: timerTask has been scheduled and started (period={})", (Object)this.taskExpirationPeriod);
        }
    }
}

