/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.auth.repo.webdav;

import com.coremedia.iso.Hex;
import java.util.Date;
import org.alfresco.jlan.server.auth.ntlm.NTLMLogonDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmLogonDetailsWrapper {
    private static final Logger log = LoggerFactory.getLogger(NtlmLogonDetailsWrapper.class);
    private NTLMLogonDetails ntlmLogonDetails;
    private int duration;
    private long ts;

    public NtlmLogonDetailsWrapper(NTLMLogonDetails ntlmLogonDetails, int duration) {
        if (ntlmLogonDetails == null) {
            throw new IllegalArgumentException("Logon details cannot be null");
        }
        this.ntlmLogonDetails = ntlmLogonDetails;
        this.duration = duration * 1000;
        this.ts = new Date().getTime();
    }

    public boolean isExpired() {
        long now = new Date().getTime();
        return now - this.ts > (long)this.duration;
    }

    public void prolongate() {
        this.ts = new Date().getTime();
        if (log.isTraceEnabled()) {
            log.trace("details has been prolongated (details={})", (Object)this);
        }
    }

    public NTLMLogonDetails getLogonDetails() {
        return this.ntlmLogonDetails;
    }

    public static String getChallengeKey(NTLMLogonDetails logonDetails) {
        byte[] challenge = logonDetails.getChallengeKey();
        if (challenge == null) {
            return "n/a";
        }
        return Hex.encodeHex((byte[])challenge);
    }

    public String toString() {
        if (this.ntlmLogonDetails == null) {
            return "n/a";
        }
        return String.format("%1$s|%2$s|%3$s, challenge=%4$s, ts=%5$s, expired=%6$s", this.ntlmLogonDetails.getDomain(), this.ntlmLogonDetails.getUserName(), this.ntlmLogonDetails.getWorkstation(), NtlmLogonDetailsWrapper.getChallengeKey(this.ntlmLogonDetails), this.ts, this.isExpired());
    }
}

