/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.db.controllers;

import cz.ryant.alfresco.db.controllers.DaoController;
import cz.ryant.alfresco.db.dao.DaoException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractDaoController
implements DaoController {
    public static final String PARAM_CONTROLLER = "controller";
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_DATASET = "dataset";
    public static final String PARAM_MAX_ITEMS = "maxitems";
    public static final String PARAM_NODE_REF = "noderef";
    protected static final String ACTION_ITEMS = "items";
    protected static final String ACTION_ITEM = "item";

    protected String getControllerName(WebScriptRequest request) {
        return request.getParameter(PARAM_CONTROLLER);
    }

    protected String getQuery(WebScriptRequest request) throws DaoException {
        try {
            String str = request.getParameter(PARAM_QUERY);
            if (StringUtils.isNotEmpty((String)str)) {
                return URLDecoder.decode(str, "UTF-8");
            }
            return null;
        }
        catch (UnsupportedEncodingException uee) {
            throw new DaoException("cannot get query", uee);
        }
    }

    protected String getAction(WebScriptRequest request) {
        return request.getParameter(PARAM_ACTION);
    }

    protected String getDataSet(WebScriptRequest request) {
        return request.getParameter(PARAM_DATASET);
    }

    protected int getMaxItem(WebScriptRequest request) {
        return NumberUtils.toInt((String)request.getParameter(PARAM_MAX_ITEMS), (int)-1);
    }

    protected String getNodeRef(WebScriptRequest request) throws DaoException {
        try {
            String str = request.getParameter(PARAM_NODE_REF);
            if (StringUtils.isNotEmpty((String)str)) {
                return URLDecoder.decode(str, "UTF-8");
            }
            return null;
        }
        catch (UnsupportedEncodingException uee) {
            throw new DaoException("cannot get nodeRef", uee);
        }
    }
}

