/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.db.dao;

import cz.ryant.alfresco.db.OrderType;
import cz.ryant.alfresco.db.dao.HibernateDataSource;
import cz.ryant.alfresco.utils.configurator.Configuration;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedEvent;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedListener;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernateDataSource
implements HibernateDataSource,
ConfigurationChangedListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractHibernateDataSource.class);
    private String dialect;
    private String driver;
    private String url;
    private String userName;
    private String password;
    private boolean showSql;
    private static final String CFG_PARAM_DIALECT = "datasource.dialect";
    private static final String CFG_PARAM_DRIVER = "datasource.driver";
    private static final String CFG_PARAM_URL = "datasource.url";
    private static final String CFG_PARAM_USER_NAME = "datasource.userName";
    private static final String CFG_PARAM_PASSWORD = "datasource.password";
    private static final String CFG_PARAM_SHOW_SQL = "datasource.show_sql";
    private String cfgPrefix;
    private SessionFactory sessionFactory;
    private boolean canCreateSessionFactory;

    public AbstractHibernateDataSource(String dialect, String driver, String url, String userName, String password) {
        this.dialect = dialect;
        this.driver = driver;
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.canCreateSessionFactory = true;
    }

    public AbstractHibernateDataSource(Configuration configuration, String cfgPrefix) {
        log.debug("creating new instance of datasource (cfgprefix={})", (Object)cfgPrefix);
        this.cfgPrefix = cfgPrefix;
        configuration.addListener((ConfigurationChangedListener)this);
        this.processConfiguration(configuration.getProperties());
    }

    private Properties createHibernateConfiguration() {
        log.debug("creating new hibernate configuration");
        Properties cfg = new Properties();
        cfg.setProperty("hibernate.dialect", this.dialect);
        cfg.setProperty("hibernate.connection.driver_class", this.driver);
        cfg.setProperty("hibernate.connection.url", this.url);
        cfg.setProperty("hibernate.connection.username", this.userName);
        if (this.password != null) {
            cfg.setProperty("hibernate.connection.password", this.password);
        }
        cfg.setProperty("hibernate.hbm2ddl.auto", "none");
        cfg.setProperty("show_sql", Boolean.toString(this.showSql));
        log.debug("hibernate.dialect={}", (Object)this.dialect);
        log.debug("hibernate.connection.driver_class={}", (Object)this.driver);
        log.debug("hibernate.connection.url={}", (Object)this.url);
        log.debug("hibernate.connection.username={}", (Object)this.userName);
        log.debug("hibernate.connection.password={}", (Object)this.password);
        log.debug("show_sql={}", (Object)this.showSql);
        return cfg;
    }

    private synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.createSessionFactory();
        }
        return this.sessionFactory;
    }

    protected Session getSession() {
        return this.getSessionFactory().openSession();
    }

    protected void closeSession(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e) {
                log.warn("cannot close session", (Throwable)e);
            }
        }
    }

    protected Order createOrder(String orderBy, OrderType sortOrder) {
        switch (sortOrder) {
            case ASC: {
                return Order.asc((String)orderBy);
            }
            case DESC: {
                return Order.desc((String)orderBy);
            }
        }
        return null;
    }

    protected void addOrders(Criteria criteria, String orderBy, OrderType orderType) {
        String[] orders;
        if (orderBy == null) {
            return;
        }
        for (String strOrder : orders = orderBy.split(",")) {
            Order order = this.createOrder(strOrder.trim(), orderType);
            if (order == null) continue;
            criteria.addOrder(order);
        }
    }

    private void createSessionFactory() {
        if (!this.canCreateSessionFactory) {
            log.warn("cannot create session factoryt (canCreateSessionFactory=false)");
            return;
        }
        log.debug("creating session factory");
        AnnotationConfiguration hibCfg = new AnnotationConfiguration();
        for (String string : this.getDaoPackages()) {
            log.debug("adding package '{}'", (Object)string);
            hibCfg.addPackage(string);
        }
        for (Class clazz : this.getAnnotatedClasses()) {
            log.debug("adding class '{}'", (Object)clazz.getName());
            hibCfg.addAnnotatedClass(clazz);
        }
        Properties cfg = this.createHibernateConfiguration();
        hibCfg.setProperties(cfg);
        this.sessionFactory = hibCfg.buildSessionFactory();
        log.debug("session factory successfully created");
    }

    protected abstract List<String> getDaoPackages();

    protected abstract List<Class<?>> getAnnotatedClasses();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<?> LoadObjectAsList(Class<T> type, Object id, String idName) {
        if (log.isDebugEnabled()) {
            log.debug("getting object by id (id={}, idName={}, type={})", new Object[]{id, idName, type.getName()});
        }
        if (StringUtils.isEmpty((String)idName)) {
            idName = "id";
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(type).add((Criterion)Expression.eq((String)idName, (Object)id)).setMaxResults(1);
            List result = criteria.list();
            if (log.isDebugEnabled()) {
                log.debug("got object ({})", (Object)result);
            }
            List list = result;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public <T> T LoadObject(Class<T> type, Object id, String idName) {
        List<?> result = this.LoadObjectAsList(type, id, idName);
        return result.size() == 1 ? (T)result.get(0) : null;
    }

    public void handleConfigurationChange(ConfigurationChangedEvent e) {
        this.processConfiguration(e.getProperties());
    }

    private String getConfigParameterWithPrefix(String paramName) {
        return StringUtils.isEmpty((String)this.cfgPrefix) ? paramName : this.cfgPrefix + "." + paramName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSessionFactory() {
        if (this.sessionFactory == null) {
            return;
        }
        try {
            this.sessionFactory.close();
        }
        catch (Exception e) {
            log.error("cannot close session factory", (Throwable)e);
        }
        finally {
            this.sessionFactory = null;
        }
    }

    private void processConfiguration(Properties props) {
        this.closeSessionFactory();
        this.canCreateSessionFactory = false;
        if (props == null) {
            return;
        }
        this.dialect = props.getProperty(this.getConfigParameterWithPrefix(CFG_PARAM_DIALECT), null);
        this.driver = props.getProperty(this.getConfigParameterWithPrefix(CFG_PARAM_DRIVER), null);
        this.url = props.getProperty(this.getConfigParameterWithPrefix(CFG_PARAM_URL), null);
        this.userName = props.getProperty(this.getConfigParameterWithPrefix(CFG_PARAM_USER_NAME), null);
        this.password = props.getProperty(this.getConfigParameterWithPrefix(CFG_PARAM_PASSWORD), null);
        try {
            this.showSql = Boolean.parseBoolean(props.getProperty(this.getConfigParameterWithPrefix(CFG_PARAM_SHOW_SQL)));
        }
        catch (Exception e) {
            this.showSql = false;
        }
        log.debug("processed new parameters for hibernate datasource\n\tcfgPrefix={}\n\tdialect={}\n\tdriver={}\n\turl={}\n\tuserName={}\n\tpassword={}", new Object[]{this.cfgPrefix, this.dialect, this.driver, this.url, this.userName, this.password});
        this.canCreateSessionFactory = !StringUtils.isEmpty((String)this.dialect) && !StringUtils.isEmpty((String)this.driver) && !StringUtils.isEmpty((String)this.url) && !StringUtils.isEmpty((String)this.userName);
        log.info("canCreateSessionFactory={}, cfgPrefix={}", (Object)this.canCreateSessionFactory, (Object)this.cfgPrefix);
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }
}

