/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.db.webscripts;

import cz.ryant.alfresco.db.controllers.DaoController;
import cz.ryant.alfresco.utils.ApplicationContextProvider;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DataProviderScript
extends DeclarativeWebScript {
    private static final Logger log = LoggerFactory.getLogger(DataProviderScript.class);
    private Map<String, DaoController> daoControllers;
    private ObjectMapper mapper;

    public DataProviderScript() {
        log.debug("cteating new instance");
        this.mapper = new ObjectMapper();
        this.daoControllers = new HashMap<String, DaoController>();
    }

    private synchronized DaoController getDaoController(String id) throws Exception {
        DaoController controller = this.daoControllers.get(id);
        if (controller == null) {
            Object bean = ApplicationContextProvider.getBean((String)id);
            if (bean == null) {
                throw new Exception(String.format("no DAO Controller '%1$s' defined in application context", id));
            }
            controller = (DaoController)bean;
            this.daoControllers.put(id, controller);
        }
        return controller;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest request, Status status, Cache cache) {
        cache.setNeverCache(true);
        String controllerName = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            controllerName = request.getParameter("controller");
            log.debug("processing request (controller={}, url={})", (Object)controllerName, (Object)request.getURL());
            DaoController controller = this.getDaoController(controllerName);
            Map<String, Object> obj = controller.processRequest(request);
            result.put("result", this.mapper.writeValueAsString(obj));
        }
        catch (Exception e) {
            String msg = String.format("cannot process request (controller=%1$s, url=%2$s)", controllerName, request.getURL());
            log.error(msg, (Throwable)e);
            status.setCode(500);
            status.setMessage(msg);
            status.setRedirect(true);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("script has been finished with following result: {}", result);
        }
        return result;
    }
}

