/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.jscript;

import cz.ryant.alfresco.utils.Commons;
import org.alfresco.repo.search.impl.lucene.PagingLuceneResultSet;
import org.alfresco.repo.security.permissions.impl.acegi.FilteringResultSet;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Search
extends org.alfresco.repo.jscript.Search {
    private static Logger logger = LoggerFactory.getLogger(Search.class);

    public Scriptable luceneQueryCount(String search) {
        return this.luceneQueryCount(null, search);
    }

    public Scriptable luceneQueryCount(String store, String search) {
        if (logger.isDebugEnabled()) {
            logger.debug("luceneQueryCount(store={}, search={})", new Object[]{store, search});
        }
        if (search != null && search.length() != 0) {
            long count = this.queryCount(store, search, "lucene");
            logger.debug("luceneQueryCount(store={}, search={}) : {}", new Object[]{store, search, count});
            return Context.getCurrentContext().newArray(this.getScope(), new Object[]{count});
        }
        logger.debug("luceneQueryCount(store={}, search={}) : 0", new Object[]{store, search});
        return Context.getCurrentContext().newArray(this.getScope(), 0);
    }

    protected long queryCount(String store, String search, String language) {
        SearchParameters sp = new SearchParameters();
        sp.addStore(store != null ? new StoreRef(store) : this.storeRef);
        sp.setLanguage(language != null ? language : "lucene");
        sp.setQuery(search);
        return this.queryCount(sp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long queryCount(SearchParameters sp, boolean exceptionOnError) {
        ResultSet filteringResultSet = null;
        try (ResultSet results = null;){
            results = this.services.getSearchService().query(sp);
            if (results.getClass().isAssignableFrom(PagingLuceneResultSet.class)) {
                filteringResultSet = ((PagingLuceneResultSet)results).getWrapped();
            } else if (results instanceof FilteringResultSet) {
                filteringResultSet = (FilteringResultSet)results;
            } else {
                logger.error("cannot get count of items - no filteringResultSet");
            }
            if (filteringResultSet != null && filteringResultSet.getClass().isAssignableFrom(FilteringResultSet.class)) {
                ResultSet rs = (ResultSet)Commons.invokePrivateMethod((Object)filteringResultSet, (String)"getUnFilteredResultSet", (Object[])new Object[0]);
                if (rs != null) {
                    long l = rs.getNumberFound();
                    return l;
                }
                logger.error("cannot get count of items - method 'getUnFilteredResultSet' has returned null");
            } else {
                logger.error("cannot get count of items - filteringResultSet is instance of {}", filteringResultSet == null ? "null" : filteringResultSet.getClass());
            }
        }
        return 0L;
    }
}

