/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.repository.acls;

import cz.ryant.alfresco.repository.acls.GroupPathPermission;
import cz.ryant.alfresco.repository.acls.PathRelator;
import cz.ryant.alfresco.repository.acls.PermissionType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.acegisecurity.Authentication;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.PathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelPermissionServiceImpl
extends PermissionServiceImpl {
    private static Logger log = LoggerFactory.getLogger(ExcelPermissionServiceImpl.class);
    private volatile boolean useDefaultPermissionService;
    private volatile List<GroupPathPermission> disabledAcls;
    private volatile List<GroupPathPermission> readOnlyAcls;
    private volatile List<GroupPathPermission> fullAccessAcls;
    private volatile Set<String> readPermsions;
    private volatile Set<String> adminGroups;
    private volatile Set<String> rootPaths;
    private Set<String> emptyStringSet = new HashSet<String>();

    public synchronized void setDefaultPermissionService(boolean useDefaultPermissionService) {
        this.useDefaultPermissionService = useDefaultPermissionService;
    }

    public synchronized void setAcls(List<GroupPathPermission> acls) {
        assert (acls != null) : "acls must not be null";
        this.disabledAcls = ExcelPermissionServiceImpl.filterAcls(acls, PermissionType.DISABLED);
        this.readOnlyAcls = ExcelPermissionServiceImpl.filterAcls(acls, PermissionType.READ);
        this.fullAccessAcls = ExcelPermissionServiceImpl.filterAcls(acls, PermissionType.FULL);
    }

    public synchronized void setReadPermsions(Set<String> readPermsions) {
        assert (readPermsions != null) : "read permissions must not be null";
        this.readPermsions = readPermsions;
    }

    public synchronized void setAdminGroups(Set<String> adminGroups) {
        assert (adminGroups != null) : "admin groups must not be null";
        this.adminGroups = adminGroups;
    }

    public synchronized void setRootPaths(Set<String> rootPaths) {
        this.rootPaths = rootPaths;
    }

    public AccessStatus hasPermission(NodeRef passedNodeRef, PermissionReference permIn) {
        String permName;
        if (this.useDefaultPermissionService) {
            return this.superHasPermission(passedNodeRef, permIn);
        }
        String string = permName = permIn != null ? permIn.getName() : "n/a";
        if (passedNodeRef == null || !this.nodeService.exists(passedNodeRef)) {
            if (log.isTraceEnabled()) {
                log.trace("permission {} ALLOWED for null node", (Object)permName);
            }
            return AccessStatus.ALLOWED;
        }
        if (permIn == null) {
            if (log.isTraceEnabled()) {
                log.trace("permission null DENIED for node '{}'", (Object)passedNodeRef);
            }
            return AccessStatus.DENIED;
        }
        if (passedNodeRef.getStoreRef().getProtocol().equals("avm")) {
            return this.superHasPermission(passedNodeRef, permIn);
        }
        String user = AuthenticationUtil.getRunAsUser();
        if (user == null) {
            if (log.isTraceEnabled()) {
                log.trace("permission {} DENIED for node '{}' for null user", (Object)permName, (Object)passedNodeRef);
            }
            return AccessStatus.DENIED;
        }
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            if (log.isTraceEnabled()) {
                log.trace("permission {} ALLOWED for node '{}' for system user", (Object)permName, (Object)passedNodeRef);
            }
            return AccessStatus.ALLOWED;
        }
        Authentication auth = AuthenticationUtil.getRunAsAuthentication();
        Set authorizations = this.getCoreAuthorisations(auth);
        if (!this.isInAdmingGoup(authorizations)) {
            Path path = this.nodeService.getPath(passedNodeRef);
            String readablePath = PathUtil.getDisplayPath((Path)path, (boolean)true);
            if (log.isTraceEnabled()) {
                log.trace("hasPermission({}, {}, {}, {})", new Object[]{readablePath, permIn.getName(), user, authorizations});
            }
            if (this.isInRootPath(readablePath)) {
                boolean isReadPermission = this.getReadPermsions().contains(permIn.getName());
                AccessStatus result = this.hasPermission(readablePath, isReadPermission, authorizations);
                return result;
            }
        } else if (log.isTraceEnabled()) {
            log.trace("user {} is in admin group", (Object)user);
        }
        return this.superHasPermission(passedNodeRef, permIn);
    }

    private GroupPathPermission getPermissionTriple(List<GroupPathPermission> acls, String path, Set<String> groups, boolean isReadPermission) {
        for (GroupPathPermission acl : acls) {
            PathRelator.PathRelation relation;
            if (!groups.contains(acl.getGroup()) || (relation = PathRelator.relate(path, acl.getPath())) == PathRelator.PathRelation.DIFFERENT) continue;
            if (relation == PathRelator.PathRelation.IDENTICAL || relation == PathRelator.PathRelation.SUB_PATH) {
                return acl;
            }
            if (!isReadPermission) continue;
            return new GroupPathPermission(acl.getGroup(), acl.getPath(), PermissionType.READ);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private AccessStatus hasPermission(String path, boolean isReadPermission, Set<String> groups) {
        block16: {
            block15: {
                block14: {
                    block13: {
                        result = AccessStatus.DENIED;
                        try {
                            gpp = this.getPermissionTriple(this.disabledAcls, path, groups, false);
                            if (gpp == null) break block13;
                            var6_6 = result;
                        }
                        catch (Throwable var9_11) {
                            if (ExcelPermissionServiceImpl.log.isTraceEnabled()) {
                                ExcelPermissionServiceImpl.log.trace("hasPermission: {}, {}, {}, {}", new Object[]{AuthenticationUtil.getRunAsUser(), path, groups, result});
                            }
                            throw var9_11;
                        }
                        if (ExcelPermissionServiceImpl.log.isTraceEnabled()) {
                            ExcelPermissionServiceImpl.log.trace("hasPermission: {}, {}, {}, {}", new Object[]{AuthenticationUtil.getRunAsUser(), path, groups, result});
                        }
                        return var6_6;
                    }
                    gpp = this.getPermissionTriple(this.fullAccessAcls, path, groups, isReadPermission);
                    if (gpp == null || !isReadPermission) break block14;
                    var6_7 = result = AccessStatus.ALLOWED;
                    if (ExcelPermissionServiceImpl.log.isTraceEnabled()) {
                        ExcelPermissionServiceImpl.log.trace("hasPermission: {}, {}, {}, {}", new Object[]{AuthenticationUtil.getRunAsUser(), path, groups, result});
                    }
                    return var6_7;
                }
                gppRead = this.getPermissionTriple(this.readOnlyAcls, path, groups, true);
                if (gppRead == null || gpp == null) ** GOTO lbl35
                pr = PathRelator.relate(gppRead.getPath(), gpp.getPath());
                if (pr != PathRelator.PathRelation.IDENTICAL && pr != PathRelator.PathRelation.SUB_PATH || isReadPermission) break block15;
                var8_10 = result;
                if (ExcelPermissionServiceImpl.log.isTraceEnabled()) {
                    ExcelPermissionServiceImpl.log.trace("hasPermission: {}, {}, {}, {}", new Object[]{AuthenticationUtil.getRunAsUser(), path, groups, result});
                }
                return var8_10;
            }
            result = AccessStatus.ALLOWED;
            break block16;
lbl35:
            // 1 sources

            if (gppRead == null && gpp != null) {
                result = AccessStatus.ALLOWED;
            } else if (gppRead != null && gpp == null && isReadPermission) {
                result = AccessStatus.ALLOWED;
            }
        }
        var7_9 = result;
        if (ExcelPermissionServiceImpl.log.isTraceEnabled()) {
            ExcelPermissionServiceImpl.log.trace("hasPermission: {}, {}, {}, {}", new Object[]{AuthenticationUtil.getRunAsUser(), path, groups, result});
        }
        return var7_9;
    }

    private AccessStatus superHasPermission(NodeRef nodeRef, PermissionReference permIn) {
        if (log.isTraceEnabled()) {
            log.trace("hasPermission({}, {})", (Object)nodeRef, (Object)(permIn != null ? permIn.getName() : null));
        }
        AccessStatus result = super.hasPermission(nodeRef, permIn);
        log.trace("hasPermission: {}", (Object)result);
        return result;
    }

    private static List<GroupPathPermission> filterAcls(List<GroupPathPermission> acls, PermissionType permission) {
        ArrayList<GroupPathPermission> result = new ArrayList<GroupPathPermission>();
        for (GroupPathPermission acl : acls) {
            if (acl.getPermission() != permission) continue;
            result.add(acl);
        }
        return result;
    }

    private Set<String> getReadPermsions() {
        return this.readPermsions != null ? this.readPermsions : this.emptyStringSet;
    }

    private boolean isInAdmingGoup(Set<String> groups) {
        for (String adminGroup : this.getAdminGroups()) {
            if (!groups.contains(adminGroup)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getAdminGroups() {
        return this.adminGroups != null ? this.adminGroups : this.emptyStringSet;
    }

    private boolean isInRootPath(String path) {
        path = path + "/";
        for (String rootPath : this.getRootPaths()) {
            if (!path.startsWith(rootPath)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getRootPaths() {
        return this.rootPaths != null ? this.rootPaths : this.emptyStringSet;
    }
}

