/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.repository.acls;

import cz.ryant.alfresco.repository.acls.PathRelator;
import cz.ryant.alfresco.repository.acls.PermissionType;

public class GroupPathPermission {
    private String group;
    private String path;
    private PermissionType permission;

    public GroupPathPermission() {
    }

    public GroupPathPermission(String group, String path, PermissionType permissionType) {
        this.group = group;
        this.setPath(path);
        this.permission = permissionType;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = this.getNormalizedPath(path);
    }

    public PermissionType getPermission() {
        return this.permission;
    }

    public void setPermission(PermissionType permission) {
        this.permission = permission;
    }

    private String getNormalizedPath(String path) {
        if (path == null) {
            return "/";
        }
        while (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        if (!path.startsWith("/") && path.length() > 1) {
            path = "/" + path;
        }
        if (!path.startsWith("/company_home")) {
            path = "/company_home" + path;
        }
        return path;
    }

    public String toString() {
        return String.format("(group=%1$s, path=%2$s, permission=%3$s)", new Object[]{this.group, this.path, this.permission});
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof GroupPathPermission)) {
            return false;
        }
        GroupPathPermission gpp = (GroupPathPermission)o;
        if (this.path == null && gpp.path == null && this.group == null && gpp.path == null) {
            return true;
        }
        return this.path != null && this.path.equals(gpp.path) && this.group != null && this.group.equals(gpp.group) && this.permission == gpp.permission;
    }

    public int hashCode() {
        int hash;
        if (this.path == null && this.group == null) {
            return 0;
        }
        int n = hash = this.path == null ? 1 : 13 + this.path.hashCode();
        if (this.group != null) {
            hash = hash * 17 + this.group.hashCode();
        }
        hash = hash * 17 + this.permission.getValue();
        return hash;
    }

    public PathRelator.PathRelation relate(GroupPathPermission gpp) {
        if (!this.group.equals(gpp.group) || this.permission != gpp.permission) {
            return PathRelator.PathRelation.DIFFERENT;
        }
        return PathRelator.relate(this.path, gpp.path);
    }
}

