/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.repository.acls;

public class PathRelator {
    public static PathRelation relate(String path1, String path2) {
        if ((path1 = PathRelator.normalize(path1)).equals(path2 = PathRelator.normalize(path2))) {
            return PathRelation.IDENTICAL;
        }
        if (path1.startsWith(path2)) {
            return PathRelation.SUB_PATH;
        }
        if (path2.startsWith(path1)) {
            return PathRelation.SUPER_PATH;
        }
        return PathRelation.DIFFERENT;
    }

    private static String normalize(String path) {
        if (path == null || "".equals(path)) {
            return "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.equals("/")) {
            return "/";
        }
        return path.endsWith("/") ? path : path + "/";
    }

    public static enum PathRelation {
        IDENTICAL,
        DIFFERENT,
        SUB_PATH,
        SUPER_PATH;

    }
}

