/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.repository.behaviours;

import cz.ryant.alfresco.repository.utils.AlfrescoUtils;
import cz.ryant.alfresco.utils.configurator.Configuration;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedEvent;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolicy
implements ConfigurationChangedListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractPolicy.class);
    private final Configuration configuration;
    private final PolicyComponent policyComponent;
    private List<BehaviourDefinition<ClassBehaviourBinding>> behaviourDefinitions;
    protected boolean isActive = false;
    protected final AlfrescoUtils alfrescoUtils;

    public AbstractPolicy(Configuration configuration, PolicyComponent policyComponent, AlfrescoUtils alfrescoUtils) {
        this.configuration = configuration;
        this.policyComponent = policyComponent;
        this.behaviourDefinitions = new ArrayList<BehaviourDefinition<ClassBehaviourBinding>>();
        this.alfrescoUtils = alfrescoUtils;
    }

    public void init() {
        this.bindBehaviours();
        this.configuration.addListener((ConfigurationChangedListener)this);
        this.doProcessProperties(this.configuration.getProperties());
    }

    public void destroy() {
        log.debug("destroying ({})", this.getClass());
        this.configuration.removeListener((ConfigurationChangedListener)this);
        this.unbindBehaviours();
        log.debug("destroyed ({})", this.getClass());
    }

    protected void bindBehaviour(Behaviour behaviour, String methodName, QName nodeType) {
        log.debug("binding behaviour '{}' and type '{}' ({})", new Object[]{behaviour, nodeType, this.getClass()});
        try {
            behaviour.disable();
            BehaviourDefinition definition = this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)methodName), nodeType, behaviour);
            this.behaviourDefinitions.add((BehaviourDefinition<ClassBehaviourBinding>)definition);
            log.debug("behaviour '{}' for type '{}' successfully bound ({})", new Object[]{behaviour, nodeType, this.getClass()});
        }
        catch (Exception e) {
            String msg = String.format("cannot bind behaviour '%1$s' for type '%2$s' (%3$s)", behaviour, nodeType, this.getClass());
            log.error(msg, (Throwable)e);
        }
    }

    private void unbindBehaviours() {
        log.debug("unbinding behaviour definitions ({})", this.getClass());
        if (this.behaviourDefinitions == null) {
            return;
        }
        for (BehaviourDefinition<ClassBehaviourBinding> definition : this.behaviourDefinitions) {
            try {
                log.debug("removing class definition for behaviour '{}'", (Object)definition.getBehaviour());
                definition.getBehaviour().disable();
                this.policyComponent.removeClassDefinition(definition);
            }
            catch (Exception e) {
                String msg = String.format("cannot unbind behaviour for method '%1$s'", definition.getBehaviour());
                log.error(msg, (Throwable)e);
            }
        }
        this.behaviourDefinitions.clear();
        log.debug("behaviour definitions unbound ({})", this.getClass());
    }

    private synchronized void enableBehaviours(boolean enable) {
        if (this.behaviourDefinitions == null) {
            return;
        }
        if (enable == this.isActive) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("{} behaviours ({})", (Object)(enable ? "enabling" : "disabling"), this.getClass());
        }
        for (BehaviourDefinition<ClassBehaviourBinding> def : this.behaviourDefinitions) {
            if (enable) {
                def.getBehaviour().enable();
                continue;
            }
            def.getBehaviour().disable();
        }
        if (log.isInfoEnabled()) {
            log.info("behaviours {} ({})", (Object)(enable ? "enabled" : "disabled"), this.getClass());
        }
        this.isActive = enable;
    }

    protected abstract void processProperties(Properties var1);

    protected abstract void bindBehaviours();

    private void doProcessProperties(Properties props) {
        if (props == null) {
            this.enableBehaviours(false);
            return;
        }
        this.processProperties(props);
        this.enableBehaviours(this.isActive);
    }

    public void handleConfigurationChange(ConfigurationChangedEvent e) {
        this.doProcessProperties(e.getProperties());
    }
}

