/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.repository.behaviours;

import cz.ryant.alfresco.repository.acls.ExcelPermissionServiceImpl;
import cz.ryant.alfresco.repository.acls.GroupPathPermission;
import cz.ryant.alfresco.repository.behaviours.AbstractPolicy;
import cz.ryant.alfresco.repository.poi.AclExcelReader;
import cz.ryant.alfresco.repository.utils.AlfrescoUtils;
import cz.ryant.alfresco.utils.configurator.Configuration;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelAclNodesPolicy
extends AbstractPolicy
implements ContentServicePolicies.OnContentUpdatePolicy,
NodeServicePolicies.OnMoveNodePolicy,
NodeServicePolicies.OnDeleteNodePolicy,
NodeServicePolicies.OnRestoreNodePolicy {
    private static final Logger log = LoggerFactory.getLogger(ExcelAclNodesPolicy.class);
    private static final String EXCEL_ACL_USE_DEFAULT_PERMISSION_SERVICE_PROP = "excel-acl.use.default.permission.service";
    private static final String EXCEL_ACL_FILE_AUTO_RELOAD_PROP = "excel-acl.file.auto.reload";
    private static final String EXCEL_ACL_ROOT_NODES_PROP = "excel-acl.root.nodes";
    private static final String EXCEL_ACL_ADMIN_GROUPS_PROP = "excel-acl.admin.groups";
    private static final String EXCEL_ACL_READ_PERMISSIONS_PROP = "excel-acl.read.permissions";
    private static final String EXCEL_ACL_FILE_PROP = "excel-acl.file";
    private boolean useDefaultPermissionService;
    private Set<String> rootPaths;
    private Set<String> adminGroups;
    private Set<String> readPermsions;
    private String excelAclPath;
    private NodeRef excelAclNodeRef;
    private ExcelPermissionServiceImpl permissionService;
    private final Object excelAclSyncObj = new Object();
    private final List<GroupPathPermission> emptyAcls = new ArrayList<GroupPathPermission>();

    public ExcelAclNodesPolicy(Configuration configuration, PolicyComponent policyComponent, AlfrescoUtils alfrescoUtils) {
        super(configuration, policyComponent, alfrescoUtils);
    }

    @Override
    protected void processProperties(Properties properties) {
        this.useDefaultPermissionService = Boolean.parseBoolean(properties.getProperty(EXCEL_ACL_USE_DEFAULT_PERMISSION_SERVICE_PROP, "true"));
        this.isActive = Boolean.parseBoolean(properties.getProperty(EXCEL_ACL_FILE_AUTO_RELOAD_PROP, "false"));
        String paths = properties.getProperty(EXCEL_ACL_ROOT_NODES_PROP, "/company_home");
        this.setRootPaths(paths);
        this.excelAclPath = properties.getProperty(EXCEL_ACL_FILE_PROP, null);
        try {
            this.excelAclNodeRef = this.alfrescoUtils.getNodeByPathBySystem(this.excelAclPath);
        }
        catch (Exception e) {
            log.error("cannot get Excel ACLs path: {}", (Object)e.getMessage());
        }
        this.adminGroups = this.string2Set(properties.getProperty(EXCEL_ACL_ADMIN_GROUPS_PROP, null));
        this.readPermsions = this.string2Set(properties.getProperty(EXCEL_ACL_READ_PERMISSIONS_PROP, null));
        log.info("New properties:\n\tisActive:                  {}\n\trootPaths:                 {}\n\tadminGroups:               {}\n\treadPermsions:             {}\n\texcelAcl:                  {}\n\texcelAclNodeRef:           {}", new Object[]{this.isActive, this.rootPaths, this.adminGroups, this.readPermsions, this.excelAclPath, this.excelAclNodeRef});
        this.setPermissionServiceProperties();
    }

    @Override
    protected void bindBehaviours() {
        Behaviour.NotificationFrequency frequency = Behaviour.NotificationFrequency.TRANSACTION_COMMIT;
        this.bindBehaviour((Behaviour)new JavaBehaviour((Object)this, "onContentUpdate", frequency), "onContentUpdate", ContentModel.TYPE_CONTENT);
        this.bindBehaviour((Behaviour)new JavaBehaviour((Object)this, "onMoveNode", frequency), "onMoveNode", ContentModel.TYPE_CONTENT);
        this.bindBehaviour((Behaviour)new JavaBehaviour((Object)this, "onDeleteNode", frequency), "onDeleteNode", ContentModel.TYPE_CONTENT);
        this.bindBehaviour((Behaviour)new JavaBehaviour((Object)this, "onRestoreNode", frequency), "onRestoreNode", ContentModel.TYPE_CONTENT);
        this.bindBehaviour((Behaviour)new JavaBehaviour((Object)this, "onMoveNode", frequency), "onMoveNode", ContentModel.TYPE_FOLDER);
        this.bindBehaviour((Behaviour)new JavaBehaviour((Object)this, "onDeleteNode", frequency), "onDeleteNode", ContentModel.TYPE_FOLDER);
        this.bindBehaviour((Behaviour)new JavaBehaviour((Object)this, "onRestoreNode", frequency), "onRestoreNode", ContentModel.TYPE_FOLDER);
    }

    public void setPermissionService(ExcelPermissionServiceImpl permissionService) {
        this.permissionService = permissionService;
    }

    public void onRestoreNode(ChildAssociationRef childAssocRef) {
        this.detectExcelAclFileRestored();
    }

    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        this.detectExcelAclFileDeleted();
    }

    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        this.detectExcelAclFileMoved();
    }

    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        this.detectExcelAclFileUpdated(nodeRef);
    }

    private void setAcls() {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                String excelAclFileVersion = "n/a";
                try {
                    log.debug("going to read ACLs from Excel file '{}'", (Object)ExcelAclNodesPolicy.this.excelAclPath);
                    if (ExcelAclNodesPolicy.this.excelAclNodeRef == null) {
                        log.warn("Excel ACL file is not specified in repository");
                        ExcelAclNodesPolicy.this.permissionService.setAcls(ExcelAclNodesPolicy.this.emptyAcls);
                        return null;
                    }
                    excelAclFileVersion = ExcelAclNodesPolicy.this.alfrescoUtils.getCurrentVersion(ExcelAclNodesPolicy.this.excelAclNodeRef);
                    log.debug("Excel file version: {}", (Object)excelAclFileVersion);
                    boolean isXlsx = ExcelAclNodesPolicy.this.excelAclPath.toLowerCase().endsWith("xlsx");
                    InputStream is = ExcelAclNodesPolicy.this.alfrescoUtils.getContentStream(ExcelAclNodesPolicy.this.excelAclNodeRef);
                    List<GroupPathPermission> acls = AclExcelReader.readAclsFromStream(is, isXlsx);
                    ExcelAclNodesPolicy.this.permissionService.setAcls(acls);
                    log.info("ACLs from Excel file '{}' successfully read (version={})", (Object)ExcelAclNodesPolicy.this.excelAclPath, (Object)excelAclFileVersion);
                }
                catch (Exception e) {
                    String msg = String.format("cannot read ACLs from excel file '%1$s' (ver. %2$s)", ExcelAclNodesPolicy.this.excelAclPath, excelAclFileVersion);
                    log.error(msg, (Throwable)e);
                }
                return null;
            }
        });
    }

    private void setPermissionServiceProperties() {
        if (this.permissionService == null) {
            log.error("cannot set permission service properties - service no specified");
            return;
        }
        try {
            this.setAcls();
            this.permissionService.setDefaultPermissionService(this.useDefaultPermissionService);
            this.permissionService.setRootPaths(this.rootPaths);
            this.permissionService.setAdminGroups(this.adminGroups);
            this.permissionService.setReadPermsions(this.readPermsions);
        }
        catch (Exception e) {
            log.error("cannot set permmission service proeprties", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectExcelAclFileUpdated(NodeRef nodeRef) {
        Object object = this.excelAclSyncObj;
        synchronized (object) {
            boolean exists = this.alfrescoUtils.nodeExistsBySystem(nodeRef);
            if (!exists) {
                return;
            }
            String path = this.alfrescoUtils.getReadablePath(nodeRef);
            if (path.equals(this.excelAclPath)) {
                this.excelAclNodeRef = nodeRef;
                log.debug("ACL excel file created or modified ('{}') -> reloading", (Object)this.excelAclPath);
                this.setAcls();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectExcelAclFileMoved() {
        Object object = this.excelAclSyncObj;
        synchronized (object) {
            if (this.excelAclPath == null) {
                return;
            }
            NodeRef _excelAclNodeRef = this.alfrescoUtils.getNodeByPathBySystem(this.excelAclPath);
            if (this.excelAclNodeRef == null && _excelAclNodeRef != null) {
                log.info("ACL excel file moved into expected folder '{}' -> enabling", (Object)this.excelAclPath);
                this.excelAclNodeRef = _excelAclNodeRef;
                this.setAcls();
            } else if (this.excelAclNodeRef != null && _excelAclNodeRef == null) {
                log.info("ACL excel file moved away from expected folder '{}' -> disabling", (Object)this.excelAclPath);
                this.excelAclNodeRef = null;
                this.setAcls();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectExcelAclFileDeleted() {
        Object object = this.excelAclSyncObj;
        synchronized (object) {
            if (this.excelAclNodeRef == null) {
                return;
            }
            NodeRef _excelAclNodeRef = this.alfrescoUtils.getNodeByPathBySystem(this.excelAclPath);
            if (_excelAclNodeRef != null) {
                return;
            }
            this.excelAclNodeRef = null;
            log.info("ACL excel file has been deleted ('{}') -> disabling", (Object)this.excelAclPath);
            this.setAcls();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectExcelAclFileRestored() {
        Object object = this.excelAclSyncObj;
        synchronized (object) {
            if (this.excelAclPath == null || this.excelAclNodeRef != null) {
                return;
            }
            NodeRef _excelAclNodeRef = this.alfrescoUtils.getNodeByPathBySystem(this.excelAclPath);
            if (_excelAclNodeRef != null) {
                this.excelAclNodeRef = _excelAclNodeRef;
                log.info("ACL excel file has been restored ('{}') -> enabling", (Object)this.excelAclPath);
                this.setAcls();
            }
        }
    }

    private void setRootPaths(String paths) {
        String[] items;
        this.rootPaths = new HashSet<String>();
        if (paths == null) {
            return;
        }
        for (String path : items = paths.split("\\|")) {
            if (path == null || "".equals(path)) continue;
            if (!(path = path.trim()).startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.rootPaths.add(path);
        }
    }

    private Set<String> string2Set(String str) {
        String[] items;
        HashSet<String> result = new HashSet<String>();
        if (str == null) {
            return result;
        }
        for (String item : items = str.split("\\|")) {
            if ("".equals(item = item.trim())) continue;
            result.add(item);
        }
        return result;
    }
}

