/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.repository.behaviours;

import cz.ryant.alfresco.repository.acls.PathRelator;
import cz.ryant.alfresco.repository.behaviours.AbstractPolicy;
import cz.ryant.alfresco.repository.utils.AlfrescoUtils;
import cz.ryant.alfresco.utils.configurator.Configuration;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveVersionsPolicy
extends AbstractPolicy
implements VersionServicePolicies.AfterCreateVersionPolicy {
    private static final Logger log = LoggerFactory.getLogger(RemoveVersionsPolicy.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String REMOVE_VERSIONS_ACTIVE_PROP = "remove-versions.active";
    private static final String REMOVE_VERSIONS_MIN_RELEASES_PROP = "remove-versions.min.releases";
    private static final String PATHS_PROP = "remove-versions.paths";
    private static final String REMOVE_VERSIONS_INTERVAL_PROP = "remove-versions.interval";
    private static final int REMOVE_VERSIONS_MIN_RELEASES_DEFAULT = 300;
    private static final int REMOVE_VERSIONS_INTERVAL_DEFAULT = 604800000;
    private int removeVersionsMinReleases = 300;
    private int removeVersionsInterval = 604800000;
    private String[] paths;

    public RemoveVersionsPolicy(Configuration configuration, PolicyComponent policyComponent, AlfrescoUtils alfrescoUtils) {
        super(configuration, policyComponent, alfrescoUtils);
    }

    @Override
    protected void processProperties(Properties properties) {
        this.isActive = Boolean.parseBoolean(properties.getProperty(REMOVE_VERSIONS_ACTIVE_PROP, "false"));
        this.removeVersionsMinReleases = Integer.parseInt(properties.getProperty(REMOVE_VERSIONS_MIN_RELEASES_PROP, Integer.toString(300)));
        this.removeVersionsInterval = Integer.parseInt(properties.getProperty(REMOVE_VERSIONS_INTERVAL_PROP, Integer.toString(604800000)));
        this.paths = RemoveVersionsPolicy.getPaths(properties.getProperty(PATHS_PROP, null));
        log.info("New properties:\n\tisActive:                  {}\n\tremoveVersionsMinReleases: {}\n\tremoveVersionsInterval:    {}\n\tpaths                      {}", new Object[]{this.isActive, this.removeVersionsMinReleases, this.removeVersionsInterval, this.paths});
    }

    @Override
    protected void bindBehaviours() {
        JavaBehaviour afterCreateVersionBehaviour = new JavaBehaviour((Object)this, "afterCreateVersion", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
        this.bindBehaviour((Behaviour)afterCreateVersionBehaviour, "afterCreateVersion", ContentModel.TYPE_CONTENT);
    }

    public void afterCreateVersion(final NodeRef versionableNode, final Version version) {
        boolean exists = this.alfrescoUtils.nodeExists(versionableNode);
        if (!exists) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("afterCreateVersion({}, {})", (Object)versionableNode, (Object)version);
        }
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                RemoveVersionsPolicy.this.removeVersions(versionableNode, version);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeVersions(NodeRef nodeRef, Version version) {
        String readablePath = "??";
        try {
            readablePath = this.alfrescoUtils.getReadablePath(nodeRef);
            if (!this.isDocumentRemovable(readablePath)) {
                return;
            }
            VersionHistory vh = this.alfrescoUtils.getVersionService().getVersionHistory(nodeRef);
            if (vh == null) {
                log.debug("node '{}' does not have version history", (Object)readablePath);
                return;
            }
            ArrayList versions = new ArrayList(vh.getAllVersions());
            if (versions.size() <= this.removeVersionsMinReleases) {
                log.debug("no versions to remove ({}<={}, path={})", new Object[]{versions.size(), this.removeVersionsMinReleases, readablePath});
                return;
            }
            long lastRoundedTime = -1L;
            for (int i = this.removeVersionsMinReleases; i < versions.size(); ++i) {
                Version ver = (Version)versions.get(i);
                String created = sdf.format(ver.getFrozenModifiedDate().getTime());
                if (ver.getVersionLabel().equals(version.getVersionLabel())) continue;
                long roundedTime = ver.getFrozenModifiedDate().getTime() / (long)this.removeVersionsInterval * (long)this.removeVersionsInterval;
                if (lastRoundedTime == roundedTime) {
                    log.debug("version {} will be removed (created={}, path={})", new Object[]{ver.getVersionLabel(), created, readablePath});
                    this.alfrescoUtils.getVersionService().deleteVersion(nodeRef, ver);
                    log.debug("version {} successfully removed (created={}, path={})", new Object[]{ver.getVersionLabel(), created, readablePath});
                } else {
                    log.debug("version {} won't be removed (created={}, path={})", new Object[]{ver.getVersionLabel(), created, readablePath});
                }
                lastRoundedTime = roundedTime;
            }
        }
        catch (Exception e) {
            String msg = String.format("error when removing versions (path=%1$s)", readablePath);
            log.error(msg, (Throwable)e);
        }
        finally {
            log.trace("afterCreateVersion()):void");
        }
    }

    private boolean isDocumentRemovable(String docPath) {
        if (this.paths == null) {
            log.debug("'paths' property is not specified");
            return false;
        }
        for (String path : this.paths) {
            PathRelator.PathRelation relation = PathRelator.relate(docPath, path);
            if (relation != PathRelator.PathRelation.SUB_PATH) continue;
            return true;
        }
        log.trace("document '{}' not found in removable path", (Object)docPath);
        return false;
    }

    private static String[] getPaths(String paths) {
        if (paths == null) {
            return null;
        }
        String[] result = paths.split("\\|");
        for (int i = 0; i < result.length; ++i) {
            String path = result[i].trim();
            if (path == null || "".equals(path)) continue;
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            result[i] = path;
        }
        return result;
    }
}

