/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.repository.poi;

import cz.ryant.alfresco.repository.acls.GroupPathPermission;
import cz.ryant.alfresco.repository.acls.PathRelator;
import cz.ryant.alfresco.repository.acls.PermissionType;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclExcelReader {
    private static Logger log = LoggerFactory.getLogger(AclExcelReader.class);

    public static List<GroupPathPermission> readAclsFromStream(InputStream is, boolean isXlsx) throws Exception {
        log.debug("reading acl groups from input stream");
        ArrayList<GroupPathPermission> result = new ArrayList<GroupPathPermission>();
        try {
            XSSFWorkbook workbook = isXlsx ? new XSSFWorkbook(is) : new HSSFWorkbook(is);
            boolean readGroups = AclExcelReader.readAclsFromSheet(result, "Groups", (Workbook)workbook, "GROUP_");
            boolean readUsers = AclExcelReader.readAclsFromSheet(result, "Users", (Workbook)workbook, "");
            if (!(readGroups || readUsers || (readGroups = AclExcelReader.readAclsFromSheet(result, null, (Workbook)workbook, "GROUP_")))) {
                throw new Exception("cannot read ACLs from sheet (no sheet defined)");
            }
            if (log.isDebugEnabled()) {
                log.debug("acl groups and path successfully read from stream:\n{}", result);
            }
        }
        catch (Exception e) {
            log.error("cannot read ACLs from stream", (Throwable)e);
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return result;
    }

    public static List<GroupPathPermission> readAclsFromFile(String filePath) throws Exception {
        log.debug("reading acl groups from file '{}'", (Object)filePath);
        ArrayList<GroupPathPermission> result = new ArrayList();
        try {
            FileInputStream fis = new FileInputStream(filePath);
            result = AclExcelReader.readAclsFromStream(fis, filePath.toLowerCase().endsWith("xlsx"));
            if (log.isDebugEnabled()) {
                log.debug("acl groups and path successfully read from file {}:\n{}", (Object)filePath, result);
            }
        }
        catch (Exception e) {
            String msg = String.format("cannot read ACLs from excel file '$1%'", filePath);
            log.error(msg, (Throwable)e);
            throw e;
        }
        return result;
    }

    private static boolean readAclsFromSheet(List<GroupPathPermission> list, String sheetName, Workbook workbook, String groupPrefix) throws Exception {
        Sheet sheet;
        Sheet sheet2 = sheet = sheetName == null ? workbook.getSheetAt(0) : workbook.getSheet(sheetName);
        if (sheet == null) {
            log.info("sheet '{}' is not defined", (Object)sheetName);
            return false;
        }
        Iterator rowIterator = sheet.iterator();
        while (rowIterator.hasNext()) {
            String group = groupPrefix;
            int colNum = 0;
            Row row = (Row)rowIterator.next();
            Iterator cellIterator = row.cellIterator();
            while (cellIterator.hasNext()) {
                ++colNum;
                Cell cell = (Cell)cellIterator.next();
                if (cell.getCellType() != 1) continue;
                String cellValue = cell.getStringCellValue().trim();
                if (colNum == 1) {
                    group = group + cellValue;
                    continue;
                }
                if (groupPrefix.equals(group) || !StringUtils.isNotEmpty((String)group) || !StringUtils.isNotEmpty((String)cellValue)) continue;
                cell = (Cell)cellIterator.next();
                String path = cell.getStringCellValue().trim();
                GroupPathPermission gpp = new GroupPathPermission(group, path, PermissionType.parse(cellValue));
                AclExcelReader.normalizeAndAdd(list, gpp);
                ++colNum;
            }
        }
        return true;
    }

    private static void normalizeAndAdd(List<GroupPathPermission> list, GroupPathPermission newRecord) {
        for (GroupPathPermission gpp : list) {
            PathRelator.PathRelation rel = newRecord.relate(gpp);
            switch (rel) {
                case IDENTICAL: {
                    log.warn("normalization: found duplicit triple {}", (Object)newRecord);
                    return;
                }
                case DIFFERENT: {
                    break;
                }
                case SUPER_PATH: {
                    log.warn("normalization: triple {} already composed in {} -> ignoring", (Object)gpp, (Object)newRecord);
                    gpp.setPath(newRecord.getPath());
                    return;
                }
                case SUB_PATH: {
                    log.warn("normalization: triple {} already composed in {} -> ignoring", (Object)newRecord, (Object)gpp);
                    return;
                }
            }
        }
        list.add(newRecord);
    }
}

