/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.repository.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoUtils {
    private static Logger log = LoggerFactory.getLogger(AlfrescoUtils.class);
    private NodeRef companyHomeRef;
    protected final ContentService contentService;
    protected final FileFolderService fileFolderService;
    protected final NamespaceService namespaceService;
    protected final NodeService nodeService;
    protected final PermissionService permissionService;
    protected final SearchService searchService;
    protected final TransactionService transactionService;
    protected final VersionService versionService;
    protected ServiceRegistry serviceRegistry;
    protected final Repository repository;
    public static final String COMPANY_HOME = "company_home";
    public static final String COMPANY_HOME_PATH = "/company_home";
    private Map<String, String> companyHomeFolders;

    public AlfrescoUtils(ServiceRegistry serviceRegistry, Repository repository) {
        this.contentService = serviceRegistry.getContentService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.namespaceService = serviceRegistry.getNamespaceService();
        this.nodeService = serviceRegistry.getNodeService();
        this.permissionService = serviceRegistry.getPermissionService();
        this.searchService = serviceRegistry.getSearchService();
        this.transactionService = serviceRegistry.getTransactionService();
        this.versionService = serviceRegistry.getVersionService();
        this.serviceRegistry = serviceRegistry;
        this.repository = repository;
        try {
            this.init();
        }
        catch (Exception e) {
            log.error("cannot initialize AlfrescoUtils instance", (Throwable)e);
        }
    }

    private void init() {
        this.companyHomeRef = this.repository.getCompanyHome();
        this.createCompanyHomeFoldersHash();
    }

    private void createCompanyHomeFoldersHash() {
        this.companyHomeFolders = new HashMap<String, String>();
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                try {
                    List children = AlfrescoUtils.this.nodeService.getChildAssocs(AlfrescoUtils.this.repository.getCompanyHome(), (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                    for (ChildAssociationRef child : children) {
                        String assocName = child.getQName().getLocalName();
                        String nodeName = (String)((Object)AlfrescoUtils.this.nodeService.getProperty(child.getChildRef(), ContentModel.PROP_NAME));
                        AlfrescoUtils.this.companyHomeFolders.put(assocName, nodeName);
                    }
                }
                catch (Exception e) {
                    log.error("cannot create COMPANY HOME folders mapping: {}", (Object)e.getMessage());
                }
                return null;
            }
        });
        if (log.isTraceEnabled()) {
            log.trace("COMPANY HOME folders mapping: {}", this.companyHomeFolders);
        }
    }

    private String getCompanyHomeFolder(String assocName) {
        String nodeName = this.companyHomeFolders.get(assocName);
        return nodeName == null ? assocName : nodeName;
    }

    public NodeRef getCompanyHome() {
        return this.companyHomeRef;
    }

    public String getReadablePath(NodeRef nodeRef) {
        if (nodeRef == null) {
            return null;
        }
        try {
            Path path = this.nodeService.getPath(nodeRef);
            String readablePath = PathUtil.getDisplayPath((Path)path, (boolean)true);
            return readablePath;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getReadablePathBySystem(final NodeRef nodeRef) {
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return this.getReadablePath(nodeRef);
        }
        Object result = AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                return AlfrescoUtils.this.getReadablePath(nodeRef);
            }
        });
        return (String)result;
    }

    public NodeRef getNodeByPathBySystem(final String path) {
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return this.getNodeByPath(path);
        }
        Object result = AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                return AlfrescoUtils.this.getNodeByPath(path);
            }
        });
        return (NodeRef)result;
    }

    public final NodeRef getNodeByPath(String path) {
        log.trace("getting node for path '{}'", (Object)path);
        long start = System.nanoTime();
        if (path == null) {
            return null;
        }
        path = path.toLowerCase();
        NodeRef nodeRef = this.repository.getCompanyHome();
        String cleanTargetPath = path.replaceAll("/+", "/");
        if (cleanTargetPath.startsWith("/")) {
            cleanTargetPath = cleanTargetPath.substring(1);
        }
        if (cleanTargetPath.startsWith(COMPANY_HOME)) {
            cleanTargetPath = cleanTargetPath.substring(COMPANY_HOME.length());
        }
        if (cleanTargetPath.endsWith("/")) {
            cleanTargetPath = cleanTargetPath.substring(0, cleanTargetPath.length() - 1);
        }
        if (cleanTargetPath.startsWith("/")) {
            cleanTargetPath = cleanTargetPath.substring(1);
        }
        if (cleanTargetPath.length() == 0) {
            return nodeRef;
        }
        String[] assocNames = cleanTargetPath.split("/");
        try {
            assocNames[0] = this.getCompanyHomeFolder(assocNames[0]);
            nodeRef = this.fileFolderService.resolveNamePath(this.repository.getCompanyHome(), Arrays.asList(assocNames)).getNodeRef();
        }
        catch (FileNotFoundException fnfe) {
            nodeRef = null;
        }
        if (log.isTraceEnabled()) {
            long end = System.nanoTime();
            if (nodeRef == null) {
                log.trace("no node found for path '{}' ({} secs)", (Object)path, (Object)String.format("%.4f", Float.valueOf((float)(end - start) / 1.0E9f)));
            } else {
                log.trace("node found for path '{}' -> {} ({} secs)", new Object[]{path, nodeRef, String.format("%.4f", Float.valueOf((float)(end - start) / 1.0E9f))});
            }
        }
        return nodeRef;
    }

    public long getCountOfSubnodes(NodeRef nodeRef, QName type) {
        if (log.isDebugEnabled()) {
            log.debug("getting count of subnodes of type '{}' of node '{}'", (Object)type, (Object)this.getReadablePath(nodeRef));
        }
        Path path = this.nodeService.getPath(nodeRef);
        String prefixPath = path.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String query = String.format("PATH:\"%1$s//.\" AND TYPE:\"%2$s\"", prefixPath, type);
        SearchParameters sp = new SearchParameters();
        sp.addStore(nodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery(query);
        sp.setLimitBy(LimitBy.UNLIMITED);
        ResultSet results = this.searchService.query(sp);
        long count = results.getNumberFound();
        if (log.isDebugEnabled()) {
            log.debug("node '{}' has {} of type '{}'", new Object[]{this.getReadablePath(nodeRef), count, type});
        }
        return count;
    }

    public InputStream getContentStream(NodeRef nodeRef) {
        log.debug("getting input stream for node '{}'", (Object)nodeRef);
        ContentReader cr = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        return cr.getContentInputStream();
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public FileFolderService getFileFolderService() {
        return this.fileFolderService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public VersionService getVersionService() {
        return this.versionService;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getCurrentVersion(NodeRef nodeRef) {
        try {
            return this.versionService.getCurrentVersion(nodeRef).getVersionLabel();
        }
        catch (Exception e) {
            return "n/a";
        }
    }

    public boolean nodeExists(NodeRef nodeRef) {
        return this.nodeService.exists(nodeRef);
    }

    public boolean nodeExistsBySystem(final NodeRef nodeRef) {
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return this.nodeExists(nodeRef);
        }
        Object result = AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                return AlfrescoUtils.this.nodeExists(nodeRef);
            }
        });
        return (Boolean)result;
    }

    public String getCorrectedPath(String path) {
        try {
            log.trace("performing path correction: {}", (Object)path);
            NodeRef nodeRef = this.getNodeByPathBySystem(path);
            String result = this.getReadablePathBySystem(nodeRef);
            log.debug("trace correction: {} => {}", (Object)path, (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error("cannot perform root path correction", (Throwable)e);
            return path;
        }
    }

    public List<NodeRef> getNodeChildren(NodeRef parent, QName type) {
        HashSet<QName> types = new HashSet<QName>();
        types.add(type);
        ArrayList<NodeRef> result = new ArrayList<NodeRef>();
        for (ChildAssociationRef childAssoc : this.nodeService.getChildAssocs(parent, types)) {
            result.add(childAssoc.getChildRef());
        }
        return result;
    }

    public NodeRef getParentNode(NodeRef nodeRef) {
        NodeRef parent = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        if (log.isTraceEnabled()) {
            log.debug("got parent node '{}' of node '{}'", (Object)this.getReadablePath(parent), (Object)this.getReadablePath(nodeRef));
        }
        return parent;
    }

    public <T> T getParentAspectProperty(NodeRef nodeRef, QName aspect, QName property) {
        boolean hasAspect = this.getNodeService().hasAspect(nodeRef, aspect);
        if (hasAspect) {
            return (T)this.getNodeService().getProperty(nodeRef, property);
        }
        if (nodeRef.equals((Object)this.companyHomeRef)) {
            return null;
        }
        NodeRef parentNodeRef = this.getNodeService().getPrimaryParent(nodeRef).getParentRef();
        return this.getParentAspectProperty(parentNodeRef, aspect, property);
    }
}

