/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.services;

import cz.ryant.alfresco.utils.configurator.Configuration;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedEvent;
import cz.ryant.alfresco.utils.configurator.ConfigurationChangedListener;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.alfresco.repo.lock.LockUtils;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.UnableToAquireLockException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.ConcurrencyFailureException;

public class LockStoreImpl
extends org.alfresco.repo.lock.mem.LockStoreImpl
implements ConfigurationChangedListener {
    private static final Logger log = LoggerFactory.getLogger(LockStoreImpl.class);
    private Configuration configuration;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        if (this.configuration != null) {
            this.configuration.addListener((ConfigurationChangedListener)this);
            this.processConfiguration(this.configuration.getProperties());
        }
    }

    public void set(NodeRef nodeRef, LockState lockState, boolean force) {
        if (log.isDebugEnabled()) {
            log.debug("setting lock state (nodeRef={}, state={}, force={})", new Object[]{nodeRef, lockState, force});
        }
        Map txMap = this.getTxMap();
        LockState previousLockState = null;
        previousLockState = txMap != null ? (txMap.containsKey(nodeRef) ? (LockState)txMap.get(nodeRef) : this.get(nodeRef)) : this.get(nodeRef);
        boolean updated = false;
        if (previousLockState != null) {
            String userName = AuthenticationUtil.getFullyAuthenticatedUser();
            String owner = previousLockState.getOwner();
            Date expires = previousLockState.getExpires();
            if (!force && LockUtils.lockStatus((String)userName, (String)owner, (Date)expires) == LockStatus.LOCKED) {
                throw new UnableToAquireLockException(nodeRef);
            }
            updated = this.map.replace(nodeRef, previousLockState, lockState);
        } else if (this.map.putIfAbsent(nodeRef, lockState) == null) {
            updated = true;
        }
        if (!updated) {
            String msg = String.format("Attempt to update lock state failed, old=%s, new=%s, noderef=%s", previousLockState, lockState, nodeRef);
            throw new ConcurrencyFailureException(msg);
        }
        if (txMap != null) {
            txMap.put(nodeRef, lockState);
        }
        log.debug("lock state set (nodeRef={}, state={}, force={}, updated={})", new Object[]{nodeRef, lockState, force, updated});
    }

    public void handleConfigurationChange(ConfigurationChangedEvent e) {
        this.processConfiguration(e.getProperties());
    }

    private void processConfiguration(Properties properties) {
    }
}

