/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.services.webscript;

import cz.ryant.alfresco.repository.utils.AlfrescoUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class PersonsWebScript
extends DeclarativeWebScript {
    private static final Logger log = LoggerFactory.getLogger(PersonsWebScript.class);
    private static final String PARAMETER_ACTION = "action";
    private static final String PARAMETER_USER_NAME = "userName";
    private static final String PARAMETER_PROP_NAME = "propName";
    private static final String PARAMETER_VALUE = "value";
    private static final String PARAMETER_TYPE = "type";
    private static final String ACTION_GET_USER_PROPS = "getUserProperties";
    private static final String ACTION_SET_USER_PROP = "setUserProperty";
    private static final String ACTION_REMOVE_USER_PROP = "removeUserProperty";
    private static final String VALUE_TYPE_STRING = "string";
    private static final String VALUE_TYPE_INT = "int";
    private static final String VALUE_TYPE_LONG = "long";
    private static final String VALUE_TYPE_BOOL = "bool";
    private final NodeService nodeService;
    private final PersonService personService;
    private final NamespaceService namespaceService;
    private AlfrescoUtils alfrescoUtils;

    public PersonsWebScript(ServiceRegistry serviceRegistry) {
        assert (serviceRegistry != null) : "serviceRegistry must not be null.";
        this.nodeService = serviceRegistry.getNodeService();
        this.personService = serviceRegistry.getPersonService();
        this.namespaceService = serviceRegistry.getNamespaceService();
        log.debug("PersonsWebScript initialized");
    }

    public void setAlfrescoUtils(AlfrescoUtils alfrescoUtils) {
        this.alfrescoUtils = alfrescoUtils;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest request, Status status, Cache cache) {
        String userName = request.getParameter(PARAMETER_USER_NAME);
        String action = request.getParameter(PARAMETER_ACTION);
        String propName = request.getParameter(PARAMETER_PROP_NAME);
        String value = request.getParameter(PARAMETER_VALUE);
        String type = request.getParameter(PARAMETER_TYPE);
        log.debug("performing Persons web script (action={}, userName={}))", new Object[]{action, userName});
        Map<String, Object> result = this.process(action, userName, propName, value, type);
        return result;
    }

    private Map<String, Object> process(String action, String userName, String propName, String value, String type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> map = null;
        boolean success = false;
        if (ACTION_GET_USER_PROPS.equals(action)) {
            map = this.processUserProperties(userName);
            success = true;
        } else if (ACTION_SET_USER_PROP.equals(action)) {
            success = this.setUserProperty(userName, propName, value, type);
            map = this.processUserProperties(userName);
        } else if (ACTION_REMOVE_USER_PROP.equals(action)) {
            success = this.removeUserPropert(userName, propName);
            map = this.processUserProperties(userName);
        } else {
            log.warn("not supported action (action={})", (Object)action);
        }
        result.put(PARAMETER_ACTION, action);
        result.put("success", success);
        result.put("result", map);
        return result;
    }

    private Map<String, Object> processUserProperties(String userName) {
        log.debug("processing get user properties request (userName={})", (Object)userName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        NodeRef personNodeRef = this.getPersonNodeRef(userName);
        if (personNodeRef == null) {
            return result;
        }
        Map props = this.nodeService.getProperties(personNodeRef);
        for (Map.Entry entry : props.entrySet()) {
            QName qName = ((QName)entry.getKey()).getPrefixedQName((NamespacePrefixResolver)this.namespaceService);
            result.put(qName.getPrefixString(), entry.getValue());
        }
        log.debug("got {} user properties (userName={})", (Object)props.size(), (Object)userName);
        return result;
    }

    private boolean setUserProperty(String userName, String propName, String value, String type) {
        log.debug("setting property for user (userName={}, propName={}, value={}, type={})", new Object[]{userName, propName, value, type});
        NodeRef personNodeRef = this.getPersonNodeRef(userName);
        if (personNodeRef == null) {
            return false;
        }
        try {
            QName qName = QName.createQName((String)propName, (NamespacePrefixResolver)this.namespaceService);
            Serializable serializable = this.valueToSerializable(value, type);
            this.nodeService.setProperty(personNodeRef, qName, serializable);
            log.debug("property for user has been set (userName={}, propName={}, value={}, type={})", new Object[]{userName, propName, value, type});
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean removeUserPropert(String userName, String propName) {
        log.debug("removing property for user (userName={}, propName={})", new Object[]{userName, propName});
        NodeRef personNodeRef = this.getPersonNodeRef(userName);
        if (personNodeRef == null) {
            return false;
        }
        try {
            QName qName = QName.createQName((String)propName, (NamespacePrefixResolver)this.namespaceService);
            this.nodeService.removeProperty(personNodeRef, qName);
            log.debug("property for user has been removed (userName={}, propName={})", new Object[]{userName, propName});
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Serializable valueToSerializable(String value, String type) throws Exception {
        if (VALUE_TYPE_BOOL.equals(type)) {
            return Boolean.valueOf(Boolean.parseBoolean(value));
        }
        if (VALUE_TYPE_INT.equals(type)) {
            return Integer.valueOf(Integer.parseInt(value));
        }
        if (VALUE_TYPE_LONG.equals(type)) {
            return Long.valueOf(Long.parseLong(value));
        }
        if (VALUE_TYPE_STRING.equals(type) || StringUtils.isEmpty((String)type)) {
            return value;
        }
        throw new Exception(String.format("unsuported type '%1$s'", type));
    }

    private NodeRef getPersonNodeRef(String userName) {
        NodeRef personNodeRef = this.personService.getPersonOrNull(userName);
        log.debug(personNodeRef == null ? "no person found (userName={0})" : "person found (userName={})", (Object)userName);
        return personNodeRef;
    }
}

