/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.synchronization.subsystem.impl;

import cz.ryant.alfresco.synchronization.subsystem.SubSystemSyncState;
import cz.ryant.alfresco.synchronization.subsystem.SubSystemSyncStatus;
import cz.ryant.alfresco.synchronization.subsystem.SubSystemSynchronizer;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubSystemSynchronizerImpl
implements SubSystemSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(SubSystemSynchronizerImpl.class);
    SubSystemSyncStatus status;
    UserRegistrySynchronizer userRegistrySynchronizer;

    public SubSystemSynchronizerImpl(UserRegistrySynchronizer userRegistrySynchronizer) {
        log.debug("creating instance of subsystem synchronizer");
        assert (userRegistrySynchronizer != null) : "userRegistrySynchronizer must be specified";
        this.userRegistrySynchronizer = userRegistrySynchronizer;
        this.status = new SubSystemSyncStatus();
    }

    @Override
    public SubSystemSyncStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(boolean fullSync) {
        this.status.setState(SubSystemSyncState.IN_PROCESS);
        this.status.setStart(System.nanoTime());
        log.info("running subsystem synchronization (fullSync={})", (Object)fullSync);
        try {
            this.userRegistrySynchronizer.synchronize(fullSync, true, true);
            this.status.setEnd(System.nanoTime());
            float duration = (float)this.status.getDuration() / 1.0E9f;
            String time = String.format("%.4f", Float.valueOf(duration));
            log.info("subsystem synchronization done in (fullSync={}, time={})", new Object[]{fullSync, time});
        }
        catch (Throwable t) {
            log.error("cannot perform subsystem synchronization", t);
        }
        finally {
            this.status.setState(SubSystemSyncState.DONE);
        }
    }
}

