/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.synchronization.subsystem.webscripts;

import cz.ryant.alfresco.synchronization.subsystem.SubSystemSynchronizer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class SyncUIWebScript
extends DeclarativeWebScript {
    private static final Logger log = LoggerFactory.getLogger(SyncUIWebScript.class);
    public static final String WEB_SCRIPT_URI_SUBSYSTEM_SYNC_STATUS = "/solnet/subsystem/synchronization/status";
    private SubSystemSynchronizer synchronizer;

    public SyncUIWebScript(SubSystemSynchronizer synchronizer) {
        assert (synchronizer != null) : "synchronizer must be specified";
        this.synchronizer = synchronizer;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest request, Status status, Cache cache) {
        log.debug("performing Subsystem Synchronization UI web script (status={})", (Object)this.synchronizer.getStatus());
        cache.setNeverCache(true);
        if (this.synchronizer.getStatus().inProcess()) {
            String url = request.getServiceContextPath() + WEB_SCRIPT_URI_SUBSYSTEM_SYNC_STATUS;
            log.debug("redirecting to: ", (Object)url);
            status.setCode(302);
            status.setRedirect(true);
            status.setLocation(url);
        }
        Map<String, Object> result = null;
        log.debug("Subsystem Synchronization UI web script performed (status={}, result={})", (Object)this.synchronizer.getStatus(), result);
        return result;
    }
}

