/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.synchronization.subsystem.webscripts;

import cz.ryant.alfresco.synchronization.subsystem.SubSystemSynchronizer;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class SyncWebScript
extends DeclarativeWebScript {
    private static final Logger log = LoggerFactory.getLogger(SyncWebScript.class);
    private static final String PARAMETER_FULL_SYNC = "fullSync";
    private static final String PARAMETER_VALUE_TRUE = "true";
    boolean performFullSync;
    private SubSystemSynchronizer synchronizer;

    public SyncWebScript(SubSystemSynchronizer synchronizer) {
        assert (synchronizer != null) : "synchronizer must be specified";
        this.synchronizer = synchronizer;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest request, Status status, Cache cache) {
        log.debug("performing Subsystem Synchronization web script (status={})", (Object)this.synchronizer.getStatus());
        if (!this.synchronizer.getStatus().inProcess()) {
            this.startSynchronization(request);
        }
        String url = request.getServiceContextPath() + "/solnet/subsystem/synchronization/status";
        log.debug("redirecting to: ", (Object)url);
        status.setCode(302);
        status.setRedirect(true);
        status.setLocation(url);
        Map<String, Object> result = null;
        log.debug("Subsystem Synchronization web script performed (status={}, result={})", (Object)this.synchronizer.getStatus(), result);
        return result;
    }

    private void startSynchronization(WebScriptRequest request) {
        String performFullSyncStr = request.getParameter(PARAMETER_FULL_SYNC);
        this.performFullSync = false;
        if (StringUtils.isNotEmpty((String)performFullSyncStr)) {
            this.performFullSync = PARAMETER_VALUE_TRUE.equals(performFullSyncStr.toLowerCase());
        }
        Runnable backgroundLogic = new Runnable(){

            @Override
            public void run() {
                SyncWebScript.this.synchronizer.synchronize(SyncWebScript.this.performFullSync);
            }
        };
        log.debug("starting subsystem synchronization in new thread");
        Thread backgroundThread = new Thread(backgroundLogic);
        backgroundThread.start();
    }
}

