/*
 * Decompiled with CFR 0.152.
 */
package cz.ryant.alfresco.unlock.webscript;

import cz.ryant.alfresco.repository.utils.AlfrescoUtils;
import cz.ryant.alfresco.services.LockStoreImpl;
import cz.ryant.alfresco.utils.Commons;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.lock.LockServiceImpl;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.lock.mem.LockableAspectInterceptor;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class UnlockWebScript
extends DeclarativeWebScript {
    private static final Logger log = LoggerFactory.getLogger(UnlockWebScript.class);
    private static final String PARAMETER_NODE_PATH = "nodePath";
    private final ServiceRegistry serviceRegistry;
    private TenantService tenantService;
    private final NodeService nodeService;
    private final LockService lockService;
    private AlfrescoUtils alfrescoUtils;
    private LockableAspectInterceptor lockableAspectInterceptor;
    private BehaviourFilter behaviourFilter;
    private LockStoreImpl lockStore;

    public UnlockWebScript(ServiceRegistry serviceRegistry) {
        assert (serviceRegistry != null) : "serviceRegistry must not be null.";
        this.serviceRegistry = serviceRegistry;
        this.nodeService = serviceRegistry.getNodeService();
        this.lockService = serviceRegistry.getLockService();
        log.debug("UnlockWebScript initialized");
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setAlfrescoUtils(AlfrescoUtils alfrescoUtils) {
        this.alfrescoUtils = alfrescoUtils;
    }

    public void setLockableAspectInterceptor(LockableAspectInterceptor lockableAspectInterceptor) {
        this.lockableAspectInterceptor = lockableAspectInterceptor;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setLockStore(LockStoreImpl lockStore) {
        this.lockStore = lockStore;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest request, Status status, Cache cache) {
        final String nodePath = request.getParameter(PARAMETER_NODE_PATH);
        log.debug("performing Unlock node web script (path={}))", (Object)nodePath);
        if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return this.unlockNode(nodePath);
        }
        Object result = AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                return UnlockWebScript.this.unlockNode(nodePath);
            }
        });
        return (Map)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(NodeRef nodeRef, LockState lockState) throws UnableToReleaseLockException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException, NoSuchMethodException, SecurityException {
        block5: {
            Lifetime lifetime;
            block6: {
                block4: {
                    nodeRef = this.tenantService.getName(nodeRef);
                    if (!lockState.isLockInfo()) break block5;
                    lifetime = lockState.getLifetime();
                    if (lifetime != Lifetime.PERSISTENT) break block6;
                    Commons.invokePrivateMethod(LockServiceImpl.class, (String)"addToIgnoreSet", (Object[])new Object[]{nodeRef});
                    this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                    this.lockableAspectInterceptor.disableForThread();
                    try {
                        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) break block4;
                        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_LOCKABLE);
                    }
                    catch (Throwable throwable) {
                        this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                        this.lockableAspectInterceptor.enableForThread();
                        Commons.invokePrivateMethod(LockServiceImpl.class, (String)"removeFromIgnoreSet", (Object[])new Object[]{nodeRef});
                        throw throwable;
                    }
                }
                this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                this.lockableAspectInterceptor.enableForThread();
                Commons.invokePrivateMethod(LockServiceImpl.class, (String)"removeFromIgnoreSet", (Object[])new Object[]{nodeRef});
                break block5;
            }
            if (lifetime == Lifetime.EPHEMERAL) {
                this.lockStore.set(nodeRef, LockState.createUnlocked((NodeRef)nodeRef), true);
            } else {
                throw new IllegalStateException("Unhandled Lifetime value: " + lifetime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> unlockNode(String path) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String result = "n/a";
        try {
            boolean exist = false;
            NodeRef nodeRef = this.alfrescoUtils.getNodeByPath(path);
            if (nodeRef != null) {
                exist = this.nodeService.exists(nodeRef);
            }
            if (exist) {
                LockState lockState = this.lockService.getLockState(nodeRef);
                if (lockState == null) {
                    log.debug("cannot unlock node, node has no lockstate (nodeRef={})", (Object)nodeRef);
                    result = "noLockState";
                } else {
                    LockType lockType = lockState.getLockType();
                    if (lockType != null) {
                        CheckOutCheckInService checkOutCheckInService = this.serviceRegistry.getCheckOutCheckInService();
                        boolean checkedOut = checkOutCheckInService.isCheckedOut(nodeRef);
                        if (checkedOut) {
                            log.debug("node is checked out -> unchecking (nodeRef={0})", (Object)nodeRef);
                            checkOutCheckInService.cancelCheckout(nodeRef);
                            log.debug("node has been unchecked (nodeRef={0})", (Object)nodeRef);
                        }
                        log.debug("unlocking node (nodeRef={}, lockType={}, lifeTime={}, owner={})", new Object[]{nodeRef, lockType, lockState.getLifetime(), lockState.getOwner()});
                        this.unlock(nodeRef, lockState);
                        log.debug("node unlocked (nodeRef={})", (Object)nodeRef);
                        result = "unlocked";
                    } else {
                        log.debug("cannot unlock node, node is not locked (has no lockType) (nodeRef={})", (Object)nodeRef);
                        result = "notLocked";
                    }
                }
            } else {
                log.warn("node does not exist (path={})", (Object)path);
                result = "nodeNotExists";
            }
            map.put("result", result);
        }
        catch (Throwable t) {
            try {
                log.error(String.format("cannot unlock node '%1$s'", path), t);
                result = "error";
                map.put("detail", t.getMessage());
                map.put("result", result);
            }
            catch (Throwable throwable) {
                map.put("result", result);
                throw throwable;
            }
        }
        return map;
    }
}

