/*
 * Decompiled with CFR 0.152.
 */
package cz.solnet.inchange;

import cz.solnet.inchange.MemCache;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.log4j.Logger;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.DataSourceFactory;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;

public class ConnectionManager {
    static Logger log = Logger.getLogger(ConnectionManager.class);
    private static final HashMap<String, javax.sql.DataSource> mutex = new HashMap();
    String ds_name = null;
    String host_port = null;
    String dbname = null;
    String username = null;
    String password = null;
    Timestamp modify_time = null;
    Timestamp used_time = null;
    String url = null;

    public ConnectionManager(String ds_name, String host_port, String dbname, String username, String password, Timestamp modify_time, Timestamp used_time) {
        this.ds_name = ds_name;
        this.host_port = host_port;
        this.dbname = dbname;
        this.username = username;
        this.password = password;
        this.modify_time = modify_time;
        this.used_time = used_time;
        this.url = "jdbc:postgresql://" + host_port + "/" + dbname;
    }

    public String getDs_name() {
        return this.ds_name;
    }

    public void setDs_name(String ds_name) {
        this.ds_name = ds_name;
    }

    public String getHost_port() {
        return this.host_port;
    }

    public void setHost_port(String host_port) {
        this.host_port = host_port;
    }

    public String getDbname() {
        return this.dbname;
    }

    public void setDbname(String dbname) {
        this.dbname = dbname;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public javax.sql.DataSource getDataSource() throws Exception {
        javax.sql.DataSource ds = null;
        try {
            ds = this.getPoolDataSource();
        }
        catch (Exception e) {
            log.warn((Object)"cannot Reference(..., org.apache.tomcat.jdbc.pool.DataSourceFactory, ...)", (Throwable)e);
            ds = this.getBasicDataSource();
        }
        return ds;
    }

    private javax.sql.DataSource getPoolDataSource() {
        Properties props = new Properties();
        props.setProperty("driverClassName", "org.postgresql.Driver");
        props.setProperty("auth", "Container");
        props.setProperty("url", "jdbc:postgresql://" + this.host_port + "/" + this.dbname);
        props.setProperty("username", this.username);
        props.setProperty("password", this.password);
        props.setProperty("maxActive", "30");
        props.setProperty("maxIdle", "20");
        props.setProperty("minIdle", "10");
        props.setProperty("maxWait", "10000");
        props.setProperty("initialSize", "10");
        props.setProperty("myTS", "-1");
        props.setProperty("testWhileIdle", "true");
        props.setProperty("testOnBorrow", "true");
        props.setProperty("testOnReturn", "false");
        props.setProperty("validationQuery", "SELECT 1");
        props.setProperty("validationInterval", "30000");
        props.setProperty("timeBetweenEvictionRunsMillis", "30000");
        props.setProperty("removeAbandonedTimeout", "60");
        props.setProperty("removeAbandoned", "true");
        props.setProperty("logAbandoned", "true");
        props.setProperty("minEvictableIdleTimeMillis", "30000");
        props.setProperty("jmxEnabled", "true");
        props.setProperty("jdbcInterceptors", "org.apache.tomcat.jdbc.pool.interceptor.ConnectionState;org.apache.tomcat.jdbc.pool.interceptor.StatementFinalizer");
        PoolConfiguration conf = DataSourceFactory.parsePoolProperties((Properties)props);
        DataSource datasource = new DataSource();
        datasource.setPoolProperties(conf);
        return datasource;
    }

    public javax.sql.DataSource getBasicDataSource() throws Exception {
        Properties props = new Properties();
        props.setProperty("driverClassName", "org.postgresql.Driver");
        props.setProperty("auth", "Container");
        props.setProperty("url", "jdbc:postgresql://" + this.host_port + "/" + this.dbname);
        props.setProperty("username", this.username);
        props.setProperty("password", this.password);
        props.setProperty("maxActive", "20");
        props.setProperty("maxIdle", "10");
        props.setProperty("maxWait", "-1");
        props.setProperty("myTS", "-1");
        props.setProperty("removeAbandoned", "true");
        props.setProperty("removeAbandonedTimeout", "233");
        props.setProperty("logAbandoned", "true");
        javax.sql.DataSource ds = BasicDataSourceFactory.createDataSource((Properties)props);
        return ds;
    }

    public boolean isNotChanged() {
        return this.used_time != null && this.modify_time != null && this.used_time.compareTo(this.modify_time) >= 0;
    }

    public String getBinding() {
        return "jdbc/" + this.ds_name + " <=> jdbc:postgresql://" + this.username + "@" + this.host_port + "/" + this.dbname;
    }

    public Connection getConnection() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        boolean isDriver = false;
        try {
            if (DriverManager.getDriver(this.url) != null) {
                isDriver = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isDriver) {
            Driver driver = (Driver)Class.forName("org.postgresql.Driver").newInstance();
            DriverManager.registerDriver(driver);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("call DriverManager.getConnection(" + this.url + ")"));
        }
        Connection con = DriverManager.getConnection(this.url, this.username, this.password);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnectionManager getPsqlConnectionDescription(Connection webis2, String ds_name) throws SQLException, NamingException {
        String host_port = null;
        String dbname = null;
        String username = null;
        String password = null;
        Timestamp modify_time = null;
        Timestamp used_time = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = webis2.prepareStatement("select * from reporting.datasources where ds_name=?");
            pstmt.setString(1, ds_name);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String port;
                modify_time = rs.getTimestamp("modify_time");
                used_time = rs.getTimestamp("used_time");
                String host = rs.getString("host");
                if (host == null) {
                    host = "127.0.0.1";
                }
                if ((port = rs.getString("port")) == null) {
                    port = "5432";
                }
                host_port = host + ":" + port;
                dbname = rs.getString("dbname");
                if (dbname == null) {
                    dbname = ds_name;
                }
                if ((username = rs.getString("username")) == null) {
                    username = "bb";
                }
                password = rs.getString("password");
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
        }
        if (dbname == null) {
            throw new NamingException("Datasource " + ds_name + " cannot be bound no record in ds_name=webis2 in table reporting.datasources");
        }
        return new ConnectionManager(ds_name, host_port, dbname, username, password, modify_time, used_time);
    }

    public static ConnectionManager getConnectionManager(String ds_name) throws SQLException, NamingException {
        ConnectionManager dsc = null;
        if ("webis2".equals(ds_name)) {
            String p_host_port = "localhost";
            String p_dbname = "webis2arec";
            String p_username = "solnet";
            String p_password = "7bakuzyx";
            try {
                String cp = MemCache.class.getProtectionDomain().getCodeSource().getLocation().toString().replace("inchange.jar", "");
                String prop_file = cp + "inchange.properties";
                URL url = new URL(prop_file);
                log.info((Object)("loading fakes from prop file: " + prop_file));
                Properties p = new Properties();
                p.load(new FileInputStream(new File(url.getFile())));
                p_host_port = p.getProperty("ds.host_port");
                p_dbname = p.getProperty("ds.dbname");
                p_username = p.getProperty("ds.username");
                p_password = p.getProperty("ds.password");
            }
            catch (Exception e) {
                log.error((Object)("error: " + e.toString()));
            }
            dsc = new ConnectionManager(ds_name, p_host_port, p_dbname, p_username, p_password, null, null);
        } else {
            Connection webis2 = null;
            try {
                webis2 = ConnectionManager.getConnection("webis2");
                dsc = ConnectionManager.getPsqlConnectionDescription(webis2, ds_name);
            }
            catch (Exception e) {
                throw new NamingException("no webis2 datasource available => " + e.getClass().getName() + " : " + e.getMessage());
            }
            finally {
                try {
                    webis2.close();
                }
                catch (Exception exception) {}
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("call ConnectionManager.getConnectionManager(" + ds_name + ")"));
        }
        return dsc;
    }

    public static Connection getPsqlConnection(String ds_name) throws SQLException, NamingException {
        ConnectionManager dsc = ConnectionManager.getConnectionManager(ds_name);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("call DriverManager.getPsqlConnection(" + ds_name + ")"));
            }
            return dsc.getConnection();
        }
        catch (Exception e) {
            throw new NamingException("no DS [" + ds_name + "] : " + e.getClass().getName() + " : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static javax.sql.DataSource findOrRegisterPsqlDS(InitialContext ic, String ds_name) throws Exception {
        if ("webis2".equals(ds_name)) {
            throw new NamingException("Datasource java:comp/env/jdbc/webis2 not bound");
        }
        Connection webis2 = ConnectionManager.getConnection("webis2");
        Statement pstmt = null;
        HashMap<String, javax.sql.DataSource> hashMap = mutex;
        synchronized (hashMap) {
            ConnectionManager dsc;
            block23: {
                javax.sql.DataSource dataSource;
                dsc = ConnectionManager.getPsqlConnectionDescription(webis2, ds_name);
                javax.sql.DataSource ds = null;
                try {
                    ds = mutex.get("jdbc/" + ds_name);
                    if (ds == null || !dsc.isNotChanged()) break block23;
                    dataSource = ds;
                }
                catch (Exception exception) {
                    // empty catch block
                    break block23;
                }
                return dataSource;
            }
            try {
                ic.createSubcontext("jdbc");
            }
            catch (Exception exception) {
                // empty catch block
            }
            javax.sql.DataSource ret = dsc.getDataSource();
            ic.rebind("jdbc/" + ds_name, (Object)ret);
            pstmt = webis2.prepareStatement("update reporting.datasources set used_time=? where ds_name=?");
            pstmt.setTimestamp(1, new Timestamp(new Date().getTime()));
            pstmt.setString(2, ds_name);
            pstmt.execute();
            log.info((Object)("binding: " + dsc.getBinding()));
            mutex.put("jdbc/" + ds_name, ret);
            javax.sql.DataSource dataSource = ret;
            return dataSource;
            finally {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
                try {
                    webis2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getJndiBindingIfAvailable() {
        String ret = "java:comp/env/jdbc/" + this.ds_name;
        try {
            InitialContext cxt = new InitialContext();
            try {
                if ((javax.sql.DataSource)cxt.lookup(ret) != null) {
                    return ret;
                }
            }
            catch (NamingException e) {
                if (ConnectionManager.findOrRegisterPsqlDS(cxt, this.ds_name) != null) {
                    return "jdbc/" + this.ds_name;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Connection getConnection(String ds_name) throws Exception {
        if (ds_name == null || "".equals(ds_name)) {
            throw new Exception("Cannot get datasource for empty name!");
        }
        InitialContext cxt = new InitialContext();
        javax.sql.DataSource ds = null;
        try {
            try {
                ds = (javax.sql.DataSource)cxt.lookup("java:comp/env/jdbc/" + ds_name);
            }
            catch (NoInitialContextException noIc) {
                return ConnectionManager.getPsqlConnection(ds_name);
            }
            catch (Exception e) {
                ds = ConnectionManager.findOrRegisterPsqlDS(cxt, ds_name);
            }
        }
        catch (Exception e) {
            log.error((Object)("cannot alloc datasource='" + ds_name + "'"), (Throwable)e);
            throw e;
        }
        if (ds == null) {
            throw new Exception("cannto find datasource='" + ds_name + "'");
        }
        Connection con = ds.getConnection();
        if (log.isDebugEnabled()) {
            log.debug((Object)("call ConnectionManager.getConnection(" + ds_name + ") [ds=" + ds.getClass().getName() + "]"));
            if (ds instanceof DataSource) {
                DataSource d2 = (DataSource)ds;
                log.debug((Object)("   ds=" + d2.getName() + "[act=" + d2.getNumActive() + ",idle=" + d2.getNumIdle() + "]"));
            }
        }
        return con;
    }
}

