/*
 * Decompiled with CFR 0.152.
 */
package cz.solnet.inchange;

import cz.solnet.inchange.MemCache;
import cz.solnet.inchange.UserAndGroups;
import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IReportDesign;
import org.eclipse.birt.report.engine.api.script.eventadapter.ReportEventAdapter;

public class InchangeReportEventAdapter
extends ReportEventAdapter {
    UserAndGroups ug;
    static Pattern pattern = Pattern.compile(".*/([^.]*)\\.rptdesign");

    public UserAndGroups getUg() {
        return this.ug;
    }

    public void beforeFactory(IReportDesign report, IReportContext reportContext) {
        Matcher m = pattern.matcher(reportContext.getReportRunnable().getReportName());
        String reportName = m.replaceFirst("$1");
        try {
            super.beforeFactory(report, reportContext);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        HttpServletRequest request = (HttpServletRequest)reportContext.getHttpServletRequest();
        this.ug = MemCache.getPolicy(request, null);
        reportContext.setGlobalVariable("login_id", (Object)this.ug.getCookiestring());
        if (this.ug != null) {
            reportContext.setGlobalVariable("login", (Object)this.ug.getLogin());
            reportContext.setGlobalVariable("user", (Object)this.ug.getUser());
            reportContext.setGlobalVariable("groups", (Object)this.ug.getGroupsString());
            reportContext.setGlobalVariable("report_name", (Object)reportName);
            reportContext.setGlobalVariable("can_i", (Object)this.ug.isPropEnabled("report", reportName));
        } else {
            reportContext.setGlobalVariable("user", (Object)"-NA-");
            reportContext.setGlobalVariable("groups", (Object)"*");
        }
    }
}

